/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.redis.parser;

import java.io.UnsupportedEncodingException;

public class JsonToJedisConverter {
    private static final String DEFAULT_CHARSET = "UTF-8";

    private JsonToJedisConverter() {
    }

    public static final byte[] toByteArray(Object object) {
        if (object instanceof Number) {
            Number number = (Number)object;
            byte[] numberByte = new byte[]{number.byteValue()};
            return numberByte;
        }
        if (object instanceof Boolean) {
            Boolean bool = (Boolean)object;
            try {
                return bool.toString().getBytes(DEFAULT_CHARSET);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (object instanceof String) {
            String stringValue = (String)object;
            try {
                return stringValue.getBytes(DEFAULT_CHARSET);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(e);
            }
        }
        throw new IllegalArgumentException("Class type " + object.getClass() + " is not supported to be converted to byte[].");
    }

    public static final Double toDouble(Object object) {
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        throw new IllegalArgumentException("Class type " + object.getClass() + " is not supported to be converted to Double.");
    }
}

