/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.redis;

import ch.lambdaj.Lambda;
import ch.lambdaj.collection.LambdaCollections;
import com.lordofthejars.nosqlunit.core.FailureHandler;
import com.lordofthejars.nosqlunit.redis.RedisConnectionCallback;
import com.lordofthejars.nosqlunit.redis.parser.JsonToJedisConverter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import redis.clients.jedis.Jedis;

public class RedisAssertion {
    public static void strictAssertEquals(RedisConnectionCallback redisConnectionCallback, InputStream expectedData) {
        Object parse = JSONValue.parse((Reader)new InputStreamReader(expectedData));
        JSONObject rootObject = (JSONObject)parse;
        JSONArray dataObject = (JSONArray)rootObject.get((Object)"data");
        long expectedTotalNumberOfKeys = 0L;
        for (Object object : dataObject) {
            JSONObject elementObject = (JSONObject)object;
            if (elementObject.containsKey((Object)"simple")) {
                expectedTotalNumberOfKeys += RedisAssertion.checkSimpleValues(elementObject, redisConnectionCallback);
                continue;
            }
            if (elementObject.containsKey((Object)"list")) {
                expectedTotalNumberOfKeys += RedisAssertion.checkListsValue(elementObject, redisConnectionCallback);
                continue;
            }
            if (elementObject.containsKey((Object)"sortset")) {
                expectedTotalNumberOfKeys += RedisAssertion.checkSortSetsValue(elementObject, redisConnectionCallback);
                continue;
            }
            if (elementObject.containsKey((Object)"hash")) {
                expectedTotalNumberOfKeys += RedisAssertion.checkHashesValue(elementObject, redisConnectionCallback);
                continue;
            }
            if (!elementObject.containsKey((Object)"set")) continue;
            expectedTotalNumberOfKeys += RedisAssertion.checkSetsValue(elementObject, redisConnectionCallback);
        }
        RedisAssertion.checkNumberOfKeys(redisConnectionCallback, expectedTotalNumberOfKeys);
    }

    private static void checkNumberOfKeys(RedisConnectionCallback redisConnectionCallback, long expectedTotalNumberOfKeys) throws Error {
        long insertedElements = RedisAssertion.countNumberOfAllElements(redisConnectionCallback);
        if (expectedTotalNumberOfKeys != insertedElements) {
            throw FailureHandler.createFailure((String)"Number of expected keys are %s but was found %s.", (Object[])new Object[]{expectedTotalNumberOfKeys, insertedElements});
        }
    }

    private static long countNumberOfAllElements(RedisConnectionCallback redisConnectionCallback) {
        long insertedElements = 0L;
        for (Jedis jedis : redisConnectionCallback.getAllJedis()) {
            insertedElements += jedis.dbSize().longValue();
        }
        return insertedElements;
    }

    private static long checkHashesValue(JSONObject expectedElementObject, RedisConnectionCallback redisConnectionCallback) {
        long numberOfKeys = 0L;
        JSONArray expectedSortsetsObject = (JSONArray)expectedElementObject.get((Object)"hash");
        for (Object object : expectedSortsetsObject) {
            JSONObject expectedHashObject = (JSONObject)object;
            RedisAssertion.checkHashValues(redisConnectionCallback, expectedHashObject);
            ++numberOfKeys;
        }
        return numberOfKeys;
    }

    private static void checkHashValues(RedisConnectionCallback redisConnectionCallback, JSONObject expectedHashObject) {
        Object expectedKey = expectedHashObject.get((Object)"key");
        byte[] key = JsonToJedisConverter.toByteArray(expectedKey);
        Jedis jedis = redisConnectionCallback.getActiveJedis(key);
        RedisAssertion.checkType(jedis, expectedKey, key, "hash");
        JSONArray expectedValuesArray = (JSONArray)expectedHashObject.get((Object)"values");
        Map currentFields = jedis.hgetAll(key);
        RedisAssertion.checkNumberOfFields(key, expectedValuesArray, currentFields);
        RedisAssertion.checkFields(key, expectedValuesArray, currentFields);
    }

    private static void checkFields(byte[] key, JSONArray expectedValuesArray, Map<byte[], byte[]> currentFields) {
        for (Object object : expectedValuesArray) {
            JSONObject expectedField = (JSONObject)object;
            byte[] expectedFieldName = JsonToJedisConverter.toByteArray(expectedField.get((Object)"field"));
            byte[] expectedFieldValue = JsonToJedisConverter.toByteArray(expectedField.get((Object)"value"));
            Set<Map.Entry<byte[], byte[]>> currentFieldsSet = currentFields.entrySet();
            Map.Entry unique = (Map.Entry)LambdaCollections.with(currentFieldsSet).unique((Matcher)Lambda.having(((Map.Entry)Lambda.on(Map.Entry.class)).getKey(), (Matcher)Matchers.equalTo((Object)expectedFieldName)));
            if (unique != null) {
                byte[] currentValue = (byte[])unique.getValue();
                if (Arrays.equals(expectedFieldValue, currentValue)) continue;
                throw FailureHandler.createFailure((String)"Key %s and field %s does not contain element %s but %s.", (Object[])new Object[]{new String(key), new String(expectedFieldName), new String(expectedFieldValue), new String(currentValue)});
            }
            throw FailureHandler.createFailure((String)"Field %s is not found for key %s.", (Object[])new Object[]{new String(expectedFieldName), new String(key)});
        }
    }

    private static void checkNumberOfFields(byte[] key, JSONArray expectedValuesArray, Map<byte[], byte[]> hgetAll) throws Error {
        int numberOfFields;
        int numberExpectedFields = expectedValuesArray.size();
        if (numberExpectedFields != (numberOfFields = hgetAll.size())) {
            throw FailureHandler.createFailure((String)"Expected fields for key %s are %s but %s was found.", (Object[])new Object[]{new String(key), numberExpectedFields, numberOfFields});
        }
    }

    private static long checkSortSetsValue(JSONObject expectedElementObject, RedisConnectionCallback redisConnectionCallback) {
        long numberOfKeys = 0L;
        JSONArray expectedSortsetsObject = (JSONArray)expectedElementObject.get((Object)"sortset");
        for (Object object : expectedSortsetsObject) {
            JSONObject expectedSortsetObject = (JSONObject)object;
            RedisAssertion.checkSortSetValues(redisConnectionCallback, expectedSortsetObject);
            ++numberOfKeys;
        }
        return numberOfKeys;
    }

    private static void checkSortSetValues(RedisConnectionCallback redisConnectionCallback, JSONObject expectedSortsetObject) throws Error {
        Object expectedKey = expectedSortsetObject.get((Object)"key");
        byte[] key = JsonToJedisConverter.toByteArray(expectedKey);
        Jedis jedis = redisConnectionCallback.getActiveJedis(key);
        RedisAssertion.checkType(jedis, expectedKey, key, "zset");
        JSONArray expectedValuesArray = (JSONArray)expectedSortsetObject.get((Object)"values");
        Set currentElements = jedis.zrange(key, 0L, -1L);
        List<byte[]> expectedOrderedValues = RedisAssertion.extractSortValues(expectedValuesArray);
        RedisAssertion.checkListSize(expectedOrderedValues.size(), expectedKey, currentElements.size());
        RedisAssertion.checkSetElementsAndPosition(expectedKey, currentElements, expectedOrderedValues);
    }

    private static void checkSetElementsAndPosition(Object expectedKey, Set<byte[]> zrange, List<byte[]> expectedOrderedValues) throws Error {
        int position = 0;
        for (byte[] value : zrange) {
            if (!Arrays.equals(value, expectedOrderedValues.get(position))) {
                throw FailureHandler.createFailure((String)"Element %s is not found in set with same order of key %s.", (Object[])new Object[]{new String(value), expectedKey});
            }
            ++position;
        }
    }

    private static List<byte[]> extractSortValues(JSONArray expectedValuesArray) {
        TreeSet<SortElement> elementsOrderedByScore = new TreeSet<SortElement>();
        for (Object expectedObject : expectedValuesArray) {
            JSONObject expectedValue = (JSONObject)expectedObject;
            elementsOrderedByScore.add(new SortElement((Number)expectedValue.get((Object)"score"), JsonToJedisConverter.toByteArray(expectedValue.get((Object)"value"))));
        }
        return Lambda.extract(elementsOrderedByScore, (Object)((SortElement)Lambda.on(SortElement.class)).getValue());
    }

    private static long checkSetsValue(JSONObject expectedElementObject, RedisConnectionCallback redisConnectionCallback) {
        long numberOfKeys = 0L;
        JSONArray expectedListsObject = (JSONArray)expectedElementObject.get((Object)"set");
        for (Object object : expectedListsObject) {
            JSONObject expectedListObject = (JSONObject)object;
            RedisAssertion.checkSetValues(redisConnectionCallback, expectedListObject);
            ++numberOfKeys;
        }
        return numberOfKeys;
    }

    private static void checkSetValues(RedisConnectionCallback redisConnectionCallback, JSONObject expectedSetObject) {
        JSONArray expectedValuesArray = (JSONArray)expectedSetObject.get((Object)"values");
        Set<byte[]> expectedSetValues = RedisAssertion.extractSetOfValues(expectedValuesArray);
        Object expectedKey = expectedSetObject.get((Object)"key");
        byte[] key = JsonToJedisConverter.toByteArray(expectedKey);
        Jedis jedis = redisConnectionCallback.getActiveJedis(key);
        RedisAssertion.checkType(jedis, expectedKey, key, "set");
        Set elements = jedis.smembers(key);
        RedisAssertion.checkListSize(expectedSetValues.size(), expectedKey, elements.size());
        RedisAssertion.checkValueInSet(expectedSetValues, expectedKey, elements);
    }

    private static Set<byte[]> extractSetOfValues(JSONArray valuesArray) {
        TreeSet<byte[]> setValues = new TreeSet<byte[]>(new Comparator<byte[]>(){

            @Override
            public int compare(byte[] left, byte[] right) {
                int i = 0;
                int j = 0;
                while (i < left.length && j < right.length) {
                    int a = left[i] & 0xFF;
                    int b = right[j] & 0xFF;
                    if (a != b) {
                        return a - b;
                    }
                    ++i;
                    ++j;
                }
                return left.length - right.length;
            }
        });
        for (Object valueObject : valuesArray) {
            JSONObject jsonValueObject = (JSONObject)valueObject;
            byte[] value = JsonToJedisConverter.toByteArray(jsonValueObject.get((Object)"value"));
            if (setValues.contains(value)) continue;
            setValues.add(value);
        }
        return setValues;
    }

    private static void checkValueInSet(Set<byte[]> expectedListValues, Object expectedKey, Set<byte[]> elements) throws Error {
        for (byte[] bs : elements) {
            if (RedisAssertion.isValuePresent(expectedListValues, bs)) continue;
            throw FailureHandler.createFailure((String)"Element %s is not found in set of key %s.", (Object[])new Object[]{new String(bs), expectedKey});
        }
    }

    private static long checkListsValue(JSONObject expectedElementObject, RedisConnectionCallback redisConnectionCallback) {
        long numberOfKeys = 0L;
        JSONArray expectedListsObject = (JSONArray)expectedElementObject.get((Object)"list");
        for (Object object : expectedListsObject) {
            JSONObject expectedListObject = (JSONObject)object;
            RedisAssertion.checkListValues(redisConnectionCallback, expectedListObject);
            ++numberOfKeys;
        }
        return numberOfKeys;
    }

    private static void checkListValues(RedisConnectionCallback redisConnectionCallback, JSONObject expectedListObject) throws Error {
        JSONArray expectedValuesArray = (JSONArray)expectedListObject.get((Object)"values");
        List<byte[]> expectedListValues = RedisAssertion.extractListOfValues(expectedValuesArray);
        Object expectedKey = expectedListObject.get((Object)"key");
        byte[] key = JsonToJedisConverter.toByteArray(expectedKey);
        Jedis jedis = redisConnectionCallback.getActiveJedis(key);
        RedisAssertion.checkType(jedis, expectedKey, key, "list");
        List elements = jedis.lrange(key, 0L, -1L);
        RedisAssertion.checkListSize(expectedListValues.size(), expectedKey, elements.size());
        RedisAssertion.checkValueInList(expectedListValues, expectedKey, elements);
    }

    private static void checkValueInList(List<byte[]> expectedListValues, Object expectedKey, List<byte[]> elements) throws Error {
        for (byte[] bs : elements) {
            if (RedisAssertion.isValuePresent(expectedListValues, bs)) continue;
            throw FailureHandler.createFailure((String)"Element %s is not found in list of key %s.", (Object[])new Object[]{new String(bs), expectedKey});
        }
    }

    private static void checkListSize(int expectedListValues, Object expectedKey, int lrange) throws Error {
        if (lrange != expectedListValues) {
            throw FailureHandler.createFailure((String)"Expected number of elements for key %s is %s but was counted %s.", (Object[])new Object[]{expectedKey, expectedListValues, lrange});
        }
    }

    private static void checkType(Jedis jedis, Object expectedKey, byte[] key, String expectedType) throws Error {
        String type = jedis.type(key);
        if ("none".equals(type)) {
            throw FailureHandler.createFailure((String)"Key %s is not found.", (Object[])new Object[]{expectedKey});
        }
        if (!expectedType.equals(type)) {
            throw FailureHandler.createFailure((String)"Element with key %s is not a %s.", (Object[])new Object[]{expectedKey, expectedType});
        }
    }

    private static boolean isValuePresent(Iterable<byte[]> expectedValues, byte[] value) {
        for (byte[] expectedBytes : expectedValues) {
            if (!Arrays.equals(expectedBytes, value)) continue;
            return true;
        }
        return false;
    }

    private static List<byte[]> extractListOfValues(JSONArray valuesArray) {
        ArrayList<byte[]> listValues = new ArrayList<byte[]>();
        for (Object valueObject : valuesArray) {
            JSONObject jsonValueObject = (JSONObject)valueObject;
            listValues.add(JsonToJedisConverter.toByteArray(jsonValueObject.get((Object)"value")));
        }
        return listValues;
    }

    private static long checkSimpleValues(JSONObject expectedElementObject, RedisConnectionCallback redisConnectionCallback) {
        long numberOfKeys = 0L;
        JSONArray expectedSimpleElements = (JSONArray)expectedElementObject.get((Object)"simple");
        for (Object expectedSimpleElement : expectedSimpleElements) {
            JSONObject expectedSimpleElementObject = (JSONObject)expectedSimpleElement;
            Object expectedKey = expectedSimpleElementObject.get((Object)"key");
            byte[] key = JsonToJedisConverter.toByteArray(expectedKey);
            Jedis jedis = redisConnectionCallback.getActiveJedis(key);
            RedisAssertion.checkType(jedis, expectedKey, key, "string");
            byte[] value = jedis.get(key);
            byte[] expectedValue = JsonToJedisConverter.toByteArray(expectedSimpleElementObject.get((Object)"value"));
            boolean isExpected = Arrays.equals(value, expectedValue);
            if (!isExpected) {
                throw FailureHandler.createFailure((String)"Key %s does not contain element %s but %s.", (Object[])new Object[]{expectedKey, new String(expectedValue), new String(value)});
            }
            ++numberOfKeys;
        }
        return numberOfKeys;
    }

    private static class SortElement
    implements Comparable<SortElement> {
        private Number score;
        private byte[] value;

        public SortElement(Number score, byte[] value) {
            this.score = score;
            this.value = value;
        }

        public Number getScore() {
            return this.score;
        }

        public byte[] getValue() {
            return this.value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.score == null ? 0 : this.score.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SortElement other = (SortElement)obj;
            return !(this.score == null ? other.score != null : !this.score.equals(other.score));
        }

        @Override
        public int compareTo(SortElement o) {
            double o2;
            double o1 = this.score.doubleValue();
            if (o1 > (o2 = o.score.doubleValue())) {
                return 1;
            }
            if (o1 < o2) {
                return -1;
            }
            return 0;
        }
    }
}

