/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.list;

import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.RtfExtendedElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.list.RtfList;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class RtfListTable
extends RtfElement
implements RtfExtendedElement {
    protected static final byte[] LIST_NUMBER = "\\ls".getBytes();
    private static final byte[] LIST_TABLE = "\\*\\listtable".getBytes();
    private static final byte[] LIST = "\\list".getBytes();
    private static final byte[] LIST_TEMPLATE_ID = "\\listtemplateid".getBytes();
    private static final byte[] LIST_HYBRID = "\\listhybrid".getBytes();
    private static final byte[] LIST_ID = "\\listid".getBytes();
    private static final byte[] LIST_OVERRIDE_TABLE = "\\*\\listoverridetable".getBytes();
    private static final byte[] LIST_OVERRIDE = "\\listoverride".getBytes();
    private static final byte[] LIST_OVERRIDE_COUNT = "\\listoverridecount".getBytes();
    private ArrayList lists = new ArrayList();

    public RtfListTable(RtfDocument rtfDocument) {
        super(rtfDocument);
    }

    public void writeContent(OutputStream outputStream) throws IOException {
    }

    public void writeDefinition(OutputStream outputStream) throws IOException {
        int n;
        int[] nArray = new int[this.lists.size()];
        outputStream.write(OPEN_GROUP);
        outputStream.write(LIST_TABLE);
        outputStream.write("\n".getBytes());
        for (n = 0; n < this.lists.size(); ++n) {
            outputStream.write(OPEN_GROUP);
            outputStream.write(LIST);
            outputStream.write(LIST_TEMPLATE_ID);
            outputStream.write(this.intToByteArray(this.document.getRandomInt()));
            outputStream.write(LIST_HYBRID);
            outputStream.write("\n".getBytes());
            RtfList rtfList = (RtfList)this.lists.get(n);
            rtfList.writeDefinition(outputStream);
            outputStream.write(LIST_ID);
            nArray[n] = this.document.getRandomInt();
            outputStream.write(this.intToByteArray(nArray[n]));
            outputStream.write(CLOSE_GROUP);
            outputStream.write("\n".getBytes());
        }
        outputStream.write(CLOSE_GROUP);
        outputStream.write("\n".getBytes());
        outputStream.write(OPEN_GROUP);
        outputStream.write(LIST_OVERRIDE_TABLE);
        outputStream.write("\n".getBytes());
        for (n = 0; n < this.lists.size(); ++n) {
            outputStream.write(OPEN_GROUP);
            outputStream.write(LIST_OVERRIDE);
            outputStream.write(LIST_ID);
            outputStream.write(this.intToByteArray(nArray[n]));
            outputStream.write(LIST_OVERRIDE_COUNT);
            outputStream.write(this.intToByteArray(0));
            outputStream.write(LIST_NUMBER);
            outputStream.write(this.intToByteArray(((RtfList)this.lists.get(n)).getListNumber()));
            outputStream.write(CLOSE_GROUP);
            outputStream.write("\n".getBytes());
        }
        outputStream.write(CLOSE_GROUP);
        outputStream.write("\n".getBytes());
    }

    public int getListNumber(RtfList rtfList) {
        if (this.lists.contains(rtfList)) {
            return this.lists.indexOf(rtfList);
        }
        this.lists.add(rtfList);
        return this.lists.size();
    }

    public void freeListNumber(RtfList rtfList) {
        int n = this.lists.indexOf(rtfList);
        if (n >= 0) {
            this.lists.remove(n);
        }
    }
}

