/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.document;

import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.RtfMapper;
import com.lowagie.text.rtf.document.RtfDocumentHeader;
import com.lowagie.text.rtf.document.RtfDocumentSettings;
import com.lowagie.text.rtf.document.RtfInfoElement;
import com.lowagie.text.rtf.document.output.RtfDataCache;
import com.lowagie.text.rtf.document.output.RtfDiskCache;
import com.lowagie.text.rtf.document.output.RtfEfficientMemoryCache;
import com.lowagie.text.rtf.document.output.RtfMemoryCache;
import com.lowagie.text.rtf.graphic.RtfImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class RtfDocument
extends RtfElement {
    private RtfDataCache data = new RtfMemoryCache();
    private RtfMapper mapper = new RtfMapper(this);
    private RtfDocumentHeader documentHeader = new RtfDocumentHeader(this);
    private ArrayList previousRandomInts = null;
    private boolean autogenerateTOCEntries = false;
    private RtfDocumentSettings documentSettings = null;
    private RtfBasicElement lastElementWritten = null;
    private static final byte[] RTF_DOCUMENT = "\\rtf1".getBytes();
    private static final byte[] FSC_LINE = "\\line ".getBytes();
    private static final byte[] FSC_PAR = "\\par ".getBytes();
    private static final byte[] FSC_TAB = "\\tab ".getBytes();
    private static final byte[] FSC_PAGE_PAR = "\\page\\par ".getBytes();
    private static final byte[] FSC_NEWPAGE = "$newpage$".getBytes();
    private static final byte[] FSC_BACKSLASH = "\\".getBytes();
    private static final byte[] FSC_HEX_PREFIX = "\\'".getBytes();
    private static final byte[] FSC_UNI_PREFIX = "\\u".getBytes();

    public RtfDocument() {
        super(null);
        this.documentHeader.init();
        this.previousRandomInts = new ArrayList();
        this.documentSettings = new RtfDocumentSettings(this);
    }

    public void writeContent(OutputStream outputStream) throws IOException {
    }

    public void writeDocument(OutputStream outputStream) {
        try {
            outputStream.write(OPEN_GROUP);
            outputStream.write(RTF_DOCUMENT);
            this.documentHeader.writeContent(outputStream);
            this.data.writeTo(outputStream);
            outputStream.write(CLOSE_GROUP);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void open() {
        try {
            switch (this.documentSettings.getDataCacheStyle()) {
                case 3: {
                    this.data = new RtfEfficientMemoryCache();
                    break;
                }
                case 2: {
                    this.data = new RtfMemoryCache();
                    break;
                }
                case 1: {
                    this.data = new RtfDiskCache();
                    break;
                }
                default: {
                    throw new RuntimeException("unknown");
                }
            }
        }
        catch (IOException iOException) {
            System.err.println("Could not initialize disk cache. Using memory cache.");
            iOException.printStackTrace();
            this.data = new RtfMemoryCache();
        }
    }

    public void add(RtfBasicElement rtfBasicElement) {
        try {
            if (rtfBasicElement instanceof RtfInfoElement) {
                this.documentHeader.addInfoElement((RtfInfoElement)rtfBasicElement);
            } else {
                if (rtfBasicElement instanceof RtfImage) {
                    ((RtfImage)rtfBasicElement).setTopLevelElement(true);
                }
                rtfBasicElement.writeContent(this.data.getOutputStream());
                this.lastElementWritten = rtfBasicElement;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public RtfMapper getMapper() {
        return this.mapper;
    }

    public int getRandomInt() {
        Integer n = null;
        while (this.previousRandomInts.contains(n = new Integer((int)(Math.random() * 2.147483647E9)))) {
        }
        this.previousRandomInts.add(n);
        return n;
    }

    public RtfDocumentHeader getDocumentHeader() {
        return this.documentHeader;
    }

    public void filterSpecialChar(OutputStream outputStream, String string, boolean bl, boolean bl2) throws IOException {
        if (outputStream == null) {
            throw new NullPointerException("null OutpuStream");
        }
        boolean bl3 = this.documentSettings.isAlwaysUseUnicode();
        if (string == null) {
            return;
        }
        int n = string.length();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < ' ') {
                if (c == '\n') {
                    outputStream.write(bl2 ? FSC_LINE : FSC_PAR);
                    continue;
                }
                if (c == '\t') {
                    outputStream.write(FSC_TAB);
                    continue;
                }
                outputStream.write(63);
                continue;
            }
            if (c == '\\' || c == '{' || c == '}') {
                outputStream.write(FSC_BACKSLASH);
                outputStream.write(c);
                continue;
            }
            if (c == '$' && n - i >= FSC_NEWPAGE.length && RtfDocument.subMatch(string, i, FSC_NEWPAGE)) {
                outputStream.write(FSC_PAGE_PAR);
                i += FSC_NEWPAGE.length - 1;
                continue;
            }
            if (c > '\u00ff' || c > 'z' && bl3) {
                if (bl && c <= '\u00ff') {
                    outputStream.write(FSC_HEX_PREFIX);
                    outputStream.write(RtfImage.byte2charLUT, c * 2, 2);
                    continue;
                }
                outputStream.write(FSC_UNI_PREFIX);
                String string2 = Short.toString((short)c);
                for (int j = 0; j < string2.length(); ++j) {
                    outputStream.write(string2.charAt(j));
                }
                outputStream.write(63);
                continue;
            }
            outputStream.write(c);
        }
    }

    private static boolean subMatch(String string, int n, byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            if (string.charAt(n++) == byArray[i]) continue;
            return false;
        }
        return true;
    }

    public void setAutogenerateTOCEntries(boolean bl) {
        this.autogenerateTOCEntries = bl;
    }

    public boolean getAutogenerateTOCEntries() {
        return this.autogenerateTOCEntries;
    }

    public RtfDocumentSettings getDocumentSettings() {
        return this.documentSettings;
    }

    public RtfBasicElement getLastElementWritten() {
        return this.lastElementWritten;
    }

    public final void outputDebugLinebreak(OutputStream outputStream) throws IOException {
        if (this.getDocumentSettings().isOutputDebugLineBreaks()) {
            outputStream.write(10);
        }
    }
}

