/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.style;

import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.RtfExtendedElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfParagraphStyle;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;

public class RtfStylesheetList
extends RtfElement
implements RtfExtendedElement {
    private HashMap styleMap = new HashMap();
    private boolean defaultsLoaded = false;

    public RtfStylesheetList(RtfDocument rtfDocument) {
        super(rtfDocument);
    }

    public void writeContent(OutputStream outputStream) throws IOException {
    }

    public void registerParagraphStyle(RtfParagraphStyle rtfParagraphStyle) {
        RtfParagraphStyle rtfParagraphStyle2 = new RtfParagraphStyle(this.document, rtfParagraphStyle);
        rtfParagraphStyle2.handleInheritance();
        rtfParagraphStyle2.setStyleNumber(this.styleMap.size());
        this.styleMap.put(rtfParagraphStyle2.getStyleName(), rtfParagraphStyle2);
    }

    private void registerDefaultStyles() {
        this.defaultsLoaded = true;
        if (!this.styleMap.containsKey(RtfParagraphStyle.STYLE_NORMAL.getStyleName())) {
            this.registerParagraphStyle(RtfParagraphStyle.STYLE_NORMAL);
        }
        if (!this.styleMap.containsKey(RtfParagraphStyle.STYLE_HEADING_1.getStyleName())) {
            this.registerParagraphStyle(RtfParagraphStyle.STYLE_HEADING_1);
        }
        if (!this.styleMap.containsKey(RtfParagraphStyle.STYLE_HEADING_2.getStyleName())) {
            this.registerParagraphStyle(RtfParagraphStyle.STYLE_HEADING_2);
        }
        if (!this.styleMap.containsKey(RtfParagraphStyle.STYLE_HEADING_3.getStyleName())) {
            this.registerParagraphStyle(RtfParagraphStyle.STYLE_HEADING_3);
        }
    }

    public RtfParagraphStyle getRtfParagraphStyle(String string) {
        if (!this.defaultsLoaded) {
            this.registerDefaultStyles();
        }
        if (this.styleMap.containsKey(string)) {
            return (RtfParagraphStyle)this.styleMap.get(string);
        }
        return null;
    }

    public void writeDefinition(OutputStream outputStream) throws IOException {
        outputStream.write("{".getBytes());
        outputStream.write("\\stylesheet".getBytes());
        outputStream.write(RtfBasicElement.DELIMITER);
        this.document.outputDebugLinebreak(outputStream);
        Iterator iterator = this.styleMap.values().iterator();
        while (iterator.hasNext()) {
            RtfParagraphStyle rtfParagraphStyle = (RtfParagraphStyle)iterator.next();
            rtfParagraphStyle.writeDefinition(outputStream);
        }
        outputStream.write("}".getBytes());
        this.document.outputDebugLinebreak(outputStream);
    }
}

