/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.rups.controller;

import com.lowagie.rups.controller.RupsController;
import com.lowagie.rups.model.ObjectLoader;
import com.lowagie.rups.model.PdfFile;
import com.lowagie.rups.model.TreeNodeFactory;
import com.lowagie.rups.view.PageNavigationListener;
import com.lowagie.rups.view.itext.FormTree;
import com.lowagie.rups.view.itext.OutlineTree;
import com.lowagie.rups.view.itext.PagesTable;
import com.lowagie.rups.view.itext.PdfObjectPanel;
import com.lowagie.rups.view.itext.PdfTree;
import com.lowagie.rups.view.itext.StreamTextArea;
import com.lowagie.rups.view.itext.XRefTable;
import com.lowagie.rups.view.itext.treenodes.PdfObjectTreeNode;
import com.lowagie.rups.view.itext.treenodes.PdfTrailerTreeNode;
import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PdfObject;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JTabbedPane;
import javax.swing.event.TreeSelectionListener;

public class PdfReaderController
extends Observable
implements Observer {
    protected PdfTree pdfTree = new PdfTree();
    protected JTabbedPane navigationTabs;
    protected PagesTable pages;
    protected OutlineTree outlines;
    protected FormTree form;
    protected XRefTable xref;
    protected PdfObjectPanel objectPanel;
    protected JTabbedPane editorTabs;
    protected StreamTextArea streamArea;
    protected TreeNodeFactory nodes;

    public PdfReaderController(TreeSelectionListener treeSelectionListener, PageNavigationListener pageNavigationListener) {
        this.pdfTree.addTreeSelectionListener(treeSelectionListener);
        this.addObserver(this.pdfTree);
        this.pages = new PagesTable(this, pageNavigationListener);
        this.addObserver(this.pages);
        this.outlines = new OutlineTree(this);
        this.addObserver(this.outlines);
        this.form = new FormTree(this);
        this.addObserver(this.form);
        this.xref = new XRefTable(this);
        this.addObserver(this.xref);
        this.navigationTabs = new JTabbedPane();
        this.navigationTabs.addTab("Pages", null, RupsController.getScrollPane(this.pages), "Pages");
        this.navigationTabs.addTab("Outlines", null, RupsController.getScrollPane(this.outlines), "Outlines (Bookmarks)");
        this.navigationTabs.addTab("Form", null, RupsController.getScrollPane(this.form), "Interactive Form");
        this.navigationTabs.addTab("XFA", null, this.form.getXfaTree(), "Tree view of the XFA form");
        this.navigationTabs.addTab("XRef", null, RupsController.getScrollPane(this.xref), "Cross-reference table");
        this.objectPanel = new PdfObjectPanel();
        this.addObserver(this.objectPanel);
        this.streamArea = new StreamTextArea();
        this.addObserver(this.streamArea);
        this.editorTabs = new JTabbedPane();
        this.editorTabs.addTab("Stream", null, this.streamArea, "Stream");
        this.editorTabs.addTab("XFA", null, this.form.getXfaTextArea(), "XFA Form XML file");
    }

    public PdfTree getPdfTree() {
        return this.pdfTree;
    }

    public JTabbedPane getNavigationTabs() {
        return this.navigationTabs;
    }

    public PdfObjectPanel getObjectPanel() {
        return this.objectPanel;
    }

    public JTabbedPane getEditorTabs() {
        return this.editorTabs;
    }

    public StreamTextArea getStreamArea() {
        return this.streamArea;
    }

    public void startObjectLoader(PdfFile pdfFile) {
        this.setChanged();
        this.notifyObservers();
        this.setChanged();
        new ObjectLoader(this, pdfFile.getPdfReader());
    }

    public void notifyObservers(Object object) {
        if (object instanceof ObjectLoader) {
            ObjectLoader objectLoader = (ObjectLoader)object;
            this.nodes = objectLoader.getNodes();
            PdfTrailerTreeNode pdfTrailerTreeNode = this.pdfTree.getRoot();
            pdfTrailerTreeNode.setTrailer(objectLoader.getReader().getTrailer());
            pdfTrailerTreeNode.setUserObject("PDF Object Tree");
            this.nodes.expandNode(pdfTrailerTreeNode);
        }
        super.notifyObservers(object);
    }

    public void selectNode(PdfObjectTreeNode pdfObjectTreeNode) {
        this.pdfTree.selectNode(pdfObjectTreeNode);
    }

    public void selectNode(int n) {
        this.selectNode(this.nodes.getNode(n));
    }

    public void render(PdfObject pdfObject) {
        this.objectPanel.render(pdfObject);
        this.streamArea.render(pdfObject);
        if (pdfObject instanceof PRStream) {
            this.editorTabs.setSelectedComponent(this.streamArea);
        } else {
            this.editorTabs.setSelectedIndex(this.editorTabs.getComponentCount() - 1);
        }
    }

    public void gotoPage(int n) {
        if (this.pages == null || this.pages.getSelectedRow() == --n) {
            return;
        }
        if (n < this.pages.getRowCount()) {
            this.pages.setRowSelectionInterval(n, n);
        }
    }

    public void update(Observable observable, Object object) {
        if ("Close".equals(object)) {
            this.setChanged();
            this.notifyObservers(null);
            this.nodes = null;
        }
        if (object instanceof PdfObjectTreeNode) {
            PdfObjectTreeNode pdfObjectTreeNode = (PdfObjectTreeNode)object;
            this.nodes.expandNode(pdfObjectTreeNode);
            if (pdfObjectTreeNode.isRecursive()) {
                this.pdfTree.selectNode(pdfObjectTreeNode.getAncestor());
                return;
            }
            if (pdfObjectTreeNode.isIndirect()) {
                this.xref.selectRowByReference(pdfObjectTreeNode.getNumber());
                return;
            }
            this.render(pdfObjectTreeNode.getPdfObject());
        }
    }
}

