/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.rups.controller;

import com.lowagie.rups.model.PageLoader;
import com.lowagie.rups.model.PdfFile;
import com.lowagie.rups.view.PageNavigationListener;
import com.lowagie.rups.view.renderer.PagePanel;
import com.lowagie.rups.view.renderer.ToolBar;
import java.awt.Component;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JSplitPane;

public class PdfRendererController
extends JSplitPane
implements Observer {
    protected PageLoader pageLoader = null;
    protected ToolBar toolbar;
    protected PagePanel pagePanel;
    private static final long serialVersionUID = 3270054619281094248L;

    public PdfRendererController(PageNavigationListener pageNavigationListener) {
        this.setOrientation(0);
        this.setDividerLocation(33);
        this.setDividerSize(0);
        this.pagePanel = new PagePanel();
        this.toolbar = new ToolBar(pageNavigationListener);
        this.add((Component)this.toolbar, "top");
        this.add((Component)this.pagePanel, "bottom");
    }

    public void startPageLoader(PdfFile pdfFile) {
        this.pageLoader = new PageLoader(pdfFile.getPDFFile());
        this.gotoPage(1);
    }

    protected int showPage(int n) {
        if (this.pageLoader == null) {
            return -1;
        }
        this.pagePanel.showPage(this.pageLoader.loadPage(n));
        this.pagePanel.requestFocus();
        return n;
    }

    public int getTotalNumberOfPages() {
        if (this.pageLoader == null) {
            return 0;
        }
        return this.pageLoader.getNumberOfPages();
    }

    public int getCurrentPageNumber() {
        return this.pagePanel.getCurrentPageNumber();
    }

    public int gotoPage(int n) {
        if (n == this.getCurrentPageNumber()) {
            return n;
        }
        if (n < 0) {
            this.toolbar.setPageNumber(-1);
            return -1;
        }
        if (n == 0) {
            n = 1;
        } else if (n > this.getTotalNumberOfPages()) {
            n = this.getTotalNumberOfPages();
        }
        n = this.showPage(n);
        this.toolbar.setPageNumber(n);
        return n;
    }

    public void update(Observable observable, Object object) {
        if ("Close".equals(object)) {
            this.pageLoader = null;
            this.pagePanel.showPage(null);
            this.toolbar.setPageNumber(-1);
        }
    }
}

