/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.rups.controller;

import com.lowagie.rups.controller.PdfReaderController;
import com.lowagie.rups.controller.PdfRendererController;
import com.lowagie.rups.io.FileChooserAction;
import com.lowagie.rups.io.FileCloseAction;
import com.lowagie.rups.model.PdfFile;
import com.lowagie.rups.view.Console;
import com.lowagie.rups.view.PageNavigationListener;
import com.lowagie.rups.view.RupsMenuBar;
import com.lowagie.rups.view.itext.treenodes.PdfObjectTreeNode;
import com.lowagie.rups.view.itext.treenodes.PdfTrailerTreeNode;
import com.lowagie.text.DocumentException;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.Observable;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class RupsController
extends Observable
implements TreeSelectionListener,
PageNavigationListener {
    protected PdfFile pdfFile;
    protected RupsMenuBar menuBar = new RupsMenuBar(this);
    protected JSplitPane masterComponent;
    protected PdfRendererController renderer;
    protected PdfReaderController reader;

    public RupsController(Dimension dimension) {
        this.addObserver(this.menuBar);
        Console console = Console.getInstance();
        this.addObserver(console);
        this.renderer = new PdfRendererController(this);
        this.addObserver(this.renderer);
        this.reader = new PdfReaderController(this, this);
        this.addObserver(this.reader);
        this.masterComponent = new JSplitPane();
        this.masterComponent.setOrientation(0);
        this.masterComponent.setDividerLocation((int)(dimension.getHeight() * 0.7));
        this.masterComponent.setDividerSize(2);
        JSplitPane jSplitPane = new JSplitPane();
        this.masterComponent.add((Component)jSplitPane, "top");
        JSplitPane jSplitPane2 = new JSplitPane();
        this.masterComponent.add((Component)jSplitPane2, "bottom");
        jSplitPane.setOrientation(1);
        jSplitPane.setDividerLocation((int)(dimension.getWidth() * 0.75));
        jSplitPane.setDividerSize(1);
        JSplitPane jSplitPane3 = new JSplitPane();
        jSplitPane.add((Component)jSplitPane3, "left");
        jSplitPane.add((Component)this.reader.getNavigationTabs(), "right");
        jSplitPane3.setOrientation(1);
        jSplitPane3.setDividerLocation((int)(dimension.getWidth() * 0.35));
        jSplitPane3.setDividerSize(1);
        jSplitPane3.add((Component)this.renderer, "right");
        jSplitPane3.add((Component)RupsController.getScrollPane(this.reader.getPdfTree()), "left");
        jSplitPane2.setDividerLocation((int)(dimension.getWidth() * 0.3));
        jSplitPane2.setDividerSize(1);
        jSplitPane2.add((Component)this.reader.getObjectPanel(), "left");
        JTabbedPane jTabbedPane = this.reader.getEditorTabs();
        JScrollPane jScrollPane = RupsController.getScrollPane(console.getTextArea());
        jTabbedPane.addTab("Console", null, jScrollPane, "Console window (System.out/System.err)");
        jTabbedPane.setSelectedComponent(jScrollPane);
        jSplitPane2.add((Component)jTabbedPane, "right");
    }

    public RupsMenuBar getMenuBar() {
        return this.menuBar;
    }

    public Component getMasterComponent() {
        return this.masterComponent;
    }

    public void notifyObservers(Object object) {
        if (object instanceof FileChooserAction) {
            File file = ((FileChooserAction)object).getFile();
            try {
                this.pdfFile = new PdfFile(file);
                this.setChanged();
                super.notifyObservers("Open");
                this.renderer.startPageLoader(this.pdfFile);
                this.reader.startObjectLoader(this.pdfFile);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this.masterComponent, iOException.getMessage(), "Dialog", 0);
            }
            catch (DocumentException documentException) {
                JOptionPane.showMessageDialog(this.masterComponent, documentException.getMessage(), "Dialog", 0);
            }
            return;
        }
        if (object instanceof FileCloseAction) {
            this.pdfFile = null;
            this.setChanged();
            super.notifyObservers("Close");
            return;
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        Object object = this.reader.getPdfTree().getLastSelectedPathComponent();
        if (object instanceof PdfTrailerTreeNode) {
            this.menuBar.update(this, "File");
            return;
        }
        if (object instanceof PdfObjectTreeNode) {
            this.reader.update(this, object);
        }
    }

    public int getCurrentPageNumber() {
        return this.renderer.getCurrentPageNumber();
    }

    public int getTotalNumberOfPages() {
        return this.renderer.getTotalNumberOfPages();
    }

    public int gotoFirstPage() {
        return this.gotoPage(1);
    }

    public int gotoPreviousPage() {
        return this.gotoPage(this.getCurrentPageNumber() - 1);
    }

    public int gotoPage(int n) {
        n = this.renderer.gotoPage(n);
        this.reader.gotoPage(n);
        return n;
    }

    public int gotoNextPage() {
        return this.gotoPage(this.getCurrentPageNumber() + 1);
    }

    public int gotoLastPage() {
        return this.gotoPage(this.getTotalNumberOfPages());
    }

    public static JScrollPane getScrollPane(Component component) {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(component);
        return jScrollPane;
    }
}

