/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.rups.model;

import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNull;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import java.util.ArrayList;

public class IndirectObjectFactory {
    protected PdfReader reader;
    protected int current;
    protected int n;
    protected ArrayList<PdfObject> objects = new ArrayList();
    protected IntHashtable idxToRef = new IntHashtable();
    protected IntHashtable refToIdx = new IntHashtable();

    public IndirectObjectFactory(PdfReader pdfReader) {
        this.reader = pdfReader;
        this.current = -1;
        this.n = pdfReader.getXrefSize();
    }

    public int getCurrent() {
        return this.current;
    }

    public int getXRefMaximum() {
        return this.n;
    }

    public boolean storeNextObject() {
        while (this.current < this.n) {
            ++this.current;
            PdfObject pdfObject = this.reader.getPdfObjectRelease(this.current);
            if (pdfObject == null) continue;
            int n = this.size();
            this.idxToRef.put(n, this.current);
            this.refToIdx.put(this.current, n);
            this.store(pdfObject);
            return true;
        }
        return false;
    }

    private void store(PdfObject pdfObject) {
        PdfDictionary pdfDictionary;
        if (pdfObject.isDictionary() && PdfName.PAGE.equals((Object)(pdfDictionary = (PdfDictionary)pdfObject).get(PdfName.TYPE))) {
            this.objects.add((PdfObject)pdfDictionary);
            return;
        }
        this.objects.add((PdfObject)PdfNull.PDFNULL);
    }

    public int size() {
        return this.objects.size();
    }

    public int getIndexByRef(int n) {
        return this.refToIdx.get(n);
    }

    public int getRefByIndex(int n) {
        return this.idxToRef.get(n);
    }

    public PdfObject getObjectByIndex(int n) {
        return this.getObjectByReference(this.getRefByIndex(n));
    }

    public PdfObject getObjectByReference(int n) {
        return this.objects.get(this.getIndexByRef(n));
    }

    public PdfObject loadObjectByReference(int n) {
        PdfObject pdfObject = this.getObjectByReference(n);
        if (pdfObject instanceof PdfNull) {
            int n2 = this.getIndexByRef(n);
            pdfObject = this.reader.getPdfObject(n);
            this.objects.set(n2, pdfObject);
        }
        return pdfObject;
    }
}

