/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.rups.model;

import com.lowagie.rups.model.BackgroundTask;
import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPage;

public class PageLoader
extends BackgroundTask {
    protected PDFFile file;
    protected int numberOfPages;
    protected boolean[] busy;
    protected boolean[] done;

    public PageLoader(PDFFile pDFFile) {
        this.file = pDFFile;
        this.numberOfPages = pDFFile.getNumPages();
        this.busy = new boolean[this.numberOfPages];
        this.done = new boolean[this.numberOfPages];
        this.start();
    }

    public int getNumberOfPages() {
        return this.numberOfPages;
    }

    public synchronized PDFPage loadPage(int n) {
        if (this.busy[--n]) {
            return null;
        }
        this.busy[n] = true;
        PDFPage pDFPage = this.file.getPage(n + 1, true);
        if (!this.done[n]) {
            System.out.println("Loading page " + (n + 1));
        }
        this.done[n] = true;
        this.busy[n] = false;
        return pDFPage;
    }

    public void doTask() {
        for (int i = 0; i < this.numberOfPages; ++i) {
            this.loadPage(i + 1);
        }
    }
}

