/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.rups.model;

import com.lowagie.rups.model.Permissions;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BadPasswordException;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.sun.pdfview.PDFFile;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;

public class PdfFile {
    protected File directory = null;
    protected String filename = null;
    protected PdfReader reader = null;
    protected PDFFile PDFFile = null;
    protected Permissions permissions = null;

    public PdfFile(File file) throws IOException, DocumentException {
        if (file == null) {
            throw new IOException("No file selected.");
        }
        RandomAccessFileOrArray randomAccessFileOrArray = new RandomAccessFileOrArray(file.getAbsolutePath());
        this.directory = file.getParentFile();
        this.filename = file.getName();
        this.readFile(randomAccessFileOrArray);
    }

    public PdfFile(byte[] byArray) throws IOException, DocumentException {
        RandomAccessFileOrArray randomAccessFileOrArray = new RandomAccessFileOrArray(byArray);
        this.readFile(randomAccessFileOrArray);
    }

    protected void readFile(RandomAccessFileOrArray randomAccessFileOrArray) throws IOException, DocumentException {
        this.permissions = new Permissions();
        try {
            this.reader = new PdfReader(randomAccessFileOrArray, null);
            this.permissions.setEncrypted(false);
        }
        catch (BadPasswordException badPasswordException) {
            JPasswordField jPasswordField = new JPasswordField(32);
            JOptionPane.showConfirmDialog(null, jPasswordField, "Enter the User or Owner Password of this PDF file", 2);
            byte[] byArray = new String(jPasswordField.getPassword()).getBytes();
            this.reader = new PdfReader(randomAccessFileOrArray, byArray);
            this.permissions.setEncrypted(true);
            this.permissions.setCryptoMode(this.reader.getCryptoMode());
            this.permissions.setPermissions(this.reader.getPermissions());
            if (this.reader.isOpenedWithFullPermissions()) {
                this.permissions.setOwnerPassword(byArray);
                this.permissions.setUserPassword(this.reader.computeUserPassword());
            }
            throw new IOException("You need the owner password of this file to open it in iText Trapeze.");
        }
        if (this.permissions.isEncrypted()) {
            randomAccessFileOrArray = this.workAround();
        }
        randomAccessFileOrArray.reOpen();
        try {
            this.PDFFile = new PDFFile(randomAccessFileOrArray.getNioByteBuffer());
        }
        catch (IOException iOException) {
            this.PDFFile = new PDFFile(this.workAround().getNioByteBuffer());
        }
        randomAccessFileOrArray.close();
    }

    protected RandomAccessFileOrArray workAround() throws DocumentException, IOException {
        if (this.directory == null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PdfStamper pdfStamper = new PdfStamper(this.reader, (OutputStream)byteArrayOutputStream);
            pdfStamper.close();
            return new RandomAccessFileOrArray(byteArrayOutputStream.toByteArray());
        }
        File file = File.createTempFile(this.filename.substring(0, this.filename.lastIndexOf(".pdf")) + "~", ".pdf", this.directory);
        file.deleteOnExit();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        PdfStamper pdfStamper = new PdfStamper(this.reader, (OutputStream)fileOutputStream);
        pdfStamper.close();
        return new RandomAccessFileOrArray(file.getAbsolutePath());
    }

    public PdfReader getPdfReader() {
        return this.reader;
    }

    public PDFFile getPDFFile() {
        return this.PDFFile;
    }
}

