/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.rups.model;

import com.lowagie.rups.model.IndirectObjectFactory;
import com.lowagie.rups.view.itext.treenodes.PdfObjectTreeNode;
import com.lowagie.rups.view.itext.treenodes.PdfPagesTreeNode;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNull;
import com.lowagie.text.pdf.PdfObject;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.tree.TreeNode;

public class TreeNodeFactory {
    protected IndirectObjectFactory objects;
    protected ArrayList<PdfObjectTreeNode> nodes = new ArrayList();

    public TreeNodeFactory(IndirectObjectFactory indirectObjectFactory) {
        this.objects = indirectObjectFactory;
        for (int i = 0; i < indirectObjectFactory.size(); ++i) {
            int n = indirectObjectFactory.getRefByIndex(i);
            this.nodes.add(PdfObjectTreeNode.getInstance((PdfObject)PdfNull.PDFNULL, n));
        }
    }

    public PdfObjectTreeNode getNode(int n) {
        int n2 = this.objects.getIndexByRef(n);
        PdfObjectTreeNode pdfObjectTreeNode = this.nodes.get(n2);
        if (pdfObjectTreeNode.getPdfObject().isNull()) {
            pdfObjectTreeNode = PdfObjectTreeNode.getInstance(this.objects.loadObjectByReference(n), n);
            this.nodes.set(n2, pdfObjectTreeNode);
        }
        return pdfObjectTreeNode;
    }

    public void expandNode(PdfObjectTreeNode pdfObjectTreeNode) {
        if (pdfObjectTreeNode.getChildCount() > 0) {
            return;
        }
        PdfObject pdfObject = pdfObjectTreeNode.getPdfObject();
        switch (pdfObject.type()) {
            case 10: {
                PdfIndirectReference pdfIndirectReference = (PdfIndirectReference)pdfObject;
                PdfObjectTreeNode pdfObjectTreeNode2 = this.getNode(pdfIndirectReference.getNumber());
                this.addNodes(pdfObjectTreeNode, pdfObjectTreeNode2);
                if (pdfObjectTreeNode2 instanceof PdfPagesTreeNode) {
                    this.expandNode(pdfObjectTreeNode2);
                }
                return;
            }
            case 5: {
                PdfArray pdfArray = (PdfArray)pdfObject;
                Iterator iterator = pdfArray.getArrayList().iterator();
                while (iterator.hasNext()) {
                    PdfObjectTreeNode pdfObjectTreeNode3 = PdfObjectTreeNode.getInstance((PdfObject)iterator.next());
                    this.addNodes(pdfObjectTreeNode, pdfObjectTreeNode3);
                    this.expandNode(pdfObjectTreeNode3);
                }
                return;
            }
            case 6: 
            case 7: {
                PdfDictionary pdfDictionary = (PdfDictionary)pdfObject;
                Iterator iterator = pdfDictionary.getKeys().iterator();
                while (iterator.hasNext()) {
                    PdfObjectTreeNode pdfObjectTreeNode4 = PdfObjectTreeNode.getInstance(pdfDictionary, (PdfName)iterator.next());
                    this.addNodes(pdfObjectTreeNode, pdfObjectTreeNode4);
                    this.expandNode(pdfObjectTreeNode4);
                }
                return;
            }
        }
    }

    public PdfObjectTreeNode getChildNode(PdfObjectTreeNode pdfObjectTreeNode, PdfName pdfName) {
        Enumeration<TreeNode> enumeration = pdfObjectTreeNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            PdfObjectTreeNode pdfObjectTreeNode2 = (PdfObjectTreeNode)enumeration.nextElement();
            if (!pdfObjectTreeNode2.isDictionaryNode(pdfName)) continue;
            if (pdfObjectTreeNode2.isIndirectReference()) {
                this.expandNode(pdfObjectTreeNode2);
                pdfObjectTreeNode2 = (PdfObjectTreeNode)pdfObjectTreeNode2.getFirstChild();
            }
            this.expandNode(pdfObjectTreeNode2);
            return pdfObjectTreeNode2;
        }
        return null;
    }

    private void addNodes(PdfObjectTreeNode pdfObjectTreeNode, PdfObjectTreeNode pdfObjectTreeNode2) {
        try {
            pdfObjectTreeNode.add(pdfObjectTreeNode2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            pdfObjectTreeNode.setRecursive(true);
        }
    }
}

