/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.rups.view;

import java.awt.Color;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class Console
implements Observer {
    private static Console console = null;
    PrintStream printStream;
    PipedOutputStream poCustom;
    PipedInputStream piCustom;
    PipedOutputStream poOut;
    PipedInputStream piOut;
    PipedOutputStream poErr;
    PipedInputStream piErr;
    ConsoleStyleContext styleContext = new ConsoleStyleContext();
    JTextPane textArea = new JTextPane(new DefaultStyledDocument(this.styleContext));

    private Console() throws IOException {
        this.piCustom = new PipedInputStream();
        this.poCustom = new PipedOutputStream();
        this.printStream = new PrintStream(this.poCustom);
        this.piOut = new PipedInputStream();
        this.poOut = new PipedOutputStream(this.piOut);
        System.setOut(new PrintStream(this.poOut, true));
        this.piErr = new PipedInputStream();
        this.poErr = new PipedOutputStream(this.piErr);
        System.setErr(new PrintStream(this.poErr, true));
        this.textArea.setEditable(false);
        new ReadWriteThread(this.piCustom, "Custom").start();
        new ReadWriteThread(this.piOut, "SystemOut").start();
        new ReadWriteThread(this.piErr, "SystemErr").start();
    }

    public static synchronized Console getInstance() {
        if (console == null) {
            try {
                console = new Console();
            }
            catch (IOException iOException) {
                console = null;
            }
        }
        return console;
    }

    public void update(Observable observable, Object object) {
        if ("Close".equals(object)) {
            this.textArea.setText("");
        }
        if ("Open".equals(object)) {
            this.textArea.setText("");
        }
    }

    public static void println(String string) {
        PrintStream printStream = Console.getInstance().getPrintStream();
        if (printStream == null) {
            System.out.println(string);
        } else {
            printStream.println(string);
            printStream.flush();
        }
    }

    public PrintStream getPrintStream() {
        return this.printStream;
    }

    public JTextPane getTextArea() {
        return this.textArea;
    }

    class ConsoleStyleContext
    extends StyleContext {
        private static final long serialVersionUID = 7253870053566811171L;
        public static final String CUSTOM = "Custom";
        public static final String SYSTEMOUT = "SystemOut";
        public static final String SYSTEMERR = "SystemErr";

        public ConsoleStyleContext() {
            Style style = this.getStyle("default");
            Style style2 = this.addStyle(CUSTOM, style);
            StyleConstants.setForeground(style2, Color.BLACK);
            style2 = this.addStyle(SYSTEMOUT, style);
            StyleConstants.setForeground(style2, Color.GREEN);
            style2 = this.addStyle(SYSTEMERR, style);
            StyleConstants.setForeground(style2, Color.RED);
        }
    }

    class ReadWriteThread
    extends Thread {
        PipedInputStream pi;
        String type;

        ReadWriteThread(PipedInputStream pipedInputStream, String string) {
            this.pi = pipedInputStream;
            this.type = string;
        }

        public void run() {
            byte[] byArray = new byte[1024];
            while (true) {
                try {
                    int n;
                    while ((n = this.pi.read(byArray)) != -1) {
                        Document document = Console.this.textArea.getDocument();
                        Style style = Console.this.styleContext.getStyle(this.type);
                        String string = new String(byArray, 0, n);
                        document.insertString(document.getLength(), string, style);
                        Console.this.printStream.print(string);
                        Console.this.textArea.setCaretPosition(Console.this.textArea.getDocument().getLength());
                    }
                }
                catch (BadLocationException badLocationException) {
                    continue;
                }
                catch (IOException iOException) {
                    continue;
                }
                break;
            }
        }
    }
}

