/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.rups.view;

import com.lowagie.rups.io.FileChooserAction;
import com.lowagie.rups.io.FileCloseAction;
import com.lowagie.rups.io.filters.PdfFilter;
import com.lowagie.rups.view.MessageAction;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Box;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class RupsMenuBar
extends JMenuBar
implements Observer {
    public static final String FILE_MENU = "File";
    public static final String OPEN = "Open";
    public static final String CLOSE = "Close";
    public static final String HELP_MENU = "Help";
    public static final String ABOUT = "About";
    public static final String VERSIONS = "Versions";
    protected Observable observable;
    protected FileChooserAction fileChooserAction;
    protected HashMap<String, JMenuItem> items;
    private static final long serialVersionUID = 6403040037592308742L;

    public RupsMenuBar(Observable observable) {
        this.observable = observable;
        this.items = new HashMap();
        this.fileChooserAction = new FileChooserAction(observable, OPEN, PdfFilter.INSTANCE, false);
        MessageAction messageAction = new MessageAction();
        JMenu jMenu = new JMenu(FILE_MENU);
        this.addItem(jMenu, OPEN, this.fileChooserAction);
        this.addItem(jMenu, CLOSE, new FileCloseAction(observable));
        this.add(jMenu);
        this.add(Box.createGlue());
        JMenu jMenu2 = new JMenu(HELP_MENU);
        this.addItem(jMenu2, ABOUT, messageAction);
        this.addItem(jMenu2, VERSIONS, messageAction);
        this.add(jMenu2);
        this.enableItems(false);
    }

    public void update(Observable observable, Object object) {
        if (OPEN.equals(object)) {
            this.enableItems(true);
            return;
        }
        if (CLOSE.equals(object)) {
            this.enableItems(false);
            return;
        }
        if (FILE_MENU.equals(object)) {
            this.fileChooserAction.actionPerformed(null);
        }
    }

    protected void addItem(JMenu jMenu, String string, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(actionListener);
        jMenu.add(jMenuItem);
        this.items.put(string, jMenuItem);
    }

    protected void enableItems(boolean bl) {
        this.enableItem(CLOSE, bl);
    }

    protected void enableItem(String string, boolean bl) {
        this.items.get(string).setEnabled(bl);
    }
}

