/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.rups.view.itext;

import com.lowagie.rups.controller.PdfReaderController;
import com.lowagie.rups.model.ObjectLoader;
import com.lowagie.rups.model.TreeNodeFactory;
import com.lowagie.rups.model.XfaFile;
import com.lowagie.rups.view.icons.IconTreeCellRenderer;
import com.lowagie.rups.view.icons.IconTreeNode;
import com.lowagie.rups.view.itext.XfaTextArea;
import com.lowagie.rups.view.itext.XfaTree;
import com.lowagie.rups.view.itext.treenodes.FormTreeNode;
import com.lowagie.rups.view.itext.treenodes.PdfObjectTreeNode;
import com.lowagie.rups.view.itext.treenodes.PdfTrailerTreeNode;
import com.lowagie.rups.view.itext.treenodes.XfaTreeNode;
import com.lowagie.text.pdf.PdfName;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.dom4j.DocumentException;

public class FormTree
extends JTree
implements TreeSelectionListener,
Observer {
    protected PdfReaderController controller;
    protected XfaFile xfaFile;
    protected XfaTree xfaTree;
    protected XfaTextArea xfaTextArea;
    private static final long serialVersionUID = -3584003547303700407L;

    public FormTree(PdfReaderController pdfReaderController) {
        this.controller = pdfReaderController;
        this.setCellRenderer(new IconTreeCellRenderer());
        this.setModel(new DefaultTreeModel(new FormTreeNode()));
        this.addTreeSelectionListener(this);
        this.xfaTree = new XfaTree();
        this.xfaTextArea = new XfaTextArea();
    }

    public void update(Observable observable, Object object) {
        if (object == null) {
            this.setModel(new DefaultTreeModel(new FormTreeNode()));
            this.xfaFile = null;
            this.xfaTree.clear();
            this.xfaTextArea.clear();
            this.repaint();
            return;
        }
        if (object instanceof ObjectLoader) {
            IconTreeNode iconTreeNode;
            PdfTrailerTreeNode pdfTrailerTreeNode;
            PdfObjectTreeNode pdfObjectTreeNode;
            ObjectLoader objectLoader = (ObjectLoader)object;
            TreeNodeFactory treeNodeFactory = objectLoader.getNodes();
            PdfObjectTreeNode pdfObjectTreeNode2 = treeNodeFactory.getChildNode(pdfObjectTreeNode = treeNodeFactory.getChildNode(pdfTrailerTreeNode = this.controller.getPdfTree().getRoot(), PdfName.ROOT), PdfName.ACROFORM);
            if (pdfObjectTreeNode2 == null) {
                return;
            }
            PdfObjectTreeNode pdfObjectTreeNode3 = treeNodeFactory.getChildNode(pdfObjectTreeNode2, PdfName.FIELDS);
            FormTreeNode formTreeNode = new FormTreeNode();
            if (pdfObjectTreeNode3 != null) {
                iconTreeNode = new FormTreeNode(pdfObjectTreeNode3);
                iconTreeNode.setUserObject("Fields");
                this.loadFields(treeNodeFactory, (FormTreeNode)iconTreeNode, pdfObjectTreeNode3);
                formTreeNode.add(iconTreeNode);
            }
            if ((iconTreeNode = treeNodeFactory.getChildNode(pdfObjectTreeNode2, PdfName.XFA)) != null) {
                XfaTreeNode xfaTreeNode = new XfaTreeNode((PdfObjectTreeNode)iconTreeNode);
                xfaTreeNode.setUserObject("XFA");
                this.loadXfa(treeNodeFactory, xfaTreeNode, (PdfObjectTreeNode)iconTreeNode);
                formTreeNode.add(xfaTreeNode);
                try {
                    this.xfaFile = new XfaFile(xfaTreeNode);
                    this.xfaTree.load(this.xfaFile);
                    this.xfaTextArea.load(this.xfaFile);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (DocumentException documentException) {
                    documentException.printStackTrace();
                }
            }
            this.setModel(new DefaultTreeModel(formTreeNode));
        }
    }

    private void loadFields(TreeNodeFactory treeNodeFactory, FormTreeNode formTreeNode, PdfObjectTreeNode pdfObjectTreeNode) {
        if (pdfObjectTreeNode == null) {
            return;
        }
        treeNodeFactory.expandNode(pdfObjectTreeNode);
        if (pdfObjectTreeNode.isIndirectReference()) {
            this.loadFields(treeNodeFactory, formTreeNode, (PdfObjectTreeNode)pdfObjectTreeNode.getFirstChild());
        } else if (pdfObjectTreeNode.isArray()) {
            Enumeration<TreeNode> enumeration = pdfObjectTreeNode.children();
            while (enumeration.hasMoreElements()) {
                this.loadFields(treeNodeFactory, formTreeNode, (PdfObjectTreeNode)enumeration.nextElement());
            }
        } else if (pdfObjectTreeNode.isDictionary()) {
            FormTreeNode formTreeNode2 = new FormTreeNode(pdfObjectTreeNode);
            formTreeNode.add(formTreeNode2);
            PdfObjectTreeNode pdfObjectTreeNode2 = treeNodeFactory.getChildNode(pdfObjectTreeNode, PdfName.KIDS);
            this.loadFields(treeNodeFactory, formTreeNode2, pdfObjectTreeNode2);
        }
    }

    private void loadXfa(TreeNodeFactory treeNodeFactory, XfaTreeNode xfaTreeNode, PdfObjectTreeNode pdfObjectTreeNode) {
        if (pdfObjectTreeNode == null) {
            return;
        }
        treeNodeFactory.expandNode(pdfObjectTreeNode);
        if (pdfObjectTreeNode.isIndirectReference()) {
            this.loadXfa(treeNodeFactory, xfaTreeNode, (PdfObjectTreeNode)pdfObjectTreeNode.getFirstChild());
        } else if (pdfObjectTreeNode.isArray()) {
            Enumeration<TreeNode> enumeration = pdfObjectTreeNode.children();
            while (enumeration.hasMoreElements()) {
                PdfObjectTreeNode pdfObjectTreeNode2 = (PdfObjectTreeNode)enumeration.nextElement();
                PdfObjectTreeNode pdfObjectTreeNode3 = (PdfObjectTreeNode)enumeration.nextElement();
                if (pdfObjectTreeNode3.isIndirectReference()) {
                    treeNodeFactory.expandNode(pdfObjectTreeNode3);
                    pdfObjectTreeNode3 = (PdfObjectTreeNode)pdfObjectTreeNode3.getFirstChild();
                }
                xfaTreeNode.addPacket(pdfObjectTreeNode2.getPdfObject().toString(), pdfObjectTreeNode3);
            }
        } else if (pdfObjectTreeNode.isStream()) {
            xfaTreeNode.addPacket("xdp", pdfObjectTreeNode);
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.controller == null) {
            return;
        }
        FormTreeNode formTreeNode = (FormTreeNode)this.getLastSelectedPathComponent();
        if (formTreeNode == null) {
            return;
        }
        PdfObjectTreeNode pdfObjectTreeNode = formTreeNode.getCorrespondingPdfObjectNode();
        if (pdfObjectTreeNode != null) {
            this.controller.selectNode(pdfObjectTreeNode);
        }
    }

    public XfaTree getXfaTree() {
        return this.xfaTree;
    }

    public XfaTextArea getXfaTextArea() {
        return this.xfaTextArea;
    }
}

