/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.rups.view.itext;

import com.lowagie.rups.controller.PdfReaderController;
import com.lowagie.rups.model.ObjectLoader;
import com.lowagie.rups.model.TreeNodeFactory;
import com.lowagie.rups.view.icons.IconTreeCellRenderer;
import com.lowagie.rups.view.itext.treenodes.OutlineTreeNode;
import com.lowagie.rups.view.itext.treenodes.PdfObjectTreeNode;
import com.lowagie.rups.view.itext.treenodes.PdfTrailerTreeNode;
import com.lowagie.text.pdf.PdfName;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;

public class OutlineTree
extends JTree
implements TreeSelectionListener,
Observer {
    protected PdfReaderController controller;
    private static final long serialVersionUID = 5646572654823301007L;

    public OutlineTree(PdfReaderController pdfReaderController) {
        this.controller = pdfReaderController;
        this.setCellRenderer(new IconTreeCellRenderer());
        this.setModel(new DefaultTreeModel(new OutlineTreeNode()));
        this.addTreeSelectionListener(this);
    }

    public void update(Observable observable, Object object) {
        if (object == null) {
            this.setModel(new DefaultTreeModel(new OutlineTreeNode()));
            this.repaint();
            return;
        }
        if (object instanceof ObjectLoader) {
            PdfTrailerTreeNode pdfTrailerTreeNode;
            PdfObjectTreeNode pdfObjectTreeNode;
            ObjectLoader objectLoader = (ObjectLoader)object;
            TreeNodeFactory treeNodeFactory = objectLoader.getNodes();
            PdfObjectTreeNode pdfObjectTreeNode2 = treeNodeFactory.getChildNode(pdfObjectTreeNode = treeNodeFactory.getChildNode(pdfTrailerTreeNode = this.controller.getPdfTree().getRoot(), PdfName.ROOT), PdfName.OUTLINES);
            if (pdfObjectTreeNode2 == null) {
                return;
            }
            OutlineTreeNode outlineTreeNode = new OutlineTreeNode();
            this.loadOutline(treeNodeFactory, outlineTreeNode, treeNodeFactory.getChildNode(pdfObjectTreeNode2, PdfName.FIRST));
            this.setModel(new DefaultTreeModel(outlineTreeNode));
        }
    }

    private void loadOutline(TreeNodeFactory treeNodeFactory, OutlineTreeNode outlineTreeNode, PdfObjectTreeNode pdfObjectTreeNode) {
        PdfObjectTreeNode pdfObjectTreeNode2;
        OutlineTreeNode outlineTreeNode2 = new OutlineTreeNode(pdfObjectTreeNode);
        outlineTreeNode.add(outlineTreeNode2);
        PdfObjectTreeNode pdfObjectTreeNode3 = treeNodeFactory.getChildNode(pdfObjectTreeNode, PdfName.FIRST);
        if (pdfObjectTreeNode3 != null) {
            this.loadOutline(treeNodeFactory, outlineTreeNode2, pdfObjectTreeNode3);
        }
        if ((pdfObjectTreeNode2 = treeNodeFactory.getChildNode(pdfObjectTreeNode, PdfName.NEXT)) != null) {
            this.loadOutline(treeNodeFactory, outlineTreeNode, pdfObjectTreeNode2);
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.controller == null) {
            return;
        }
        OutlineTreeNode outlineTreeNode = (OutlineTreeNode)this.getLastSelectedPathComponent();
        PdfObjectTreeNode pdfObjectTreeNode = outlineTreeNode.getCorrespondingPdfObjectNode();
        if (pdfObjectTreeNode != null) {
            this.controller.selectNode(pdfObjectTreeNode);
        }
    }
}

