/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.rups.view.itext;

import com.lowagie.rups.controller.PdfReaderController;
import com.lowagie.rups.model.ObjectLoader;
import com.lowagie.rups.model.TreeNodeFactory;
import com.lowagie.rups.view.PageNavigationListener;
import com.lowagie.rups.view.itext.treenodes.PdfObjectTreeNode;
import com.lowagie.rups.view.itext.treenodes.PdfPageTreeNode;
import com.lowagie.rups.view.itext.treenodes.PdfPagesTreeNode;
import com.lowagie.rups.view.itext.treenodes.PdfTrailerTreeNode;
import com.lowagie.rups.view.models.JTableAutoModel;
import com.lowagie.rups.view.models.JTableAutoModelInterface;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfPageLabels;
import com.lowagie.text.pdf.PdfReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.tree.TreeNode;

public class PagesTable
extends JTable
implements JTableAutoModelInterface,
Observer {
    protected ArrayList<PdfPageTreeNode> list = new ArrayList();
    protected PdfReaderController controller;
    protected PageNavigationListener listener;
    private static final long serialVersionUID = -6523261089453886508L;

    public PagesTable(PdfReaderController pdfReaderController, PageNavigationListener pageNavigationListener) {
        this.controller = pdfReaderController;
        this.listener = pageNavigationListener;
    }

    public void update(Observable observable, Object object) {
        if (object == null) {
            this.list = new ArrayList();
            this.repaint();
            return;
        }
        if (object instanceof ObjectLoader) {
            PdfTrailerTreeNode pdfTrailerTreeNode;
            PdfObjectTreeNode pdfObjectTreeNode;
            ObjectLoader objectLoader = (ObjectLoader)object;
            String[] stringArray = PdfPageLabels.getPageLabels((PdfReader)objectLoader.getReader());
            int n = 0;
            TreeNodeFactory treeNodeFactory = objectLoader.getNodes();
            PdfPagesTreeNode pdfPagesTreeNode = (PdfPagesTreeNode)treeNodeFactory.getChildNode(pdfObjectTreeNode = treeNodeFactory.getChildNode(pdfTrailerTreeNode = this.controller.getPdfTree().getRoot(), PdfName.ROOT), PdfName.PAGES);
            if (pdfPagesTreeNode == null) {
                return;
            }
            Enumeration<TreeNode> enumeration = pdfPagesTreeNode.depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                PdfObjectTreeNode pdfObjectTreeNode2 = (PdfObjectTreeNode)enumeration.nextElement();
                if (!(pdfObjectTreeNode2 instanceof PdfPageTreeNode)) continue;
                StringBuffer stringBuffer = new StringBuffer("Page ");
                stringBuffer.append(++n);
                if (stringArray != null) {
                    stringBuffer.append(" ( ");
                    stringBuffer.append(stringArray[n - 1]);
                    stringBuffer.append(" )");
                }
                pdfObjectTreeNode2.setUserObject(stringBuffer.toString());
                this.list.add((PdfPageTreeNode)pdfObjectTreeNode2);
            }
        }
        this.setModel(new JTableAutoModel(this));
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.list.size();
    }

    public Object getValueAt(int n, int n2) {
        if (this.getRowCount() == 0) {
            return null;
        }
        switch (n2) {
            case 0: {
                return "Object " + this.list.get(n).getNumber();
            }
            case 1: {
                return this.list.get(n);
            }
        }
        return null;
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "Object";
            }
            case 1: {
                return "Page";
            }
        }
        return null;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent != null) {
            super.valueChanged(listSelectionEvent);
        }
        if (this.controller == null) {
            return;
        }
        if (this.getRowCount() > 0) {
            this.controller.selectNode(this.list.get(this.getSelectedRow()));
            if (this.listener != null) {
                this.listener.gotoPage(this.getSelectedRow() + 1);
            }
        }
    }
}

