/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.rups.view.itext;

import com.lowagie.rups.view.models.DictionaryTableModel;
import com.lowagie.rups.view.models.PdfArrayTableModel;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfObject;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;

public class PdfObjectPanel
extends JPanel
implements Observer {
    private static final String TEXT = "text";
    private static final String TABLE = "table";
    protected CardLayout layout = new CardLayout();
    JTable table = new JTable();
    JTextArea text = new JTextArea();
    private static final long serialVersionUID = 1302283071087762494L;

    public PdfObjectPanel() {
        this.setLayout(this.layout);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.table);
        this.add((Component)jScrollPane, TABLE);
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.setViewportView(this.text);
        this.add((Component)jScrollPane2, TEXT);
    }

    public void clear() {
        this.text.setText(null);
        this.layout.show(this, TEXT);
    }

    public void update(Observable observable, Object object) {
        this.clear();
    }

    public void render(PdfObject pdfObject) {
        if (pdfObject == null) {
            this.text.setText(null);
            this.layout.show(this, TEXT);
            this.repaint();
            this.text.repaint();
            return;
        }
        switch (pdfObject.type()) {
            case 6: 
            case 7: {
                this.table.setModel(new DictionaryTableModel((PdfDictionary)pdfObject));
                this.layout.show(this, TABLE);
                this.repaint();
                break;
            }
            case 5: {
                this.table.setModel(new PdfArrayTableModel((PdfArray)pdfObject));
                this.layout.show(this, TABLE);
                this.repaint();
                break;
            }
            default: {
                this.text.setText(pdfObject.toString());
                this.layout.show(this, TEXT);
            }
        }
    }
}

