/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.rups.view.itext;

import com.lowagie.rups.controller.PdfReaderController;
import com.lowagie.rups.model.IndirectObjectFactory;
import com.lowagie.rups.model.ObjectLoader;
import com.lowagie.rups.view.models.JTableAutoModel;
import com.lowagie.rups.view.models.JTableAutoModelInterface;
import com.lowagie.text.pdf.PdfNull;
import com.lowagie.text.pdf.PdfObject;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableColumn;

public class XRefTable
extends JTable
implements JTableAutoModelInterface,
Observer {
    protected IndirectObjectFactory objects;
    protected PdfReaderController controller;
    private static final long serialVersionUID = -382184619041375537L;

    public XRefTable(PdfReaderController pdfReaderController) {
        this.controller = pdfReaderController;
    }

    public void update(Observable observable, Object object) {
        if (object == null) {
            this.objects = null;
            this.repaint();
            return;
        }
        if (observable instanceof PdfReaderController && object instanceof ObjectLoader) {
            ObjectLoader objectLoader = (ObjectLoader)object;
            this.objects = objectLoader.getObjects();
            this.setModel(new JTableAutoModel(this));
            TableColumn tableColumn = this.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(5);
        }
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        if (this.objects == null) {
            return 0;
        }
        return this.objects.size();
    }

    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.getObjectReferenceByRow(n);
            }
            case 1: {
                return this.getObjectDescriptionByRow(n);
            }
        }
        return null;
    }

    protected int getObjectReferenceByRow(int n) {
        return this.objects.getRefByIndex(n);
    }

    protected String getObjectDescriptionByRow(int n) {
        PdfObject pdfObject = this.objects.getObjectByIndex(n);
        if (pdfObject instanceof PdfNull) {
            return "Indirect object";
        }
        return pdfObject.toString();
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "Number";
            }
            case 1: {
                return "Object";
            }
        }
        return null;
    }

    protected PdfObject getObjectByRow(int n) {
        return this.objects.loadObjectByReference(this.getObjectReferenceByRow(n));
    }

    public void selectRowByReference(int n) {
        int n2 = this.objects.getIndexByRef(n);
        this.setRowSelectionInterval(n2, n2);
        this.scrollRectToVisible(this.getCellRect(n2, 1, true));
        this.valueChanged(null);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent != null) {
            super.valueChanged(listSelectionEvent);
        }
        if (this.controller != null && this.objects != null) {
            this.controller.render(this.getObjectByRow(this.getSelectedRow()));
            this.controller.selectNode(this.getObjectReferenceByRow(this.getSelectedRow()));
        }
    }
}

