/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.rups.view.itext.treenodes;

import com.lowagie.rups.view.icons.IconFetcher;
import com.lowagie.rups.view.icons.IconTreeNode;
import com.lowagie.rups.view.itext.treenodes.PdfPageTreeNode;
import com.lowagie.rups.view.itext.treenodes.PdfPagesTreeNode;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfString;

public class PdfObjectTreeNode
extends IconTreeNode {
    protected PdfObject object;
    protected PdfName key = null;
    protected int number = -1;
    protected boolean recursive = false;
    private static final long serialVersionUID = -5617844659397445879L;

    protected PdfObjectTreeNode(PdfObject pdfObject) {
        super(null, PdfObjectTreeNode.getCaption(pdfObject));
        this.object = pdfObject;
        switch (pdfObject.type()) {
            case 10: {
                this.icon = this.isRecursive() ? IconFetcher.getIcon("ref_recursive.png") : IconFetcher.getIcon("ref.png");
                return;
            }
            case 5: {
                this.icon = IconFetcher.getIcon("array.png");
                return;
            }
            case 6: {
                this.icon = IconFetcher.getIcon("dictionary.png");
                return;
            }
            case 7: {
                this.icon = IconFetcher.getIcon("stream.png");
                return;
            }
            case 1: {
                this.icon = IconFetcher.getIcon("boolean.png");
                return;
            }
            case 4: {
                this.icon = IconFetcher.getIcon("name.png");
                return;
            }
            case 8: {
                this.icon = IconFetcher.getIcon("null.png");
                return;
            }
            case 2: {
                this.icon = IconFetcher.getIcon("number.png");
                return;
            }
            case 3: {
                this.icon = IconFetcher.getIcon("string.png");
                return;
            }
        }
    }

    protected PdfObjectTreeNode(String string, PdfObject pdfObject) {
        super(string, PdfObjectTreeNode.getCaption(pdfObject));
        this.object = pdfObject;
    }

    public static PdfObjectTreeNode getInstance(PdfObject pdfObject) {
        if (pdfObject.isDictionary()) {
            if (PdfName.PAGE.equals((Object)((PdfDictionary)pdfObject).get(PdfName.TYPE))) {
                return new PdfPageTreeNode((PdfDictionary)pdfObject);
            }
            if (PdfName.PAGES.equals((Object)((PdfDictionary)pdfObject).get(PdfName.TYPE))) {
                return new PdfPagesTreeNode((PdfDictionary)pdfObject);
            }
        }
        return new PdfObjectTreeNode(pdfObject);
    }

    public static PdfObjectTreeNode getInstance(PdfObject pdfObject, int n) {
        PdfObjectTreeNode pdfObjectTreeNode = PdfObjectTreeNode.getInstance(pdfObject);
        pdfObjectTreeNode.number = n;
        return pdfObjectTreeNode;
    }

    public static PdfObjectTreeNode getInstance(PdfDictionary pdfDictionary, PdfName pdfName) {
        PdfObjectTreeNode pdfObjectTreeNode = PdfObjectTreeNode.getInstance(pdfDictionary.get(pdfName));
        pdfObjectTreeNode.setUserObject(PdfObjectTreeNode.getDictionaryEntryCaption(pdfDictionary, pdfName));
        pdfObjectTreeNode.key = pdfName;
        return pdfObjectTreeNode;
    }

    public PdfObject getPdfObject() {
        return this.object;
    }

    public int getNumber() {
        if (this.isIndirectReference()) {
            return ((PdfIndirectReference)this.object).getNumber();
        }
        return this.number;
    }

    public boolean isIndirectReference() {
        return this.object.type() == 10;
    }

    public boolean isIndirect() {
        return this.isIndirectReference() || this.number > -1;
    }

    public boolean isArray() {
        return this.object.isArray();
    }

    public boolean isDictionaryNode(PdfName pdfName) {
        if (pdfName == null) {
            return false;
        }
        return pdfName.equals((Object)this.key);
    }

    public boolean isDictionary() {
        return this.object.isDictionary();
    }

    public boolean isStream() {
        return this.object.isStream();
    }

    public void setRecursive(boolean bl) {
        this.recursive = bl;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public static String getCaption(PdfObject pdfObject) {
        if (pdfObject == null) {
            return "null";
        }
        switch (pdfObject.type()) {
            case 10: {
                return "Indirect reference: " + pdfObject.toString();
            }
            case 5: {
                return "Array";
            }
            case 7: {
                return "Stream";
            }
            case 3: {
                return ((PdfString)pdfObject).toUnicodeString();
            }
        }
        return pdfObject.toString();
    }

    public static String getDictionaryEntryCaption(PdfDictionary pdfDictionary, PdfName pdfName) {
        StringBuffer stringBuffer = new StringBuffer(pdfName.toString());
        stringBuffer.append(": ");
        stringBuffer.append(pdfDictionary.get(pdfName).toString());
        return stringBuffer.toString();
    }

    public PdfObjectTreeNode getAncestor() {
        if (this.isRecursive()) {
            PdfObjectTreeNode pdfObjectTreeNode = this;
            while (!(pdfObjectTreeNode = (PdfObjectTreeNode)pdfObjectTreeNode.getParent()).isIndirectReference() || pdfObjectTreeNode.getNumber() != this.getNumber()) {
            }
            return pdfObjectTreeNode;
        }
        return null;
    }
}

