/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.rups.view.itext.treenodes;

import com.lowagie.rups.view.icons.IconFetcher;
import com.lowagie.rups.view.icons.IconTreeNode;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.Text;

public class XdpTreeNode
extends IconTreeNode {
    private static final long serialVersionUID = -6431790925424045933L;

    public XdpTreeNode(Node node) {
        super(null, node);
        Element element;
        if (node instanceof Element) {
            element = (Element)node;
            this.addChildNodes(element.attributes());
        }
        if (node instanceof Branch) {
            element = (Branch)node;
            this.addChildNodes(element.content());
        }
        if (node instanceof Attribute) {
            this.icon = IconFetcher.getIcon("attribute.png");
            return;
        }
        if (node instanceof Text) {
            this.icon = IconFetcher.getIcon("text.png");
            return;
        }
        if (node instanceof ProcessingInstruction) {
            this.icon = IconFetcher.getIcon("pi.png");
            return;
        }
        if (node instanceof Document) {
            this.icon = IconFetcher.getIcon("xfa.png");
            return;
        }
        this.icon = IconFetcher.getIcon("tag.png");
    }

    private void addChildNodes(List list) {
        for (Node node : list) {
            if (node instanceof Namespace || node instanceof Comment) continue;
            this.add(new XdpTreeNode(node));
        }
    }

    public Node getNode() {
        return (Node)this.getUserObject();
    }

    public String toString() {
        Node node = this.getNode();
        if (node instanceof Element) {
            Element element = (Element)node;
            return element.getName();
        }
        if (node instanceof Attribute) {
            Attribute attribute = (Attribute)node;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(attribute.getName());
            stringBuffer.append("=\"");
            stringBuffer.append(attribute.getValue());
            stringBuffer.append('\"');
            return stringBuffer.toString();
        }
        if (node instanceof Text) {
            Text text = (Text)node;
            return text.getText();
        }
        if (node instanceof ProcessingInstruction) {
            ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
            StringBuffer stringBuffer = new StringBuffer("<?");
            stringBuffer.append(processingInstruction.getName());
            stringBuffer.append(' ');
            stringBuffer.append(processingInstruction.getText());
            stringBuffer.append("?>");
            return stringBuffer.toString();
        }
        if (node instanceof Document) {
            return "XFA Document";
        }
        return this.getNode().toString();
    }
}

