/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.rups.view.renderer;

import com.sun.pdfview.PDFPage;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import javax.swing.JPanel;

public class PagePanel
extends JPanel
implements ImageObserver,
MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = -130815955294007634L;
    protected PDFPage currentPage;
    protected Image currentImage;
    protected int offx;
    protected int offy;
    Dimension prevSize;
    Rectangle2D clip;
    Rectangle2D prevClip;
    protected Rectangle zoomRect;
    AffineTransform deviceToPageSpaceTransformation;

    public PagePanel() {
        this.setFocusable(true);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public int getCurrentPageNumber() {
        if (this.currentPage == null) {
            return 0;
        }
        return this.currentPage.getPageNumber();
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(Color.DARK_GRAY);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.currentImage == null) {
            graphics.setColor(Color.black);
            graphics.drawString("No page selected", this.getWidth() / 2 - 30, this.getHeight() / 2);
        } else {
            int n = this.currentImage.getWidth(null);
            int n2 = this.currentImage.getHeight(null);
            this.offx = (dimension.width - n) / 2;
            this.offy = (dimension.height - n2) / 2;
            if (n == dimension.width && n2 <= dimension.height || n2 == dimension.height && n <= dimension.width) {
                graphics.drawImage(this.currentImage, this.offx, this.offy, this);
            } else if (this.currentPage != null) {
                this.showPage(this.currentPage);
            }
        }
        if (this.zoomRect != null) {
            graphics.setColor(Color.red);
            graphics.drawRect(this.zoomRect.x, this.zoomRect.y, this.zoomRect.width, this.zoomRect.height);
        }
    }

    public synchronized void showPage(PDFPage pDFPage) {
        if (this.currentPage != null && this.prevSize != null) {
            this.currentPage.stop(this.prevSize.width, this.prevSize.height, this.prevClip);
        }
        this.currentPage = pDFPage;
        if (pDFPage == null) {
            this.currentImage = null;
            this.clip = null;
            this.deviceToPageSpaceTransformation = null;
            this.repaint();
        } else {
            Dimension dimension = this.getSize();
            if (dimension.width + dimension.height == 0) {
                return;
            }
            Rectangle2D rectangle2D = this.clip;
            if (this.clip != null && this.deviceToPageSpaceTransformation != null) {
                rectangle2D = this.deviceToPageSpaceTransformation.createTransformedShape(this.clip).getBounds2D();
            }
            Dimension dimension2 = pDFPage.getUnstretchedSize(dimension.width, dimension.height, rectangle2D);
            this.currentImage = pDFPage.getImage(dimension2.width, dimension2.height, rectangle2D, (ImageObserver)this);
            this.deviceToPageSpaceTransformation = pDFPage.getInitialTransform(dimension2.width, dimension2.height, rectangle2D);
            try {
                this.deviceToPageSpaceTransformation = this.deviceToPageSpaceTransformation.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                System.out.println("Error inverting page transform!");
                noninvertibleTransformException.printStackTrace();
            }
            this.prevClip = rectangle2D;
            this.prevSize = dimension2;
            this.repaint();
        }
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x28) != 0) {
            this.repaint(n2 + this.offx, n3 + this.offy, n4, n5);
        }
        return true;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

