/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.Png;
import com.lowagie.text.pdf.BadPdfFormatException;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfException;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class PdfImage
extends PdfStream {
    static final int TRANSFERSIZE = 4096;
    protected PdfName name;

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PdfImage(Image var1_1, String var2_2, PdfIndirectReference var3_3) throws BadPdfFormatException {
        block106: {
            super();
            this.name = null;
            this.name = new PdfName(var2_2);
            this.put(PdfName.TYPE, PdfName.XOBJECT);
            this.put(PdfName.SUBTYPE, PdfName.IMAGE);
            this.put(PdfName.WIDTH, new PdfNumber(var1_1.width()));
            this.put(PdfName.HEIGHT, new PdfNumber(var1_1.height()));
            if (var1_1.isMask() && (var1_1.bpc() == 1 || var1_1.bpc() > 255)) {
                this.put(PdfName.IMAGEMASK, PdfBoolean.PDFTRUE);
            }
            if (var3_3 != null) {
                if (var1_1.isSmask()) {
                    this.put(PdfName.SMASK, var3_3);
                } else {
                    this.put(PdfName.MASK, var3_3);
                }
            }
            if (var1_1.isMask() && var1_1.isInvertMask()) {
                this.put(PdfName.DECODE, new PdfLiteral("[1 0]"));
            }
            if (var1_1.isInterpolation()) {
                this.put(PdfName.INTERPOLATE, PdfBoolean.PDFTRUE);
            }
            var4_4 = null;
            try {
                try {
                    if (var1_1.isImgRaw()) {
                        var5_5 = var1_1.colorspace();
                        var6_8 = var1_1.getTransparency();
                        if (var6_8 != null && !var1_1.isMask() && var3_3 == null) {
                            var7_10 = "[";
                            var8_13 = 0;
                            while (true) {
                                if (var8_13 >= var6_8.length) {
                                    var7_10 = var7_10 + "]";
                                    this.put(PdfName.MASK, new PdfLiteral(var7_10));
                                    break;
                                }
                                var7_10 = var7_10 + var6_8[var8_13] + " ";
                                ++var8_13;
                            }
                        }
                        this.bytes = var1_1.rawData();
                        this.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
                        var7_11 = var1_1.bpc();
                        if (var7_11 > 255) {
                            if (!var1_1.isMask()) {
                                this.put(PdfName.COLORSPACE, PdfName.DEVICEGRAY);
                            }
                            this.put(PdfName.BITSPERCOMPONENT, new PdfNumber(1));
                            this.put(PdfName.FILTER, PdfName.CCITTFAXDECODE);
                            var8_13 = var7_11 - 257;
                            var9_16 = new PdfDictionary();
                            if (var8_13 != 0) {
                                var9_16.put(PdfName.K, new PdfNumber(var8_13));
                            }
                            if ((var5_5 & 1) != 0) {
                                var9_16.put(PdfName.BLACKIS1, PdfBoolean.PDFTRUE);
                            }
                            if ((var5_5 & 2) != 0) {
                                var9_16.put(PdfName.ENCODEDBYTEALIGN, PdfBoolean.PDFTRUE);
                            }
                            if ((var5_5 & 4) != 0) {
                                var9_16.put(PdfName.ENDOFLINE, PdfBoolean.PDFTRUE);
                            }
                            if ((var5_5 & 8) != 0) {
                                var9_16.put(PdfName.ENDOFBLOCK, PdfBoolean.PDFFALSE);
                            }
                            var9_16.put(PdfName.COLUMNS, new PdfNumber(var1_1.width()));
                            var9_16.put(PdfName.ROWS, new PdfNumber(var1_1.height()));
                            this.put(PdfName.DECODEPARMS, var9_16);
                        } else {
                            switch (var5_5) {
                                case 1: {
                                    this.put(PdfName.COLORSPACE, PdfName.DEVICEGRAY);
                                    if (!var1_1.isInverted()) break;
                                    this.put(PdfName.DECODE, new PdfLiteral("[1 0]"));
                                    break;
                                }
                                case 3: {
                                    this.put(PdfName.COLORSPACE, PdfName.DEVICERGB);
                                    if (!var1_1.isInverted()) break;
                                    this.put(PdfName.DECODE, new PdfLiteral("[1 0 1 0 1 0]"));
                                    break;
                                }
                                default: {
                                    this.put(PdfName.COLORSPACE, PdfName.DEVICECMYK);
                                    if (!var1_1.isInverted()) break;
                                    this.put(PdfName.DECODE, new PdfLiteral("[1 0 1 0 1 0 1 0]"));
                                }
                            }
                            if ((var8_14 = var1_1.getAdditional()) != null) {
                                this.putAll(var8_14);
                            }
                            this.put(PdfName.BITSPERCOMPONENT, new PdfNumber(var1_1.bpc()));
                            if (var1_1.isDeflated()) {
                                this.put(PdfName.FILTER, PdfName.FLATEDECODE);
                            } else {
                                try {
                                    this.flateCompress();
                                }
                                catch (PdfException var9_17) {
                                    throw new ExceptionConverter(var9_17);
                                }
                            }
                        }
                        var28_20 = null;
                        if (var4_4 == null) return;
                        try {
                            var4_4.close();
                            return;
                        }
                        catch (Exception var29_24) {
                            // empty catch block
                        }
                        return;
                    }
                    if (var1_1.rawData() == null) {
                        var4_4 = var1_1.url().openStream();
                        var5_6 = var1_1.url().toString();
                    } else {
                        var4_4 = new ByteArrayInputStream(var1_1.rawData());
                        var5_6 = "Byte array";
                    }
                    this.streamBytes = new ByteArrayOutputStream();
                    var6_9 = 0;
                    block8 : switch (var1_1.type()) {
                        case 33: {
                            this.put(PdfName.FILTER, PdfName.FLATEDECODE);
                            var7_12 = 0;
                            while (true) {
                                if (var7_12 >= Png.PNGID.length) break;
                                if (Png.PNGID[var7_12] != var4_4.read()) {
                                    throw new BadPdfFormatException(var5_6 + " is not a PNG file.");
                                }
                                ++var7_12;
                            }
                            var8_15 = 0;
                            block40: while (true) {
                                var9_18 = Png.getInt(var4_4);
                                var10_28 = Png.getString(var4_4);
                                if ("IDAT".equals(var10_28)) {
                                    PdfImage.transferBytes(var4_4, this.streamBytes, var9_18);
                                    Png.getInt(var4_4);
                                    continue;
                                }
                                if ("tRNS".equals(var10_28) && !var1_1.isMask() && var3_3 == null) {
                                    block13 : switch (var8_15) {
                                        case 0: {
                                            if (var9_18 < 2) break;
                                            var9_18 -= 2;
                                            var11_30 = Png.getWord(var4_4);
                                            this.put(PdfName.MASK, new PdfLiteral("[" + var11_30 + " " + var11_30 + "]"));
                                            break;
                                        }
                                        case 2: {
                                            if (var9_18 < 6) break;
                                            var9_18 -= 6;
                                            var11_31 = Png.getWord(var4_4);
                                            var12_37 = Png.getWord(var4_4);
                                            var13_41 = Png.getWord(var4_4);
                                            this.put(PdfName.MASK, new PdfLiteral("[" + var11_31 + " " + var11_31 + " " + var12_37 + " " + var12_37 + " " + var13_41 + " " + var13_41 + "]"));
                                            break;
                                        }
                                        case 3: {
                                            if (var9_18 <= 0) break;
                                            var11_32 = 0;
                                            while (var9_18-- != 0) {
                                                if (var4_4.read() == 0) {
                                                    this.put(PdfName.MASK, new PdfLiteral("[" + var11_32 + " " + var11_32 + "]"));
                                                    break block13;
                                                }
                                                ++var11_32;
                                            }
                                            break;
                                        }
                                    }
                                    Image.skip(var4_4, var9_18 + 4);
                                    continue;
                                }
                                if ("IHDR".equals(var10_28)) {
                                    var11_33 = Png.getInt(var4_4);
                                    var12_38 = Png.getInt(var4_4);
                                    var13_41 = var4_4.read();
                                    if (var13_41 == 16) {
                                        throw new BadPdfFormatException(var5_6 + " Bit depth 16 is not suported.");
                                    }
                                    this.put(PdfName.BITSPERCOMPONENT, new PdfNumber(var13_41));
                                    var8_15 = var4_4.read();
                                    if (var8_15 != 0 && var8_15 != 2 && var8_15 != 3) {
                                        throw new BadPdfFormatException(var5_6 + " Colortype " + var8_15 + " is not suported.");
                                    }
                                    if (var8_15 == 0) {
                                        this.put(PdfName.COLORSPACE, PdfName.DEVICEGRAY);
                                    } else if (var8_15 == 2) {
                                        this.put(PdfName.COLORSPACE, PdfName.DEVICERGB);
                                    }
                                    var14_44 = var4_4.read();
                                    var15_47 = var4_4.read();
                                    var16_49 = var4_4.read();
                                    if (var16_49 != 0) {
                                        throw new BadPdfFormatException(var5_6 + " Interlace method " + var16_49 + " is not suported.");
                                    }
                                    var17_51 = new PdfDictionary();
                                    var17_51.put(PdfName.BITSPERCOMPONENT, new PdfNumber(var13_41));
                                    var17_51.put(PdfName.PREDICTOR, new PdfNumber(15));
                                    var17_51.put(PdfName.COLUMNS, new PdfNumber(var11_33));
                                    var17_51.put(PdfName.COLORS, new PdfNumber(var8_15 == 2 ? 3 : 1));
                                    this.put(PdfName.DECODEPARMS, var17_51);
                                    Png.getInt(var4_4);
                                    continue;
                                }
                                if ("PLTE".equals(var10_28)) {
                                    if (var8_15 == 3) {
                                        var11_34 = new PdfArray();
                                        var11_34.add(PdfName.INDEXED);
                                        var11_34.add(PdfName.DEVICERGB);
                                        var11_34.add(new PdfNumber(var9_18 / 3 - 1));
                                        var12_39 = new ByteBuffer();
                                        while (true) {
                                            if (var9_18-- <= 0) {
                                                var11_34.add(new PdfString(var12_39.toByteArray()));
                                                this.put(PdfName.COLORSPACE, var11_34);
                                                Png.getInt(var4_4);
                                                continue block40;
                                            }
                                            var12_39.append_i(var4_4.read());
                                        }
                                    }
                                    Image.skip(var4_4, var9_18 + 4);
                                    continue;
                                }
                                if ("IEND".equals(var10_28)) break block8;
                                var11_35 = -4;
                                while (true) {
                                    if (var11_35 >= var9_18) ** break;
                                    var4_4.read();
                                    ++var11_35;
                                }
                                break;
                            }
                        }
                        case 32: {
                            this.put(PdfName.FILTER, PdfName.DCTDECODE);
                            switch (var1_1.colorspace()) {
                                case 1: {
                                    this.put(PdfName.COLORSPACE, PdfName.DEVICEGRAY);
                                    break;
                                }
                                case 3: {
                                    this.put(PdfName.COLORSPACE, PdfName.DEVICERGB);
                                    break;
                                }
                                default: {
                                    this.put(PdfName.COLORSPACE, PdfName.DEVICECMYK);
                                    if (!var1_1.isInverted()) break;
                                    this.put(PdfName.DECODE, new PdfLiteral("[1 0 1 0 1 0 1 0]"));
                                }
                            }
                            this.put(PdfName.BITSPERCOMPONENT, new PdfNumber(8));
                            if (var1_1.rawData() != null) {
                                this.bytes = var1_1.rawData();
                                this.streamBytes = null;
                                this.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
                                break block106;
                            } else {
                                PdfImage.transferBytes(var4_4, this.streamBytes, -1);
                                break;
                            }
                        }
                        case 31: {
                            if (var4_4.read() != 71) throw new BadPdfFormatException(var5_6 + " is not a GIF-file (GIF header not found).");
                            if (var4_4.read() != 73) throw new BadPdfFormatException(var5_6 + " is not a GIF-file (GIF header not found).");
                            if (var4_4.read() != 70) {
                                throw new BadPdfFormatException(var5_6 + " is not a GIF-file (GIF header not found).");
                            }
                            var9_19 = 0;
                            while (true) {
                                if (var9_19 < 8) ** GOTO lbl301
                                var10_29 = 0;
                                var11_36 = null;
                                if ((var6_9 & 128) == 128) {
                                    var10_29 = 2 << (var6_9 & 7);
                                    var4_4.read();
                                    var4_4.read();
                                    var11_36 = new ByteBuffer();
                                    var12_40 = 0;
                                    break;
                                }
                                ** GOTO lbl313
lbl301:
                                // 1 sources

                                var6_9 = var4_4.read();
                                ++var9_19;
                            }
                            while (var12_40 < var10_29) {
                                var11_36.append_i(var4_4.read());
                                var11_36.append_i(var4_4.read());
                                var11_36.append_i(var4_4.read());
                                ++var12_40;
                            }
lbl313:
                            // 2 sources

                            var12_40 = 0;
                            block46: while (true) {
                                if (var12_40 == 0) ** GOTO lbl319
                                if (var11_36 == null) {
                                    throw new BadPdfFormatException(var5_6 + " is not a supported GIF-file (there is nor a global, nor a local color table present).");
                                }
                                ** GOTO lbl446
lbl319:
                                // 1 sources

                                var13_42 = var4_4.read();
                                switch (var13_42) {
                                    case 44: {
                                        var12_40 = 1;
                                        var14_45 = 0;
                                        while (true) {
                                            if (var14_45 >= 8) {
                                                var15_48 = var4_4.read();
                                                if ((var15_48 & 64) == 0) break;
                                                throw new BadPdfFormatException(var5_6 + " is not a supported GIF-file (interlaced gifs are not supported).");
                                            }
                                            var4_4.read();
                                            ++var14_45;
                                        }
                                        if ((var15_48 & 128) != 0) {
                                            var10_29 = 2 << (var6_9 & 7);
                                            var4_4.read();
                                            var4_4.read();
                                            var11_36 = new ByteBuffer();
                                            var16_50 = 0;
                                            while (var16_50 < var10_29) {
                                                var11_36.append_i(var4_4.read());
                                                var11_36.append_i(var4_4.read());
                                                var11_36.append_i(var4_4.read());
                                                ++var16_50;
                                            }
                                        }
                                        if (var4_4.read() != 8) {
                                            throw new BadPdfFormatException(var5_6 + " is not a supported GIF-file (initial LZW code not supported).");
                                        }
                                        var16_50 = 0;
                                        var17_52 = 9;
                                        var18_53 = 257;
                                        var19_54 = 0;
                                        var20_55 = 0;
                                        var21_56 = 0;
                                        var22_57 = 23;
                                        var23_58 = 0;
                                        var24_59 = 0;
                                        var25_60 = 0;
                                        var26_61 = var4_4.read();
                                        if (var26_61 < 1) {
                                            throw new BadPdfFormatException(var5_6 + " is not a supported GIF-file. (no image data found).");
                                        }
                                        ++var24_59;
                                        var19_54 = var4_4.read();
                                        if (--var26_61 > 0) {
                                            ++var24_59;
                                            var19_54 += var4_4.read() << 8;
                                            if (--var26_61 > 0) {
                                                --var26_61;
                                                ++var24_59;
                                                var19_54 += var4_4.read() << 16;
                                            }
                                        }
                                        block49: while (var24_59 > var25_60) {
                                            ++var18_53;
                                            var16_50 = var19_54 >> var21_56 & (1 << var17_52) - 1;
                                            var23_58 = (var21_56 + var17_52) / 8;
                                            var21_56 = (var21_56 + var17_52) % 8;
                                            while (true) {
                                                if (var23_58 <= 0) {
                                                    var20_55 += var16_50 << var22_57 - var17_52 + 1;
                                                    var22_57 -= var17_52;
                                                    break;
                                                }
                                                --var23_58;
                                                var19_54 >>= 8;
                                                if (var26_61 > 0) {
                                                    --var26_61;
                                                    ++var24_59;
                                                    var19_54 += var4_4.read() << 16;
                                                    continue;
                                                }
                                                var26_61 = var4_4.read();
                                                if (var26_61 <= 0) continue;
                                                --var26_61;
                                                ++var24_59;
                                                var19_54 += var4_4.read() << 16;
                                            }
                                            while (true) {
                                                if (var22_57 >= 16) {
                                                    if (var16_50 == 256) {
                                                        var17_52 = 9;
                                                        var18_53 = 257;
                                                    }
                                                    if (var16_50 != 257) break;
                                                    break block49;
                                                }
                                                this.streamBytes.write(var20_55 >> 16);
                                                ++var25_60;
                                                var20_55 = (var20_55 & 65535) << 8;
                                                var22_57 += 8;
                                            }
                                            if (var18_53 != 1 << var17_52 || var17_52 >= 12) continue;
                                            ++var17_52;
                                        }
                                        if (var24_59 - var25_60 <= 2) continue block46;
                                        throw new BadPdfFormatException(var5_6 + " is not a supported GIF-file (unexpected end of data block).");
                                    }
                                    case 33: {
                                        var14_45 = var4_4.read();
                                        switch (var14_45) {
                                            case 249: {
                                                var4_4.read();
                                                var15_48 = var4_4.read();
                                                var4_4.read();
                                                var4_4.read();
                                                var16_50 = var4_4.read();
                                                if ((var15_48 & 1) != 0) {
                                                    this.put(PdfName.MASK, new PdfLiteral("[" + var16_50 + " " + var16_50 + "]"));
                                                }
                                                var17_52 = 0;
                                                while (true) {
                                                    if ((var17_52 = var4_4.read()) == 0) continue block46;
                                                    var4_4.skip(var17_52);
                                                }
                                            }
                                            case 1: 
                                            case 254: 
                                            case 255: {
                                                var15_48 = 0;
                                                while (true) {
                                                    if ((var15_48 = var4_4.read()) == 0) continue block46;
                                                    var4_4.skip(var15_48);
                                                }
                                            }
                                        }
                                        throw new BadPdfFormatException(var5_6 + " is not a supported GIF-file (bad extension identifier).");
                                    }
                                    case 59: {
                                        continue block46;
                                    }
                                }
                                break;
                            }
                            throw new BadPdfFormatException(var5_6 + " is not a supported GIF-file (bad data block identifier).");
lbl446:
                            // 1 sources

                            this.put(PdfName.FILTER, PdfName.LZWDECODE);
                            var13_43 = new PdfDictionary();
                            var13_43.put(PdfName.EARLYCHANGE, new PdfNumber(0));
                            this.put(PdfName.DECODEPARMS, var13_43);
                            var14_46 = new PdfArray();
                            var14_46.add(PdfName.INDEXED);
                            var14_46.add(PdfName.DEVICERGB);
                            var14_46.add(new PdfNumber(var10_29 - 1));
                            var14_46.add(new PdfString(var11_36.toByteArray()));
                            this.put(PdfName.COLORSPACE, var14_46);
                            this.put(PdfName.BITSPERCOMPONENT, new PdfNumber(8));
                            break;
                        }
                        default: {
                            throw new BadPdfFormatException(var5_6 + " is an unknown Image format.");
                        }
                    }
                    this.put(PdfName.LENGTH, new PdfNumber(this.streamBytes.size()));
                }
                catch (IOException var5_7) {
                    throw new BadPdfFormatException(var5_7.getMessage());
                }
                var28_22 = null;
                if (var4_4 == null) return;
                try {}
                catch (Exception var29_26) {
                    return;
                }
                var4_4.close();
                return;
            }
            catch (Throwable var27_62) {
                var28_23 = null;
                if (var4_4 == null) throw var27_62;
                ** try [egrp 3[TRYBLOCK] [3 : 3421->3429)] { 
lbl486:
                // 1 sources

                var4_4.close();
                throw var27_62;
lbl488:
                // 1 sources

                catch (Exception var29_27) {
                    // empty catch block
                }
                throw var27_62;
            }
        }
        var28_21 = null;
        if (var4_4 == null) return;
        ** try [egrp 3[TRYBLOCK] [3 : 3421->3429)] { 
lbl495:
        // 1 sources

        var4_4.close();
        return;
lbl497:
        // 1 sources

        catch (Exception var29_25) {
            // empty catch block
        }
    }

    public PdfName name() {
        return this.name;
    }

    static void transferBytes(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        byte[] byArray = new byte[4096];
        if (n < 0) {
            n = 0x7FFFFFF;
        }
        while (n != 0) {
            int n2 = inputStream.read(byArray, 0, Math.min(n, 4096));
            if (n2 < 0) {
                return;
            }
            outputStream.write(byArray, 0, n2);
            n -= n2;
        }
    }
}

