/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfEncryption;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.OutputStream;

public class PdfString
extends PdfObject {
    protected String value = "";
    protected String encoding = "PDF";

    public PdfString() {
        super(3);
    }

    public PdfString(String string) {
        super(3);
        this.value = string;
    }

    public PdfString(String string, String string2) {
        super(3);
        this.value = string;
        this.encoding = string2;
    }

    public PdfString(byte[] byArray) {
        super(3);
        this.value = PdfEncodings.convertToString(byArray, null);
        this.encoding = "";
    }

    public void toPdf(PdfWriter pdfWriter, OutputStream outputStream) throws IOException {
        byte[] byArray = this.encoding != null && this.encoding.equals("UnicodeBig") && PdfEncodings.isPdfDocEncoding(this.value) ? PdfEncodings.convertToBytes(this.value, "PDF") : PdfEncodings.convertToBytes(this.value, this.encoding);
        PdfEncryption pdfEncryption = null;
        if (pdfWriter != null) {
            pdfEncryption = pdfWriter.getEncryption();
        }
        if (pdfEncryption != null) {
            pdfEncryption.prepareKey();
            pdfEncryption.encryptRC4(byArray);
        }
        outputStream.write(PdfContentByte.escapeString(byArray));
    }

    public String toString() {
        return this.value;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String toUnicodeString() {
        if (this.encoding != null && this.encoding.length() != 0) {
            return this.value;
        }
        byte[] byArray = PdfEncodings.convertToBytes(this.value, null);
        if (byArray.length >= 2 && byArray[0] == -2 && byArray[1] == -1) {
            return PdfEncodings.convertToString(byArray, "UnicodeBig");
        }
        return PdfEncodings.convertToString(byArray, "PDF");
    }
}

