/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PageResources;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfStamperImp;

public class StampContent
extends PdfContentByte {
    int pageNumber;
    PageResources pageResources;

    StampContent(PdfStamperImp stamper, int pageNumber) {
        super(stamper);
        this.pageNumber = pageNumber;
        this.pageResources = stamper.getPageStamp((int)pageNumber).pageResources;
    }

    public void setAction(PdfAction action, float llx, float lly, float urx, float ury) {
        ((PdfStamperImp)this.writer).addAnnotation(new PdfAnnotation(this.writer, llx, lly, urx, ury, action), this.pageNumber);
    }

    public PdfContentByte getDuplicate() {
        return new StampContent((PdfStamperImp)this.writer, this.pageNumber);
    }

    PageResources getPageResources() {
        return this.pageResources;
    }

    void addAnnotation(PdfAnnotation annot) {
        ((PdfStamperImp)this.writer).addAnnotation(annot, this.pageNumber);
    }
}

