/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfFont;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfChunk
extends RtfElement {
    private RtfFont font = null;
    private String content = "";
    private boolean softLineBreaks = false;

    public RtfChunk(RtfDocument doc, Chunk chunk) {
        super(doc);
        if (chunk == null) {
            return;
        }
        float superSubScript = 0.0f;
        if (chunk.getAttributes() != null && chunk.getAttributes().get("SUBSUPSCRIPT") != null) {
            superSubScript = ((Float)chunk.getAttributes().get("SUBSUPSCRIPT")).floatValue();
        }
        this.font = new RtfFont(doc, chunk.font(), superSubScript);
        this.content = chunk.content();
    }

    public byte[] write() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(this.font.writeBegin());
            result.write(RtfBasicElement.DELIMITER);
            result.write(this.document.filterSpecialChar(this.content, false, this.softLineBreaks).getBytes());
            result.write(this.font.writeEnd());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    public void setRtfDocument(RtfDocument doc) {
        super.setRtfDocument(doc);
        this.font.setRtfDocument(this.document);
    }

    public void setSoftLineBreaks(boolean softLineBreaks) {
        this.softLineBreaks = softLineBreaks;
    }

    public boolean getSoftLineBreaks() {
        return this.softLineBreaks;
    }
}

