/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes;

import lowentry.ue4.library.LowEntry;

public abstract class BitDataReader {
    protected static final byte[] mask = new byte[]{0, 1, 3, 7, 15, 31, 63, 127, -1};
    protected int position = 0;
    protected byte currentByte = 0;
    protected int currentBytePosition = 0;

    public abstract BitDataReader getClone();

    protected abstract int getTotalCountImplementation();

    protected abstract byte getByteImplementation(int var1);

    public int position() {
        return this.position * 8 + this.currentBytePosition;
    }

    public BitDataReader position(int position) {
        if (position < 0) {
            this.reset();
        } else {
            int count = this.getTotalCountImplementation();
            this.position = position / 8;
            this.currentBytePosition = position % 8;
            this.currentByte = 0;
            if (this.position > count) {
                this.position = count;
                this.currentBytePosition = 0;
            } else if (this.currentBytePosition > 0) {
                if (this.position == 0) {
                    this.currentBytePosition = 0;
                } else {
                    this.currentByte = this.getByteImplementation(this.position - 1);
                }
            }
        }
        return this;
    }

    public BitDataReader reset() {
        this.position = 0;
        this.currentBytePosition = 0;
        this.currentByte = 0;
        return this;
    }

    public BitDataReader empty() {
        this.position = this.getTotalCountImplementation();
        this.currentBytePosition = 0;
        this.currentByte = 0;
        return this;
    }

    protected int getAndIncreasePosition(int increasement) {
        int count = this.getTotalCountImplementation();
        int pos = this.position;
        this.position = count - increasement <= this.position ? count : (this.position += increasement);
        return pos;
    }

    public int remaining() {
        int count = this.getTotalCountImplementation();
        if (this.currentBytePosition != 0) {
            return count - this.position + 1;
        }
        return count - this.position;
    }

    protected int maxElementsRemaining(int minimumSizePerElement) {
        int remaining = this.remaining();
        if (remaining <= 0) {
            return 0;
        }
        if (minimumSizePerElement <= 1) {
            return remaining;
        }
        return remaining / minimumSizePerElement + 1;
    }

    protected boolean getRawBit() {
        boolean bit;
        if (this.currentBytePosition == 0) {
            int pos = this.getAndIncreasePosition(1);
            if (this.getTotalCountImplementation() <= pos) {
                return false;
            }
            this.currentByte = this.getByteImplementation(pos);
        }
        boolean bl = bit = (this.currentByte >> this.currentBytePosition & 1) != 0;
        this.currentBytePosition = this.currentBytePosition == 7 ? 0 : ++this.currentBytePosition;
        return bit;
    }

    protected byte getRawByte() {
        if (this.currentBytePosition == 0) {
            int pos = this.getAndIncreasePosition(1);
            if (this.getTotalCountImplementation() <= pos) {
                return 0;
            }
            return this.getByteImplementation(pos);
        }
        byte b = (byte)(this.currentByte >> this.currentBytePosition & mask[8 - this.currentBytePosition]);
        int pos = this.getAndIncreasePosition(1);
        if (this.getTotalCountImplementation() <= pos) {
            this.currentBytePosition = 0;
            return b;
        }
        this.currentByte = this.getByteImplementation(pos);
        return (byte)(b | this.currentByte << 8 - this.currentBytePosition);
    }

    protected byte getPartialRawByte(int bits) {
        if (bits == 0) {
            return 0;
        }
        if (bits >= 8 || bits <= -8) {
            return this.getRawByte();
        }
        int count = this.getTotalCountImplementation();
        if (this.currentBytePosition == 0) {
            int pos = this.getAndIncreasePosition(1);
            if (count <= pos) {
                return 0;
            }
            this.currentByte = this.getByteImplementation(pos);
        }
        boolean mostSignificantBits = false;
        if (bits < 0) {
            bits = -bits;
            mostSignificantBits = true;
        }
        byte b = (byte)(this.currentByte >> this.currentBytePosition & mask[8 - this.currentBytePosition]);
        this.currentBytePosition += bits;
        if (this.currentBytePosition >= 8) {
            int pos = this.getAndIncreasePosition(1);
            if (count <= pos) {
                this.currentBytePosition = 0;
                b = (byte)(b & mask[bits]);
                if (mostSignificantBits) {
                    return (byte)(b << 8 - bits);
                }
                return b;
            }
            this.currentByte = this.getByteImplementation(pos);
            this.currentBytePosition -= 8;
            if (this.currentBytePosition != 0) {
                b = (byte)((b | this.currentByte << bits - this.currentBytePosition) & mask[bits]);
                if (mostSignificantBits) {
                    return (byte)(b << 8 - bits);
                }
                return b;
            }
        }
        b = (byte)(b & mask[bits]);
        if (mostSignificantBits) {
            return (byte)(b << 8 - bits);
        }
        return b;
    }

    protected int getUinteger() {
        byte b4;
        byte b3;
        if (this.remaining() < 1) {
            return 0;
        }
        byte b1 = this.getRawByte();
        if ((b1 >> 7 & 1) == 0) {
            return b1 & 0xFF;
        }
        if (this.remaining() < 3) {
            this.empty();
            return 0;
        }
        byte b2 = this.getRawByte();
        int value = (b1 & 0xFF & 0xFFFFFF7F) << 24 | (b2 & 0xFF) << 16 | ((b3 = this.getRawByte()) & 0xFF) << 8 | (b4 = this.getRawByte()) & 0xFF;
        if (value < 128) {
            return 0;
        }
        return value;
    }

    public boolean getBit() {
        return this.getRawBit();
    }

    public byte getByteLeastSignificantBits(int bitcount) {
        if (bitcount <= 0) {
            return 0;
        }
        return this.getPartialRawByte(bitcount);
    }

    public byte getByteMostSignificantBits(int bitcount) {
        if (bitcount <= 0) {
            return 0;
        }
        return this.getPartialRawByte(-bitcount);
    }

    public int getIntegerLeastSignificantBits(int bitcount) {
        if (bitcount <= 0) {
            return 0;
        }
        if (bitcount >= 32) {
            byte b1 = this.getRawByte();
            byte b2 = this.getRawByte();
            byte b3 = this.getRawByte();
            byte b4 = this.getRawByte();
            return (b4 & 0xFF) << 24 | (b3 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b1 & 0xFF;
        }
        if (bitcount > 24) {
            byte b1 = this.getRawByte();
            byte b2 = this.getRawByte();
            byte b3 = this.getRawByte();
            byte b4 = this.getPartialRawByte(bitcount - 24);
            return (b4 & 0xFF) << 24 | (b3 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b1 & 0xFF;
        }
        if (bitcount > 16) {
            byte b1 = this.getRawByte();
            byte b2 = this.getRawByte();
            byte b3 = this.getPartialRawByte(bitcount - 16);
            return (b3 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b1 & 0xFF;
        }
        if (bitcount > 8) {
            byte b1 = this.getRawByte();
            byte b2 = this.getPartialRawByte(bitcount - 8);
            return (b2 & 0xFF) << 8 | b1 & 0xFF;
        }
        byte b1 = this.getPartialRawByte(bitcount);
        return b1 & 0xFF;
    }

    public int getIntegerMostSignificantBits(int bitcount) {
        if (bitcount <= 0) {
            return 0;
        }
        if ((bitcount = -bitcount) <= -32) {
            byte b1 = this.getRawByte();
            byte b2 = this.getRawByte();
            byte b3 = this.getRawByte();
            byte b4 = this.getRawByte();
            return (b4 & 0xFF) << 24 | (b3 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b1 & 0xFF;
        }
        if (bitcount < -24) {
            byte b1 = this.getPartialRawByte(bitcount + 24);
            byte b2 = this.getRawByte();
            byte b3 = this.getRawByte();
            byte b4 = this.getRawByte();
            return (b4 & 0xFF) << 24 | (b3 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b1 & 0xFF;
        }
        if (bitcount < -16) {
            byte b1 = this.getPartialRawByte(bitcount + 16);
            byte b2 = this.getRawByte();
            byte b3 = this.getRawByte();
            return (b3 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8;
        }
        if (bitcount < -8) {
            byte b1 = this.getPartialRawByte(bitcount + 8);
            byte b2 = this.getRawByte();
            return (b2 & 0xFF) << 24 | (b1 & 0xFF) << 16;
        }
        byte b1 = this.getPartialRawByte(bitcount);
        return (b1 & 0xFF) << 24;
    }

    public byte getByte() {
        return this.getRawByte();
    }

    public int getInteger() {
        int remaining = this.remaining();
        if (remaining >= 4) {
            byte b1 = this.getRawByte();
            byte b2 = this.getRawByte();
            byte b3 = this.getRawByte();
            byte b4 = this.getRawByte();
            return (b1 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
        }
        if (remaining == 3) {
            byte b1 = this.getRawByte();
            byte b2 = this.getRawByte();
            byte b3 = this.getRawByte();
            return (b1 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b3 & 0xFF;
        }
        if (remaining == 2) {
            byte b1 = this.getRawByte();
            byte b2 = this.getRawByte();
            return (b1 & 0xFF) << 8 | b2 & 0xFF;
        }
        if (remaining == 1) {
            return this.getRawByte() & 0xFF;
        }
        return 0;
    }

    public int getPositiveInteger1() {
        byte b4;
        byte b3;
        if (this.remaining() < 1) {
            return 0;
        }
        byte b1 = this.getRawByte();
        if ((b1 >> 7 & 1) == 0) {
            return b1 & 0xFF;
        }
        if (this.remaining() < 3) {
            this.empty();
            return 0;
        }
        byte b2 = this.getRawByte();
        int value = (b1 & 0xFF & 0xFFFFFF7F) << 24 | (b2 & 0xFF) << 16 | ((b3 = this.getRawByte()) & 0xFF) << 8 | (b4 = this.getRawByte()) & 0xFF;
        if (value < 128) {
            return 0;
        }
        return value;
    }

    public int getPositiveInteger2() {
        byte b4;
        if (this.remaining() < 2) {
            this.empty();
            return 0;
        }
        byte b1 = this.getRawByte();
        byte b2 = this.getRawByte();
        if ((b1 >> 7 & 1) == 0) {
            return (b1 & 0xFF) << 8 | b2 & 0xFF;
        }
        if (this.remaining() < 2) {
            this.empty();
            return 0;
        }
        byte b3 = this.getRawByte();
        int value = (b1 & 0xFF & 0xFFFFFF7F) << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | (b4 = this.getRawByte()) & 0xFF;
        if (value < 32768) {
            return 0;
        }
        return value;
    }

    public int getPositiveInteger3() {
        if (this.remaining() < 3) {
            this.empty();
            return 0;
        }
        byte b1 = this.getRawByte();
        byte b2 = this.getRawByte();
        byte b3 = this.getRawByte();
        if ((b1 >> 7 & 1) == 0) {
            return (b1 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b3 & 0xFF;
        }
        if (this.remaining() < 1) {
            this.empty();
            return 0;
        }
        byte b4 = this.getRawByte();
        int value = (b1 & 0xFF & 0xFFFFFF7F) << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
        if (value < 0x800000) {
            return 0;
        }
        return value;
    }

    public long getLong() {
        int remaining = this.remaining();
        if (remaining >= 8) {
            byte b1 = this.getRawByte();
            byte b2 = this.getRawByte();
            byte b3 = this.getRawByte();
            byte b4 = this.getRawByte();
            byte b5 = this.getRawByte();
            byte b6 = this.getRawByte();
            byte b7 = this.getRawByte();
            byte b8 = this.getRawByte();
            return ((long)b1 & 0xFFL) << 56 | ((long)b2 & 0xFFL) << 48 | ((long)b3 & 0xFFL) << 40 | ((long)b4 & 0xFFL) << 32 | ((long)b5 & 0xFFL) << 24 | ((long)b6 & 0xFFL) << 16 | ((long)b7 & 0xFFL) << 8 | (long)b8 & 0xFFL;
        }
        if (remaining == 7) {
            byte b1 = this.getRawByte();
            byte b2 = this.getRawByte();
            byte b3 = this.getRawByte();
            byte b4 = this.getRawByte();
            byte b5 = this.getRawByte();
            byte b6 = this.getRawByte();
            byte b7 = this.getRawByte();
            return ((long)b1 & 0xFFL) << 48 | ((long)b2 & 0xFFL) << 40 | ((long)b3 & 0xFFL) << 32 | ((long)b4 & 0xFFL) << 24 | ((long)b5 & 0xFFL) << 16 | ((long)b6 & 0xFFL) << 8 | (long)b7 & 0xFFL;
        }
        if (remaining == 6) {
            byte b1 = this.getRawByte();
            byte b2 = this.getRawByte();
            byte b3 = this.getRawByte();
            byte b4 = this.getRawByte();
            byte b5 = this.getRawByte();
            byte b6 = this.getRawByte();
            return ((long)b1 & 0xFFL) << 40 | ((long)b2 & 0xFFL) << 32 | ((long)b3 & 0xFFL) << 24 | ((long)b4 & 0xFFL) << 16 | ((long)b5 & 0xFFL) << 8 | (long)b6 & 0xFFL;
        }
        if (remaining == 5) {
            byte b1 = this.getRawByte();
            byte b2 = this.getRawByte();
            byte b3 = this.getRawByte();
            byte b4 = this.getRawByte();
            byte b5 = this.getRawByte();
            return ((long)b1 & 0xFFL) << 32 | ((long)b2 & 0xFFL) << 24 | ((long)b3 & 0xFFL) << 16 | ((long)b4 & 0xFFL) << 8 | (long)b5 & 0xFFL;
        }
        if (remaining == 4) {
            byte b1 = this.getRawByte();
            byte b2 = this.getRawByte();
            byte b3 = this.getRawByte();
            byte b4 = this.getRawByte();
            return ((long)b1 & 0xFFL) << 24 | ((long)b2 & 0xFFL) << 16 | ((long)b3 & 0xFFL) << 8 | (long)b4 & 0xFFL;
        }
        if (remaining == 3) {
            byte b1 = this.getRawByte();
            byte b2 = this.getRawByte();
            byte b3 = this.getRawByte();
            return ((long)b1 & 0xFFL) << 16 | ((long)b2 & 0xFFL) << 8 | (long)b3 & 0xFFL;
        }
        if (remaining == 2) {
            byte b1 = this.getRawByte();
            byte b2 = this.getRawByte();
            return ((long)b1 & 0xFFL) << 8 | (long)b2 & 0xFFL;
        }
        if (remaining == 1) {
            return (long)this.getRawByte() & 0xFFL;
        }
        return 0L;
    }

    public float getFloat() {
        return Float.intBitsToFloat(this.getInteger());
    }

    public double getDouble() {
        return Double.longBitsToDouble(this.getLong());
    }

    public boolean getBoolean() {
        return this.getRawBit();
    }

    public String getStringUtf8() {
        int length = this.getUinteger();
        if ((length = Math.min(length, this.maxElementsRemaining(1))) <= 0) {
            return "";
        }
        if (this.currentBytePosition == 0) {
            int pos = this.getAndIncreasePosition(length);
            return this.getStringUtf8Implementation(pos, length);
        }
        byte[] array = new byte[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.getRawByte();
        }
        return LowEntry.bytesToStringUtf8(array);
    }

    protected abstract String getStringUtf8Implementation(int var1, int var2);

    public String getStringLatin1() {
        int length = this.getUinteger();
        if ((length = Math.min(length, this.maxElementsRemaining(1))) <= 0) {
            return "";
        }
        if (this.currentBytePosition == 0) {
            int pos = this.getAndIncreasePosition(length);
            return this.getStringLatin1Implementation(pos, length);
        }
        byte[] array = new byte[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.getRawByte();
        }
        return LowEntry.bytesToStringLatin1(array);
    }

    protected abstract String getStringLatin1Implementation(int var1, int var2);

    public boolean[] getBitArray() {
        int length = this.getUinteger();
        if ((length = Math.min(length, this.maxElementsRemaining(1))) <= 0) {
            return new boolean[0];
        }
        boolean[] array = new boolean[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.getRawBit();
        }
        return array;
    }

    public byte[] getByteArrayLeastSignificantBits(int bitcount) {
        int length = this.getUinteger();
        if (bitcount <= 0) {
            return new byte[0];
        }
        if ((length = Math.min(length, (int)Math.round(Math.ceil((double)this.maxElementsRemaining(1) * (8.0 / (double)bitcount))))) <= 0) {
            return new byte[0];
        }
        byte[] array = new byte[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.getByteLeastSignificantBits(bitcount);
        }
        return array;
    }

    public byte[] getByteArrayMostSignificantBits(int bitcount) {
        int length = this.getUinteger();
        if (bitcount <= 0) {
            return new byte[0];
        }
        if ((length = Math.min(length, (int)Math.round(Math.ceil((double)this.maxElementsRemaining(1) * (8.0 / (double)bitcount))))) <= 0) {
            return new byte[0];
        }
        byte[] array = new byte[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.getByteMostSignificantBits(bitcount);
        }
        return array;
    }

    public int[] getIntegerArrayLeastSignificantBits(int bitcount) {
        int length = this.getUinteger();
        if (bitcount <= 0) {
            return new int[0];
        }
        if ((length = Math.min(length, (int)Math.round(Math.ceil((double)this.maxElementsRemaining(1) * (8.0 / (double)bitcount))))) <= 0) {
            return new int[0];
        }
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.getIntegerLeastSignificantBits(bitcount);
        }
        return array;
    }

    public int[] getIntegerArrayMostSignificantBits(int bitcount) {
        int length = this.getUinteger();
        if (bitcount <= 0) {
            return new int[0];
        }
        if ((length = Math.min(length, (int)Math.round(Math.ceil((double)this.maxElementsRemaining(1) * (8.0 / (double)bitcount))))) <= 0) {
            return new int[0];
        }
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.getIntegerMostSignificantBits(bitcount);
        }
        return array;
    }

    public byte[] getByteArray() {
        int length = this.getUinteger();
        if ((length = Math.min(length, this.maxElementsRemaining(1))) <= 0) {
            return new byte[0];
        }
        if (this.currentBytePosition == 0) {
            int pos = this.getAndIncreasePosition(length);
            return this.getByteArrayImplementation(pos, length);
        }
        byte[] array = new byte[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.getRawByte();
        }
        return array;
    }

    protected abstract byte[] getByteArrayImplementation(int var1, int var2);

    public int[] getIntegerArray() {
        int length = this.getUinteger();
        if ((length = Math.min(length, this.maxElementsRemaining(4))) <= 0) {
            return new int[0];
        }
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.getInteger();
        }
        return array;
    }

    public int[] getPositiveInteger1Array() {
        int length = this.getUinteger();
        if ((length = Math.min(length, this.maxElementsRemaining(1))) <= 0) {
            return new int[0];
        }
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.getPositiveInteger1();
        }
        return array;
    }

    public int[] getPositiveInteger2Array() {
        int length = this.getUinteger();
        if ((length = Math.min(length, this.maxElementsRemaining(2))) <= 0) {
            return new int[0];
        }
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.getPositiveInteger2();
        }
        return array;
    }

    public int[] getPositiveInteger3Array() {
        int length = this.getUinteger();
        if ((length = Math.min(length, this.maxElementsRemaining(3))) <= 0) {
            return new int[0];
        }
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.getPositiveInteger3();
        }
        return array;
    }

    public long[] getLongArray() {
        int length = this.getUinteger();
        if ((length = Math.min(length, this.maxElementsRemaining(8))) <= 0) {
            return new long[0];
        }
        long[] array = new long[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.getLong();
        }
        return array;
    }

    public float[] getFloatArray() {
        int length = this.getUinteger();
        if ((length = Math.min(length, this.maxElementsRemaining(4))) <= 0) {
            return new float[0];
        }
        float[] array = new float[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.getFloat();
        }
        return array;
    }

    public double[] getDoubleArray() {
        int length = this.getUinteger();
        if ((length = Math.min(length, this.maxElementsRemaining(8))) <= 0) {
            return new double[0];
        }
        double[] array = new double[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.getDouble();
        }
        return array;
    }

    public boolean[] getBooleanArray() {
        int length = this.getUinteger();
        if ((length = Math.min(length, BitDataReader.safeMultiply(this.maxElementsRemaining(1), 8))) <= 0) {
            return new boolean[0];
        }
        boolean[] array = new boolean[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.getBoolean();
        }
        return array;
    }

    public String[] getStringUtf8Array() {
        int length = this.getUinteger();
        if ((length = Math.min(length, this.maxElementsRemaining(1))) <= 0) {
            return new String[0];
        }
        String[] array = new String[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.getStringUtf8();
        }
        return array;
    }

    public String[] getStringLatin1Array() {
        int length = this.getUinteger();
        if ((length = Math.min(length, this.maxElementsRemaining(1))) <= 0) {
            return new String[0];
        }
        String[] array = new String[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.getStringLatin1();
        }
        return array;
    }

    protected static int safeMultiply(int a, int b) {
        long result = (long)a * (long)b;
        if (result > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (result < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)result;
    }
}

