/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes;

import java.nio.ByteBuffer;
import java.util.Collection;
import lowentry.ue4.library.LowEntry;

public abstract class ByteDataWriter {
    public abstract byte[] getBytes();

    public ByteBuffer getByteBuffer() {
        return ByteBuffer.wrap(this.getBytes());
    }

    public abstract ByteDataWriter reset();

    protected abstract void addRawByte(byte var1);

    protected abstract void addRawBytes(byte[] var1);

    protected abstract void addingUnsafe(int var1);

    protected abstract void addRawByteUnsafe(byte var1);

    protected abstract void addRawBytesUnsafe(byte[] var1);

    protected void addUinteger(int value) {
        if (value <= 0) {
            this.addRawByte((byte)0);
        } else if (value < 128) {
            this.addRawByte((byte)value);
        } else {
            this.addingUnsafe(4);
            this.addRawByteUnsafe((byte)(value >> 24 | 0x80));
            this.addRawByteUnsafe((byte)(value >> 16));
            this.addRawByteUnsafe((byte)(value >> 8));
            this.addRawByteUnsafe((byte)value);
        }
    }

    protected void addUintegerUnsafe(int value) {
        if (value <= 0) {
            this.addRawByteUnsafe((byte)0);
        } else if (value < 128) {
            this.addRawByteUnsafe((byte)value);
        } else {
            this.addRawByteUnsafe((byte)(value >> 24 | 0x80));
            this.addRawByteUnsafe((byte)(value >> 16));
            this.addRawByteUnsafe((byte)(value >> 8));
            this.addRawByteUnsafe((byte)value);
        }
    }

    public ByteDataWriter add(byte value) {
        this.addByte(value);
        return this;
    }

    public ByteDataWriter add(int value) {
        this.addInteger(value);
        return this;
    }

    public ByteDataWriter add(long value) {
        this.addLong(value);
        return this;
    }

    public ByteDataWriter add(float value) {
        this.addFloat(value);
        return this;
    }

    public ByteDataWriter add(double value) {
        this.addDouble(value);
        return this;
    }

    public ByteDataWriter add(boolean value) {
        this.addBoolean(value);
        return this;
    }

    public ByteDataWriter add(String value) {
        this.addStringUtf8(value);
        return this;
    }

    public ByteDataWriter add(Byte value) {
        this.addByte(value);
        return this;
    }

    public ByteDataWriter add(Integer value) {
        this.addInteger(value);
        return this;
    }

    public ByteDataWriter add(Long value) {
        this.addLong(value);
        return this;
    }

    public ByteDataWriter add(Float value) {
        this.addFloat(value);
        return this;
    }

    public ByteDataWriter add(Double value) {
        this.addDouble(value);
        return this;
    }

    public ByteDataWriter add(Boolean value) {
        this.addBoolean(value);
        return this;
    }

    public ByteDataWriter add(byte[] value) {
        this.addByteArray(value);
        return this;
    }

    public ByteDataWriter add(int[] value) {
        this.addIntegerArray(value);
        return this;
    }

    public ByteDataWriter add(long[] value) {
        this.addLongArray(value);
        return this;
    }

    public ByteDataWriter add(float[] value) {
        this.addFloatArray(value);
        return this;
    }

    public ByteDataWriter add(double[] value) {
        this.addDoubleArray(value);
        return this;
    }

    public ByteDataWriter add(boolean[] value) {
        this.addBooleanArray(value);
        return this;
    }

    public ByteDataWriter add(String[] value) {
        this.addStringUtf8Array(value);
        return this;
    }

    public ByteDataWriter add(Byte[] value) {
        this.addByteArray(value);
        return this;
    }

    public ByteDataWriter add(Integer[] value) {
        this.addIntegerArray(value);
        return this;
    }

    public ByteDataWriter add(Long[] value) {
        this.addLongArray(value);
        return this;
    }

    public ByteDataWriter add(Float[] value) {
        this.addFloatArray(value);
        return this;
    }

    public ByteDataWriter add(Double[] value) {
        this.addDoubleArray(value);
        return this;
    }

    public ByteDataWriter add(Boolean[] value) {
        this.addBooleanArray(value);
        return this;
    }

    public ByteDataWriter add(Collection<?> value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        for (Byte by : value) {
            if (by == null) continue;
            if (by instanceof Byte) {
                this.addByteArray(value);
            } else if (by instanceof Integer) {
                this.addIntegerArray(value);
            } else if (by instanceof Long) {
                this.addLongArray(value);
            } else if (by instanceof Float) {
                this.addFloatArray(value);
            } else if (by instanceof Double) {
                this.addDoubleArray(value);
            } else if (by instanceof Boolean) {
                this.addBooleanArray(value);
            } else if (by instanceof String) {
                this.addStringUtf8Array(value);
            } else {
                this.addUinteger(0);
            }
            return this;
        }
        this.addUinteger(0);
        return this;
    }

    public ByteDataWriter addByte(byte value) {
        this.addRawByte(value);
        return this;
    }

    public ByteDataWriter addInteger(int value) {
        this.addingUnsafe(4);
        this.addRawByteUnsafe((byte)(value >> 24));
        this.addRawByteUnsafe((byte)(value >> 16));
        this.addRawByteUnsafe((byte)(value >> 8));
        this.addRawByteUnsafe((byte)value);
        return this;
    }

    public ByteDataWriter addPositiveInteger1(int value) {
        if (value <= 0) {
            this.addRawByte((byte)0);
        } else if (value < 128) {
            this.addRawByte((byte)value);
        } else {
            this.addingUnsafe(4);
            this.addRawByteUnsafe((byte)(value >> 24 | 0x80));
            this.addRawByteUnsafe((byte)(value >> 16));
            this.addRawByteUnsafe((byte)(value >> 8));
            this.addRawByteUnsafe((byte)value);
        }
        return this;
    }

    public ByteDataWriter addPositiveInteger2(int value) {
        if (value <= 0) {
            this.addRawByte((byte)0);
        } else if (value < 32768) {
            this.addingUnsafe(2);
            this.addRawByteUnsafe((byte)(value >> 8));
            this.addRawByteUnsafe((byte)value);
        } else {
            this.addingUnsafe(4);
            this.addRawByteUnsafe((byte)(value >> 24 | 0x80));
            this.addRawByteUnsafe((byte)(value >> 16));
            this.addRawByteUnsafe((byte)(value >> 8));
            this.addRawByteUnsafe((byte)value);
        }
        return this;
    }

    public ByteDataWriter addPositiveInteger3(int value) {
        if (value <= 0) {
            this.addRawByte((byte)0);
        } else if (value < 0x800000) {
            this.addingUnsafe(3);
            this.addRawByteUnsafe((byte)(value >> 16));
            this.addRawByteUnsafe((byte)(value >> 8));
            this.addRawByteUnsafe((byte)value);
        } else {
            this.addingUnsafe(4);
            this.addRawByteUnsafe((byte)(value >> 24 | 0x80));
            this.addRawByteUnsafe((byte)(value >> 16));
            this.addRawByteUnsafe((byte)(value >> 8));
            this.addRawByteUnsafe((byte)value);
        }
        return this;
    }

    public ByteDataWriter addLong(long value) {
        this.addingUnsafe(8);
        this.addRawByteUnsafe((byte)(value >> 56));
        this.addRawByteUnsafe((byte)(value >> 48));
        this.addRawByteUnsafe((byte)(value >> 40));
        this.addRawByteUnsafe((byte)(value >> 32));
        this.addRawByteUnsafe((byte)(value >> 24));
        this.addRawByteUnsafe((byte)(value >> 16));
        this.addRawByteUnsafe((byte)(value >> 8));
        this.addRawByteUnsafe((byte)value);
        return this;
    }

    public ByteDataWriter addFloat(float value) {
        this.addInteger(Float.floatToIntBits(value));
        return this;
    }

    public ByteDataWriter addDouble(double value) {
        this.addLong(Double.doubleToLongBits(value));
        return this;
    }

    public ByteDataWriter addBoolean(boolean value) {
        if (value) {
            this.addRawByte((byte)1);
        } else {
            this.addRawByte((byte)0);
        }
        return this;
    }

    public ByteDataWriter addStringUtf8(String value) {
        this.addByteArray(LowEntry.stringToBytesUtf8(value));
        return this;
    }

    public ByteDataWriter addStringLatin1(String value) {
        this.addByteArray(LowEntry.stringToBytesLatin1(value));
        return this;
    }

    public ByteDataWriter addByte(Byte value) {
        if (value == null) {
            this.addByte((byte)0);
        } else {
            this.addByte((byte)value);
        }
        return this;
    }

    public ByteDataWriter addInteger(Integer value) {
        if (value == null) {
            this.addInteger(0);
        } else {
            this.addInteger((int)value);
        }
        return this;
    }

    public ByteDataWriter addPositiveInteger1(Integer value) {
        if (value == null) {
            this.addPositiveInteger1(0);
        } else {
            this.addPositiveInteger1((int)value);
        }
        return this;
    }

    public ByteDataWriter addPositiveInteger2(Integer value) {
        if (value == null) {
            this.addPositiveInteger2(0);
        } else {
            this.addPositiveInteger2((int)value);
        }
        return this;
    }

    public ByteDataWriter addPositiveInteger3(Integer value) {
        if (value == null) {
            this.addPositiveInteger3(0);
        } else {
            this.addPositiveInteger3((int)value);
        }
        return this;
    }

    public ByteDataWriter addLong(Long value) {
        if (value == null) {
            this.addLong(0L);
        } else {
            this.addLong((long)value);
        }
        return this;
    }

    public ByteDataWriter addFloat(Float value) {
        if (value == null) {
            this.addFloat(0.0f);
        } else {
            this.addFloat(value.floatValue());
        }
        return this;
    }

    public ByteDataWriter addDouble(Double value) {
        if (value == null) {
            this.addDouble(0.0);
        } else {
            this.addDouble((double)value);
        }
        return this;
    }

    public ByteDataWriter addBoolean(Boolean value) {
        if (value == null) {
            this.addBoolean(false);
        } else {
            this.addBoolean((boolean)value);
        }
        return this;
    }

    public ByteDataWriter addByteArray(byte[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        this.addRawBytes(value);
        return this;
    }

    public ByteDataWriter addIntegerArray(int[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (int v : value) {
            this.addInteger(v);
        }
        return this;
    }

    public ByteDataWriter addPositiveInteger1Array(int[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (int v : value) {
            this.addPositiveInteger1(v);
        }
        return this;
    }

    public ByteDataWriter addPositiveInteger2Array(int[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (int v : value) {
            this.addPositiveInteger2(v);
        }
        return this;
    }

    public ByteDataWriter addPositiveInteger3Array(int[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (int v : value) {
            this.addPositiveInteger3(v);
        }
        return this;
    }

    public ByteDataWriter addLongArray(long[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (long v : value) {
            this.addLong(v);
        }
        return this;
    }

    public ByteDataWriter addFloatArray(float[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (float v : value) {
            this.addFloat(v);
        }
        return this;
    }

    public ByteDataWriter addDoubleArray(double[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (double v : value) {
            this.addDouble(v);
        }
        return this;
    }

    public ByteDataWriter addBooleanArray(boolean[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        byte b = 0;
        int bIndex = 0;
        for (boolean v : value) {
            if (v) {
                b = (byte)(b | 1 << 7 - bIndex);
            }
            if (++bIndex != 8) continue;
            this.addRawByte(b);
            b = 0;
            bIndex = 0;
        }
        if (bIndex > 0) {
            this.addRawByte(b);
        }
        return this;
    }

    public ByteDataWriter addStringUtf8Array(String[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (String v : value) {
            this.addStringUtf8(v);
        }
        return this;
    }

    public ByteDataWriter addStringLatin1Array(String[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (String v : value) {
            this.addStringLatin1(v);
        }
        return this;
    }

    public ByteDataWriter addByteArray(Byte[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (Byte v : value) {
            this.addByte(v);
        }
        return this;
    }

    public ByteDataWriter addIntegerArray(Integer[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (Integer v : value) {
            this.addInteger(v);
        }
        return this;
    }

    public ByteDataWriter addPositiveInteger1Array(Integer[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (Integer v : value) {
            this.addPositiveInteger1(v);
        }
        return this;
    }

    public ByteDataWriter addPositiveInteger2Array(Integer[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (Integer v : value) {
            this.addPositiveInteger2(v);
        }
        return this;
    }

    public ByteDataWriter addPositiveInteger3Array(Integer[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (Integer v : value) {
            this.addPositiveInteger3(v);
        }
        return this;
    }

    public ByteDataWriter addLongArray(Long[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (Long v : value) {
            this.addLong(v);
        }
        return this;
    }

    public ByteDataWriter addFloatArray(Float[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (Float v : value) {
            this.addFloat(v);
        }
        return this;
    }

    public ByteDataWriter addDoubleArray(Double[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (Double v : value) {
            this.addDouble(v);
        }
        return this;
    }

    public ByteDataWriter addBooleanArray(Boolean[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        byte b = 0;
        int bIndex = 0;
        for (Boolean v : value) {
            if (v.booleanValue()) {
                b = (byte)(b | 1 << 7 - bIndex);
            }
            if (++bIndex != 8) continue;
            this.addRawByte(b);
            b = 0;
            bIndex = 0;
        }
        if (bIndex > 0) {
            this.addRawByte(b);
        }
        return this;
    }

    public ByteDataWriter addByteArray(Collection<Byte> value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.size());
        for (Byte v : value) {
            this.addByte(v);
        }
        return this;
    }

    public ByteDataWriter addIntegerArray(Collection<Integer> value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.size());
        for (Integer v : value) {
            this.addInteger(v);
        }
        return this;
    }

    public ByteDataWriter addPositiveInteger1Array(Collection<Integer> value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.size());
        for (Integer v : value) {
            this.addPositiveInteger1(v);
        }
        return this;
    }

    public ByteDataWriter addPositiveInteger2Array(Collection<Integer> value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.size());
        for (Integer v : value) {
            this.addPositiveInteger2(v);
        }
        return this;
    }

    public ByteDataWriter addPositiveInteger3Array(Collection<Integer> value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.size());
        for (Integer v : value) {
            this.addPositiveInteger3(v);
        }
        return this;
    }

    public ByteDataWriter addLongArray(Collection<Long> value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.size());
        for (Long v : value) {
            this.addLong(v);
        }
        return this;
    }

    public ByteDataWriter addFloatArray(Collection<Float> value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.size());
        for (Float v : value) {
            this.addFloat(v);
        }
        return this;
    }

    public ByteDataWriter addDoubleArray(Collection<Double> value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.size());
        for (Double v : value) {
            this.addDouble(v);
        }
        return this;
    }

    public ByteDataWriter addBooleanArray(Collection<Boolean> value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.size());
        byte b = 0;
        int bIndex = 0;
        for (Boolean v : value) {
            if (v.booleanValue()) {
                b = (byte)(b | 1 << 7 - bIndex);
            }
            if (++bIndex != 8) continue;
            this.addRawByte(b);
            b = 0;
            bIndex = 0;
        }
        if (bIndex > 0) {
            this.addRawByte(b);
        }
        return this;
    }

    public ByteDataWriter addStringUtf8Array(Collection<String> value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.size());
        for (String v : value) {
            this.addStringUtf8(v);
        }
        return this;
    }

    public ByteDataWriter addStringLatin1Array(Collection<String> value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.size());
        for (String v : value) {
            this.addStringLatin1(v);
        }
        return this;
    }
}

