/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes;

import java.util.Date;
import java.util.Objects;

public final class ParsedHashcash {
    protected final boolean valid;
    protected final String resource;
    protected final Date date;
    protected final int bits;
    protected Integer hashCode = null;

    public ParsedHashcash(boolean valid, String resource, Date date, int bits) {
        this.valid = valid;
        this.resource = resource;
        this.date = date;
        this.bits = bits;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getResource() {
        return this.resource;
    }

    public Date getDate() {
        return this.date;
    }

    public int getBits() {
        return this.bits;
    }

    public String toString() {
        if (!this.valid) {
            return this.getClass().getSimpleName() + "{invalid}";
        }
        return this.getClass().getSimpleName() + "{resource=\"" + this.resource + "\", date=\"" + this.date + "\", bits=" + this.bits + "}";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ParsedHashcash)) {
            return false;
        }
        ParsedHashcash o = (ParsedHashcash)obj;
        if (this.valid != o.valid || this.bits == o.bits) {
            return false;
        }
        if (this.resource == null ? o.resource != null : o.resource == null || !this.resource.equals(o.resource)) {
            return false;
        }
        if (this.date == null) {
            return o.date == null;
        }
        return o.date != null && this.date.equals(o.date);
    }

    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = Objects.hash(this.valid, this.resource, this.date, this.bits);
        }
        return this.hashCode;
    }
}

