/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.bitdata.reader;

import lowentry.ue4.classes.BitDataReader;
import lowentry.ue4.library.LowEntry;

public class BitArrayDataReader
extends BitDataReader {
    protected final byte[] bytes;
    protected final int subLength;

    public BitArrayDataReader(byte[] bytes) {
        this.bytes = bytes;
        this.subLength = bytes == null ? 0 : bytes.length;
    }

    public BitArrayDataReader(byte[] bytes, int length) {
        this.bytes = bytes;
        this.subLength = bytes == null || length < 0 ? 0 : length;
    }

    protected BitArrayDataReader(byte[] bytes, int subLength, int position, byte currentByte, int currentBytePosition) {
        this.bytes = bytes;
        this.subLength = subLength;
        this.position = position;
        this.currentByte = currentByte;
        this.currentBytePosition = currentBytePosition;
    }

    @Override
    public BitArrayDataReader getClone() {
        return new BitArrayDataReader(this.bytes, this.subLength, this.position, this.currentByte, this.currentBytePosition);
    }

    @Override
    protected int getTotalCountImplementation() {
        return this.subLength;
    }

    @Override
    public byte getByteImplementation(int index) {
        return this.bytes[index];
    }

    @Override
    protected String getStringUtf8Implementation(int index, int length) {
        return LowEntry.bytesToStringUtf8(this.bytes, index, length);
    }

    @Override
    protected String getStringLatin1Implementation(int index, int length) {
        return LowEntry.bytesToStringLatin1(this.bytes, index, length);
    }

    @Override
    protected byte[] getByteArrayImplementation(int index, int length) {
        return LowEntry.bytesSubArray(this.bytes, index, length);
    }
}

