/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.bitdata.reader;

import java.nio.ByteBuffer;
import lowentry.ue4.classes.BitDataReader;
import lowentry.ue4.library.LowEntry;

public class BitBufferDataReader
extends BitDataReader {
    protected final ByteBuffer bytes;
    protected final int subLength;

    public BitBufferDataReader(ByteBuffer bytes) {
        this.bytes = bytes;
        this.subLength = bytes == null ? 0 : bytes.remaining();
    }

    public BitBufferDataReader(ByteBuffer bytes, int length) {
        this.bytes = bytes;
        this.subLength = bytes == null || length < 0 ? 0 : length;
    }

    protected BitBufferDataReader(ByteBuffer bytes, int subLength, int position) {
        this.bytes = bytes;
        this.subLength = subLength;
        this.position = position;
    }

    @Override
    public BitDataReader getClone() {
        return new BitBufferDataReader(this.bytes, this.subLength, this.position);
    }

    @Override
    protected int getTotalCountImplementation() {
        return this.subLength;
    }

    @Override
    public byte getByteImplementation(int index) {
        return this.bytes.get(index);
    }

    @Override
    protected String getStringUtf8Implementation(int index, int length) {
        if (this.bytes.hasArray()) {
            return LowEntry.bytesToStringUtf8(this.bytes.array(), this.bytes.arrayOffset() + index, length);
        }
        byte[] b = new byte[length];
        this.bytes.get(b, index, length);
        return LowEntry.bytesToStringUtf8(b);
    }

    @Override
    protected String getStringLatin1Implementation(int index, int length) {
        if (this.bytes.hasArray()) {
            return LowEntry.bytesToStringLatin1(this.bytes.array(), this.bytes.arrayOffset() + index, length);
        }
        byte[] b = new byte[length];
        this.bytes.get(b, index, length);
        return LowEntry.bytesToStringLatin1(b);
    }

    @Override
    protected byte[] getByteArrayImplementation(int index, int length) {
        if (this.bytes.hasArray()) {
            return LowEntry.bytesSubArray(this.bytes.array(), this.bytes.arrayOffset() + index, length);
        }
        byte[] b = new byte[length];
        this.bytes.get(b, index, length);
        return b;
    }
}

