/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.bitdata.writer;

import java.nio.ByteBuffer;
import lowentry.ue4.classes.BitDataWriter;

public class BitBufferDataWriter
extends BitDataWriter {
    protected final ByteBuffer bytes;

    public BitBufferDataWriter(ByteBuffer buffer) {
        buffer.clear();
        this.bytes = buffer;
    }

    @Override
    protected byte[] getBytesImplementation() {
        ByteBuffer shallowCopy = this.getByteBufferImplementation();
        byte[] b = new byte[shallowCopy.remaining()];
        shallowCopy.get(b);
        return b;
    }

    @Override
    protected byte[] getBytesImplementation(byte addByteToEnd) {
        ByteBuffer shallowCopy = this.getByteBufferImplementation(addByteToEnd);
        byte[] b = new byte[shallowCopy.remaining()];
        shallowCopy.get(b);
        return b;
    }

    @Override
    public ByteBuffer getByteBufferImplementation() {
        ByteBuffer shallowCopy = this.bytes.duplicate();
        shallowCopy.flip();
        return shallowCopy;
    }

    @Override
    public ByteBuffer getByteBufferImplementation(byte addByteToEnd) {
        ByteBuffer shallowCopy = this.bytes.duplicate();
        shallowCopy.put(addByteToEnd);
        shallowCopy.flip();
        return shallowCopy;
    }

    @Override
    protected void resetImplementation() {
        this.bytes.clear();
    }

    @Override
    protected void addRawByteImplementation(byte value) {
        this.bytes.put(value);
    }

    @Override
    protected void addRawBytesImplementation(byte[] value) {
        if (value == null) {
            return;
        }
        this.bytes.put(value);
    }

    @Override
    protected void addingUnsafeImplementation(int count) {
    }

    @Override
    protected void addRawByteUnsafeImplementation(byte value) {
        this.bytes.put(value);
    }

    @Override
    protected void addRawBytesUnsafeImplementation(byte[] value) {
        if (value == null) {
            return;
        }
        this.bytes.put(value);
    }
}

