/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.bytedata.reader;

import lowentry.ue4.classes.ByteDataReader;
import lowentry.ue4.library.LowEntry;

public class ByteSubArrayDataReader
extends ByteDataReader {
    protected final byte[] bytes;
    protected final int subIndex;
    protected final int subLength;

    public ByteSubArrayDataReader(byte[] bytes, int index, int length) {
        this.bytes = bytes;
        if (bytes == null || length < 0) {
            this.subIndex = 0;
            this.subLength = 0;
        } else {
            this.subIndex = index;
            this.subLength = length;
        }
    }

    protected ByteSubArrayDataReader(byte[] bytes, int subIndex, int subLength, int position) {
        this.bytes = bytes;
        this.subIndex = subIndex;
        this.subLength = subLength;
        this.position = position;
    }

    @Override
    public ByteDataReader getClone() {
        return new ByteSubArrayDataReader(this.bytes, this.subIndex, this.subLength, this.position);
    }

    @Override
    protected int getTotalCountImplementation() {
        return this.subLength;
    }

    @Override
    public byte getByteImplementation(int index) {
        return this.bytes[this.subIndex + index];
    }

    @Override
    protected String getStringUtf8Implementation(int index, int length) {
        return LowEntry.bytesToStringUtf8(this.bytes, this.subIndex + index, length);
    }

    @Override
    protected String getStringLatin1Implementation(int index, int length) {
        return LowEntry.bytesToStringLatin1(this.bytes, this.subIndex + index, length);
    }

    @Override
    protected byte[] getByteArrayImplementation(int index, int length) {
        return LowEntry.bytesSubArray(this.bytes, this.subIndex + index, length);
    }
}

