/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.bytedata.reader;

import lowentry.ue4.classes.SimpleByteDataReader;
import lowentry.ue4.library.LowEntry;

public class SimpleByteArrayDataReader
extends SimpleByteDataReader {
    protected final byte[] bytes;
    protected final int subLength;

    public SimpleByteArrayDataReader(byte[] bytes) {
        this.bytes = bytes;
        this.subLength = bytes == null ? 0 : bytes.length;
    }

    public SimpleByteArrayDataReader(byte[] bytes, int length) {
        this.bytes = bytes;
        this.subLength = bytes == null || length < 0 ? 0 : length;
    }

    protected SimpleByteArrayDataReader(byte[] bytes, int subLength, int position) {
        this.bytes = bytes;
        this.subLength = subLength;
        this.position = position;
    }

    @Override
    public SimpleByteArrayDataReader getClone() {
        return new SimpleByteArrayDataReader(this.bytes, this.subLength, this.position);
    }

    @Override
    protected int getTotalCountImplementation() {
        return this.subLength;
    }

    @Override
    public byte getByteImplementation(int index) {
        return this.bytes[index];
    }

    @Override
    protected String getStringUtf8Implementation(int index, int length) {
        return LowEntry.bytesToStringUtf8(this.bytes, index, length);
    }

    @Override
    protected String getStringLatin1Implementation(int index, int length) {
        return LowEntry.bytesToStringLatin1(this.bytes, index, length);
    }

    @Override
    protected byte[] getByteArrayImplementation(int index, int length) {
        return LowEntry.bytesSubArray(this.bytes, index, length);
    }
}

