/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.bytedata.reader;

import java.nio.ByteBuffer;
import lowentry.ue4.classes.SimpleByteDataReader;
import lowentry.ue4.library.LowEntry;

public class SimpleByteSubBufferDataReader
extends SimpleByteDataReader {
    protected final ByteBuffer bytes;
    protected final int subIndex;
    protected final int subLength;

    public SimpleByteSubBufferDataReader(ByteBuffer bytes, int index, int length) {
        this.bytes = bytes;
        if (bytes == null || length < 0) {
            this.subIndex = 0;
            this.subLength = 0;
        } else {
            this.subIndex = index;
            this.subLength = length;
        }
    }

    protected SimpleByteSubBufferDataReader(ByteBuffer bytes, int subIndex, int subLength, int position) {
        this.bytes = bytes;
        this.subIndex = subIndex;
        this.subLength = subLength;
        this.position = position;
    }

    @Override
    public SimpleByteDataReader getClone() {
        return new SimpleByteSubBufferDataReader(this.bytes, this.subIndex, this.subLength, this.position);
    }

    @Override
    protected int getTotalCountImplementation() {
        return this.subLength;
    }

    @Override
    public byte getByteImplementation(int index) {
        return this.bytes.get(this.subIndex + index);
    }

    @Override
    protected String getStringUtf8Implementation(int index, int length) {
        if (this.bytes.hasArray()) {
            return LowEntry.bytesToStringUtf8(this.bytes.array(), this.bytes.arrayOffset() + this.subIndex + index, length);
        }
        byte[] b = new byte[length];
        this.bytes.get(b, this.subIndex + index, length);
        return LowEntry.bytesToStringUtf8(b);
    }

    @Override
    protected String getStringLatin1Implementation(int index, int length) {
        if (this.bytes.hasArray()) {
            return LowEntry.bytesToStringLatin1(this.bytes.array(), this.bytes.arrayOffset() + this.subIndex + index, length);
        }
        byte[] b = new byte[length];
        this.bytes.get(b, this.subIndex + index, length);
        return LowEntry.bytesToStringLatin1(b);
    }

    @Override
    protected byte[] getByteArrayImplementation(int index, int length) {
        if (this.bytes.hasArray()) {
            return LowEntry.bytesSubArray(this.bytes.array(), this.bytes.arrayOffset() + this.subIndex + index, length);
        }
        byte[] b = new byte[length];
        this.bytes.get(b, this.subIndex + index, length);
        return b;
    }
}

