/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.bytedata.writer;

import java.nio.ByteBuffer;
import lowentry.ue4.classes.ByteDataWriter;

public class ByteBufferDataWriter
extends ByteDataWriter {
    protected final ByteBuffer bytes;

    public ByteBufferDataWriter(ByteBuffer buffer) {
        buffer.clear();
        this.bytes = buffer;
    }

    @Override
    public byte[] getBytes() {
        ByteBuffer shallowCopy = this.getByteBuffer();
        byte[] b = new byte[shallowCopy.remaining()];
        shallowCopy.get(b);
        return b;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        ByteBuffer shallowCopy = this.bytes.duplicate();
        shallowCopy.flip();
        return shallowCopy;
    }

    @Override
    public ByteBufferDataWriter reset() {
        this.bytes.clear();
        return this;
    }

    @Override
    protected void addRawByte(byte value) {
        this.bytes.put(value);
    }

    @Override
    protected void addRawBytes(byte[] value) {
        if (value == null) {
            return;
        }
        this.bytes.put(value);
    }

    @Override
    protected void addingUnsafe(int count) {
    }

    @Override
    protected void addRawByteUnsafe(byte value) {
        this.bytes.put(value);
    }

    @Override
    protected void addRawBytesUnsafe(byte[] value) {
        if (value == null) {
            return;
        }
        this.bytes.put(value);
    }
}

