/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import lowentry.ue4.classes.http.HttpRequest;
import lowentry.ue4.classes.http.HttpResponse;
import lowentry.ue4.classes.http.HttpServer;
import lowentry.ue4.classes.internal.CachedTime;
import lowentry.ue4.library.LowEntry;

public class HttpClient {
    public static final long TIMEOUT_SECONDS = 30L;
    public static final long TIMEOUT_MS = 30000L;
    public static final long MAX_CONTENT_LENGTH = 20480L;
    public static final int DEFAULT_SO_TIMEOUT = 100;
    protected final HttpServer server;
    protected final Socket client;
    protected final BufferedInputStream input;
    protected final BufferedOutputStream output;
    protected final long creationTime = CachedTime.millisSinceStart();
    protected ByteArrayOutputStream headerBytes = new ByteArrayOutputStream();
    protected byte headerBytesStage = 0;
    protected ByteArrayOutputStream contentBytes = null;
    protected int contentBytesRemaining = 0;
    protected HttpRequest request;
    protected int currentSoTimeout;

    public HttpClient(HttpServer server, Socket client) throws Exception {
        this.server = server;
        this.client = client;
        this.request = new HttpRequest(server.secure);
        this.input = new BufferedInputStream(client.getInputStream());
        this.output = new BufferedOutputStream(client.getOutputStream());
        this.currentSoTimeout = client.getSoTimeout();
        this.setSoTimeout(100);
    }

    protected void listen(long time) throws Exception {
        int available;
        if (time - this.creationTime >= 30000L) {
            this.disconnect();
            return;
        }
        if (this.request == null) {
            if (this.input.read() < 0) {
                this.disconnect();
            }
            return;
        }
        if (this.server.secure) {
            this.setSoTimeout(1);
            try {
                this.read(1);
            }
            catch (Exception e) {
                return;
            }
        }
        if ((available = this.input.available()) <= 0) {
            return;
        }
        if (this.server.secure) {
            this.setSoTimeout(100);
        }
        this.read(available);
    }

    protected void setSoTimeout(int timeout) throws Exception {
        if (this.currentSoTimeout == timeout) {
            return;
        }
        this.client.setSoTimeout(timeout);
        this.currentSoTimeout = timeout;
    }

    protected void read(int max) throws Exception {
        ByteBuffer buffer = this.server.networkBuffer;
        buffer.clear();
        int size = this.input.read(buffer.array(), 0, Math.min(max, buffer.remaining()));
        if (size <= 0) {
            if (size < 0) {
                this.disconnect();
            }
            return;
        }
        buffer.limit(size);
        this.receivedData(buffer);
    }

    protected void receivedData(ByteBuffer data) throws Exception {
        if (this.request == null) {
            return;
        }
        if (this.headerBytes != null) {
            while (data.hasRemaining()) {
                byte b = data.get();
                this.headerBytes.write(b);
                if (this.headerBytes.size() > 8192) {
                    this.disconnect();
                    return;
                }
                if (this.headerBytesStage == 0) {
                    if (b != 13) continue;
                    this.headerBytesStage = (byte)(this.headerBytesStage + 1);
                    continue;
                }
                if (this.headerBytesStage == 1) {
                    if (b == 10) {
                        this.headerBytesStage = (byte)(this.headerBytesStage + 1);
                        continue;
                    }
                    this.headerBytesStage = 0;
                    continue;
                }
                if (this.headerBytesStage == 2) {
                    if (b == 13) {
                        this.headerBytesStage = (byte)(this.headerBytesStage + 1);
                        continue;
                    }
                    this.headerBytesStage = 0;
                    continue;
                }
                if (this.headerBytesStage == 3) {
                    this.headerBytesStage = 0;
                    if (b != 10) continue;
                }
                String header = LowEntry.bytesToStringLatin1(this.headerBytes.toByteArray()).trim();
                this.contentBytes = this.headerBytes;
                this.contentBytes.reset();
                this.headerBytes = null;
                boolean first = true;
                for (String line : header.split("\r\n")) {
                    if (first) {
                        String[] meta = line.split(" ", 3);
                        if (meta.length != 3) {
                            this.disconnect();
                            return;
                        }
                        this.request.internal_setMethod(meta[0]);
                        this.request.internal_setPath(meta[1]);
                        first = false;
                        continue;
                    }
                    String[] headerparts = line.split(":", 2);
                    this.request.internal_setHeader(headerparts[0], headerparts.length == 2 ? headerparts[1] : "");
                }
                this.contentBytesRemaining = this.request.getContentLength();
                if ((long)this.contentBytesRemaining <= 20480L) break;
                this.disconnect();
                return;
            }
            if (this.headerBytes != null) {
                return;
            }
        }
        if (this.contentBytesRemaining > 0) {
            while (data.hasRemaining()) {
                byte b = data.get();
                this.contentBytes.write(b);
                --this.contentBytesRemaining;
                if (this.contentBytesRemaining > 0) continue;
                byte[] content = this.contentBytes.toByteArray();
                this.contentBytes = null;
                this.request.internal_setContent(content);
                break;
            }
            if (this.contentBytesRemaining > 0) {
                return;
            }
        }
        this.request.internal_setRequest();
        this.server.internal_listenerReceivedRequest(this, this.request, new HttpResponse(this, this.request));
        this.request = null;
    }

    public void send(byte[] bytes) {
        if (bytes == null || bytes.length <= 0) {
            return;
        }
        try {
            this.output.write(bytes, 0, bytes.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.output.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.client.getLocalSocketAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.client.getRemoteSocketAddress();
    }

    public InetAddress getIp() {
        return this.client.getInetAddress();
    }

    public String getIpString() {
        InetAddress ip = this.getIp();
        if (ip == null) {
            return null;
        }
        return ip.getHostAddress();
    }

    public void disconnect() {
        this.internal_disconnect();
        this.server.internal_removeClient(this);
    }

    public boolean isConnected() {
        return this.client.isConnected() && !this.client.isClosed();
    }

    protected void internal_disconnect() {
        try {
            this.output.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.client.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getAddressText() + "]";
    }

    private final String getAddressText() {
        if (!this.isConnected()) {
            return "closed";
        }
        InetSocketAddress sockaddr = this.getRemoteAddress();
        if (sockaddr == null) {
            return "connecting";
        }
        InetAddress inetaddr = sockaddr.getAddress();
        return inetaddr.getHostAddress() + "@" + sockaddr.getPort();
    }
}

