/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.http;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import lowentry.ue4.library.LowEntry;
import lowentry.ue4.libs.jackson.databind.JsonNode;

public class HttpRequest {
    protected final boolean secure;
    protected String method;
    protected String path;
    protected byte[] content;
    protected final HashMap<String, String> headers = new HashMap();
    protected final HashMap<String, String> getVariables = new HashMap();
    protected final HashMap<String, String> postVariables = new HashMap();
    protected final HashMap<String, String> requestVariables = new HashMap();

    public HttpRequest(boolean secure) {
        this.secure = secure;
        this.method = "";
        this.path = "";
        this.content = new byte[0];
    }

    protected void internal_setMethod(String method) {
        this.method = method.trim().toUpperCase(Locale.ENGLISH);
    }

    protected void internal_setPath(String path) {
        String[] parts = path.split("\\?", 2);
        if (parts.length == 2) {
            path = parts[0];
            String getvars = parts[1];
            for (String getvar : getvars.split("&")) {
                String[] getvarparts = getvar.split("=", 2);
                this.internal_setGet(getvarparts[0], getvarparts.length == 2 ? getvarparts[1] : "");
            }
        }
        try {
            this.path = URLDecoder.decode(path, StandardCharsets.UTF_8);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void internal_setContent(byte[] content) {
        this.content = content;
        if (this.isMethod("POST") && this.isContentType("application/x-www-form-urlencoded")) {
            String contentstring = this.getContentAsString();
            if (contentstring == null || contentstring.length() <= 0) {
                return;
            }
            for (String postvar : contentstring.split("&")) {
                String[] postvarparts = postvar.split("=", 2);
                this.internal_setPost(postvarparts[0], postvarparts.length == 2 ? postvarparts[1] : "");
            }
        }
    }

    protected void internal_setHeader(String header, String value) {
        this.headers.put(header.trim().toLowerCase(Locale.ENGLISH), value.trim());
    }

    protected void internal_setGet(String name, String value) {
        try {
            this.getVariables.put(URLDecoder.decode(name, StandardCharsets.UTF_8), URLDecoder.decode(value, StandardCharsets.UTF_8));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void internal_setPost(String name, String value) {
        try {
            this.postVariables.put(URLDecoder.decode(name, StandardCharsets.UTF_8), URLDecoder.decode(value, StandardCharsets.UTF_8));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void internal_setRequest() {
        this.requestVariables.putAll(this.postVariables);
        this.requestVariables.putAll(this.getVariables);
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String getMethod() {
        return this.method;
    }

    public boolean isMethod(String method) {
        if (method == null) {
            return false;
        }
        return method.trim().toUpperCase(Locale.ENGLISH).equals(this.getMethod());
    }

    public String getPath() {
        return this.path;
    }

    public String getContentType() {
        return this.getHeader("content-type");
    }

    public boolean isContentType(String type) {
        if (type == null) {
            return false;
        }
        String contentType = this.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase(Locale.ENGLISH).contains(type.trim().toLowerCase(Locale.ENGLISH));
    }

    public int getContentLength() {
        try {
            String contentLength = this.getHeader("content-length");
            if (contentLength == null) {
                return 0;
            }
            return Integer.parseInt(contentLength);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public byte[] getContentAsBytes() {
        return this.content;
    }

    public String getContentAsString() {
        String charset = "ISO-8859-1";
        String contentType = this.getContentType();
        if (contentType != null) {
            for (String contentTypeInfo : contentType.split(";")) {
                if (!(contentTypeInfo = contentTypeInfo.trim()).toLowerCase(Locale.ENGLISH).startsWith("charset=")) continue;
                charset = contentTypeInfo.substring("charset=".length()).trim();
            }
        }
        try {
            return new String(this.content, charset);
        }
        catch (Exception e) {
            return "";
        }
    }

    public JsonNode getContentAsJson() {
        String contentAsString = this.getContentAsString();
        if (contentAsString == null || contentAsString.length() <= 0) {
            return null;
        }
        return LowEntry.parseJsonString(contentAsString);
    }

    public String getHeader(String header) {
        return this.headers.get(header.trim().toLowerCase(Locale.ENGLISH));
    }

    public String GET(String name) {
        return this.getVariables.get(name);
    }

    public String POST(String name) {
        return this.postVariables.get(name);
    }

    public String REQUEST(String name) {
        return this.requestVariables.get(name);
    }

    public HashMap<String, String> getHeaders() {
        return this.headers;
    }

    public HashMap<String, String> GET() {
        return this.getVariables;
    }

    public HashMap<String, String> POST() {
        return this.postVariables;
    }

    public HashMap<String, String> REQUEST() {
        return this.requestVariables;
    }
}

