/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.internal;

import java.util.Arrays;

public class CompressionByteArrayBuffer {
    protected byte[] buffer;
    protected int length = 0;

    public CompressionByteArrayBuffer() {
        this.buffer = new byte[32];
    }

    public CompressionByteArrayBuffer(int initialSize) {
        this.buffer = new byte[initialSize > 0 ? initialSize : 32];
    }

    public CompressionByteArrayBuffer(int initialSize, int maxInitialSize) {
        initialSize = initialSize <= maxInitialSize ? initialSize : maxInitialSize;
        this.buffer = new byte[initialSize > 0 ? initialSize : 32];
    }

    protected void access(int index) {
        if (index >= this.buffer.length) {
            int newSize = this.buffer.length;
            while (index >= newSize) {
                newSize = newSize >= 0x3FFFFFFF ? Integer.MAX_VALUE : newSize * 2;
            }
            this.buffer = Arrays.copyOf(this.buffer, newSize);
        }
        if (index + 1 > this.length) {
            this.length = index + 1;
        }
    }

    public void set(int index, byte value) {
        this.access(index);
        this.buffer[index] = value;
    }

    public void set(int index, byte[] values, int valuesOffset, int length) {
        this.access(index + (length - 1));
        System.arraycopy(values, valuesOffset, this.buffer, index, length);
    }

    public byte get(int index) {
        if (index >= this.buffer.length) {
            return 0;
        }
        return this.buffer[index];
    }

    public byte[] getData() {
        return Arrays.copyOf(this.buffer, this.length);
    }

    public byte[] getData(int length) {
        return Arrays.copyOf(this.buffer, length);
    }
}

