/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.internal;

import lowentry.ue4.classes.internal.CompressionByteArrayBuffer;

public final class CompressionLzf {
    private static final int SKIP_LENGTH = 15;
    private static final int HASH_SIZE = 65536;
    private static final int MAX_LITERAL = 32;
    private static final int MAX_OFF = 8192;
    private static final int MAX_REF = 264;
    private static final Object COMPRESS_SYNCHRONIZER = new Object();
    private static int[] hashTab;

    private static int uintByteCount(int value) {
        return value <= 127 ? 1 : 4;
    }

    private static void uintToBytes(CompressionByteArrayBuffer array, int arrayOffset, int value) {
        if (value <= 127) {
            array.set(arrayOffset, (byte)value);
        } else {
            array.set(arrayOffset, (byte)(value >> 24 | 0x80));
            array.set(arrayOffset + 1, (byte)(value >> 16));
            array.set(arrayOffset + 2, (byte)(value >> 8));
            array.set(arrayOffset + 3, (byte)value);
        }
    }

    private static int bytesToUint(byte[] array, int arrayOffset) {
        if (array.length - 1 < arrayOffset) {
            return -1;
        }
        byte b = array[arrayOffset];
        if ((b >> 7 & 1) == 0) {
            return b & 0xFF;
        }
        if (array.length - 4 < arrayOffset) {
            return -1;
        }
        int value = (b & 0xFF & 0xFFFFFF7F) << 24 | (array[arrayOffset + 1] & 0xFF) << 16 | (array[arrayOffset + 2] & 0xFF) << 8 | array[arrayOffset + 3] & 0xFF;
        if (value <= 127) {
            return -1;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(byte[] bytes) {
        int inLen = bytes.length;
        if (inLen < 15) {
            byte[] result = new byte[inLen + 1];
            result[0] = 0;
            System.arraycopy(bytes, 0, result, 1, inLen);
            return result;
        }
        CompressionByteArrayBuffer out = new CompressionByteArrayBuffer(inLen + 20, 512);
        out.set(0, (byte)1);
        CompressionLzf.uintToBytes(out, 1, inLen);
        int outPos = 2 + CompressionLzf.uintByteCount(inLen);
        int inPos = 0;
        int literals = 0;
        int future = bytes[0] << 8 | bytes[1] & 0xFF;
        Object object = COMPRESS_SYNCHRONIZER;
        synchronized (object) {
            if (hashTab == null) {
                hashTab = new int[65536];
            }
            while (inPos < inLen - 4) {
                byte p2 = bytes[inPos + 2];
                future = (future << 8) + (p2 & 0xFF);
                int off = future * 2777 >> 9 & 0xFFFF;
                int ref = hashTab[off];
                CompressionLzf.hashTab[off] = inPos;
                if (ref < inPos && ref > 0 && (off = inPos - ref - 1) < 8192 && bytes[ref + 2] == p2 && bytes[ref + 1] == (byte)(future >> 8) && bytes[ref] == (byte)(future >> 16)) {
                    int len;
                    int maxLen = inLen - inPos - 2;
                    if (maxLen > 264) {
                        maxLen = 264;
                    }
                    if (literals == 0) {
                        --outPos;
                    } else {
                        out.set(outPos - literals - 1, (byte)(literals - 1));
                        literals = 0;
                    }
                    for (len = 3; len < maxLen && bytes[ref + len] == bytes[inPos + len]; ++len) {
                    }
                    if ((len -= 2) < 7) {
                        out.set(outPos++, (byte)((off >> 8) + (len << 5)));
                    } else {
                        out.set(outPos++, (byte)((off >> 8) + 224));
                        out.set(outPos++, (byte)(len - 7));
                    }
                    out.set(outPos++, (byte)off);
                    ++outPos;
                    future = bytes[inPos += len] << 8 | bytes[inPos + 1] & 0xFF;
                    future = future << 8 | bytes[inPos + 2] & 0xFF;
                    CompressionLzf.hashTab[future * 2777 >> 9 & 0xFFFF] = inPos++;
                    future = future << 8 | bytes[inPos + 2] & 0xFF;
                    CompressionLzf.hashTab[future * 2777 >> 9 & 0xFFFF] = inPos++;
                    continue;
                }
                out.set(outPos++, bytes[inPos++]);
                if (++literals != 32) continue;
                out.set(outPos - literals - 1, (byte)(literals - 1));
                literals = 0;
                ++outPos;
            }
        }
        while (inPos < inLen) {
            out.set(outPos++, bytes[inPos++]);
            if (++literals != 32) continue;
            out.set(outPos - literals - 1, (byte)(literals - 1));
            literals = 0;
            ++outPos;
        }
        out.set(outPos - literals - 1, (byte)(literals - 1));
        if (literals == 0) {
            --outPos;
        }
        if (outPos >= inLen) {
            byte[] result = new byte[inLen + 1];
            result[0] = 0;
            System.arraycopy(bytes, 0, result, 1, inLen);
            return result;
        }
        return out.getData(outPos);
    }

    public static byte[] decompress(byte[] bytes) {
        int inLen = bytes.length;
        if (inLen < 2) {
            return new byte[0];
        }
        if (bytes[0] == 0) {
            byte[] result = new byte[inLen - 1];
            System.arraycopy(bytes, 1, result, 0, inLen - 1);
            return result;
        }
        if (bytes[0] != 1) {
            return new byte[0];
        }
        int outLen = CompressionLzf.bytesToUint(bytes, 1);
        if (outLen <= 0) {
            return new byte[0];
        }
        int inPos = 1 + CompressionLzf.uintByteCount(outLen);
        CompressionByteArrayBuffer out = new CompressionByteArrayBuffer(outLen, 512);
        int outPos = 0;
        do {
            int ctrl;
            if (inPos >= inLen) {
                return new byte[0];
            }
            if ((ctrl = bytes[inPos++] & 0xFF) < 32) {
                if (inLen - inPos < ++ctrl) {
                    return new byte[0];
                }
                out.set(outPos, bytes, inPos, ctrl);
                outPos += ctrl;
                inPos += ctrl;
                continue;
            }
            int len = ctrl >> 5;
            if (len == 7) {
                if (inPos >= inLen) {
                    return new byte[0];
                }
                len += bytes[inPos++] & 0xFF;
            }
            len += 2;
            ctrl = -((ctrl & 0x1F) << 8) - 1;
            if (inPos >= inLen) {
                return new byte[0];
            }
            ctrl -= bytes[inPos++] & 0xFF;
            ctrl += outPos;
            for (int i = 0; i < len; ++i) {
                if (outPos < 0 || outPos >= outLen) {
                    return new byte[0];
                }
                if (ctrl < 0 || ctrl >= outLen) {
                    return new byte[0];
                }
                out.set(outPos++, out.get(ctrl++));
            }
        } while (outPos < outLen);
        return out.getData();
    }
}

