/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.internal;

import java.util.Arrays;
import java.util.Random;
import lowentry.ue4.classes.AesKey;
import lowentry.ue4.classes.AesKey1D;
import lowentry.ue4.classes.internal.aes.EncryptionAesFastEngine;
import lowentry.ue4.classes.internal.aes.EncryptionAesFastEngine1D;

public class EncryptionAes {
    private static final Random RANDOM = new Random();
    private static final int IV_LENGTH = 4;
    private static final int HASH_LENGTH = 2;
    private static final byte[] pearson = new byte[]{98, 6, 85, -106, 36, 23, 112, -92, -121, -49, -87, 5, 26, 64, -91, -37, 61, 20, 68, 89, -126, 63, 52, 102, 24, -27, -124, -11, 80, -40, -61, 115, 90, -88, -100, -53, -79, 120, 2, -66, -68, 7, 100, -71, -82, -13, -94, 10, -19, 18, -3, -31, 8, -48, -84, -12, -1, 126, 101, 79, -111, -21, -28, 121, 123, -5, 67, -6, -95, 0, 107, 97, -15, 111, -75, 82, -7, 33, 69, 55, 59, -103, 29, 9, -43, -89, 84, 93, 30, 46, 94, 75, -105, 114, 73, -34, -59, 96, -46, 45, 16, -29, -8, -54, 51, -104, -4, 125, 81, -50, -41, -70, 39, -98, -78, -69, -125, -120, 1, 49, 50, 17, -115, 91, 47, -127, 60, 99, -102, 35, 86, -85, 105, 34, 38, -56, -109, 58, 77, 118, -83, -10, 76, -2, -123, -24, -60, -112, -58, 124, 53, 4, 108, 74, -33, -22, -122, -26, -99, -117, -67, -51, -57, -128, -80, 19, -45, -20, 127, -64, -25, 70, -23, 88, -110, 44, -73, -55, 22, 83, 13, -42, 116, 109, -97, 32, 95, -30, -116, -36, 57, 12, -35, 31, -47, -74, -113, 92, -107, -72, -108, 62, 113, 65, 37, 27, 106, -90, 3, 14, -52, 72, 21, 41, 56, 66, 28, -63, 40, -39, 25, 54, -77, 117, -18, 87, -16, -101, -76, -86, -14, -44, -65, -93, 78, -38, -119, -62, -81, 110, 43, 119, -32, 71, 122, -114, 42, -96, 104, 48, -9, 103, 15, 11, -118, -17};

    private static byte[] generateValidationHash(byte[] data) {
        if (data.length <= 0) {
            return new byte[0];
        }
        byte[] hh = new byte[2];
        for (int j = 0; j < hh.length; ++j) {
            byte h = pearson[data[0] + j & 0xFF];
            for (int i = 1; i < data.length; ++i) {
                h = pearson[(h ^ data[i & 0xFF]) & 0xFF];
            }
            hh[j] = h;
        }
        return hh;
    }

    private static byte[] deletePadding(byte[] input, boolean addedValidationHash) {
        byte paddingLength = (byte)(input[input.length - 1] & 0xF);
        int newSize = input.length - paddingLength - 1;
        if (addedValidationHash) {
            newSize -= 2;
        }
        if (newSize <= 0) {
            return new byte[0];
        }
        if (addedValidationHash) {
            byte[] output = new byte[newSize];
            System.arraycopy(input, 2, output, 0, newSize);
            return output;
        }
        return Arrays.copyOf(input, newSize);
    }

    private static byte[] expandIv(byte[] bytes) {
        byte[] expanded = new byte[16];
        if (bytes.length < 4) {
            return expanded;
        }
        int ivi = 0;
        int expi = 0;
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 4; ++col) {
                expanded[expi] = bytes[ivi];
                ++expi;
                if (++ivi != 4) continue;
                ivi = 0;
            }
            if (--ivi != -1) continue;
            ivi += 4;
        }
        return expanded;
    }

    private static byte[] randomBytes(int length) {
        byte[] bytes = new byte[length];
        RANDOM.nextBytes(bytes);
        return bytes;
    }

    private static boolean areBytesEqual(byte[] a, byte[] b) {
        if (a == null || b == null) {
            return false;
        }
        if (a == b) {
            return true;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    private static byte[] fixKey(byte[] key) {
        if (key == null) {
            return null;
        }
        int keyLen = key.length;
        if (keyLen == 0) {
            return new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
        }
        if (keyLen == 16 || keyLen == 24 || keyLen == 32) {
            return key;
        }
        int newSize = keyLen <= 16 ? 16 : (keyLen <= 24 ? 24 : 32);
        byte[] fixedKey = new byte[newSize];
        int keyi = 0;
        for (int i = 0; i < newSize; ++i) {
            fixedKey[i] = key[keyi];
            if (++keyi < keyLen) continue;
            keyi = 0;
        }
        return fixedKey;
    }

    public static byte[] encrypt(byte[] in, AesKey key, boolean addValidationHash) {
        int i;
        if (in == null || key == null || key.rounds <= 0 || key.encryptionW == null) {
            return new byte[0];
        }
        byte[] iv = EncryptionAes.randomBytes(4);
        int hashLength = addValidationHash ? 2 : 0;
        int length = 16 - (in.length + hashLength) % 16;
        byte[] padding = EncryptionAes.randomBytes(length);
        padding[padding.length - 1] = (byte)(length - 1 | padding[padding.length - 1] << 4);
        byte[] tmp = new byte[4 + in.length + hashLength + length];
        byte[] bloc = new byte[16];
        System.arraycopy(iv, 0, tmp, 0, 4);
        if (addValidationHash) {
            byte[] hash = EncryptionAes.generateValidationHash(in);
            System.arraycopy(hash, 0, bloc, 0, 2);
        }
        EncryptionAesFastEngine engine = new EncryptionAesFastEngine(key);
        engine.loadIv(EncryptionAes.expandIv(iv));
        int padi = 0;
        int im16 = hashLength % 16;
        for (i = hashLength; i < in.length + length + hashLength; ++i) {
            if (i > 0 && im16 == 0) {
                engine.processBlockEncryption(bloc, 0, tmp, i - 16 + 4);
            }
            if (i - hashLength < in.length) {
                bloc[im16] = in[i - hashLength];
            } else {
                bloc[im16] = padding[padi];
                ++padi;
            }
            if (++im16 != 16) continue;
            im16 = 0;
        }
        engine.processBlockEncryption(bloc, 0, tmp, i - 16 + 4);
        return tmp;
    }

    public static byte[] decrypt(byte[] in, AesKey key, boolean addedValidationHash) {
        int i;
        if (in == null || key == null || key.rounds <= 0 || key.decryptionW == null) {
            return new byte[0];
        }
        if (in.length - 4 < 16) {
            return new byte[0];
        }
        if ((in.length - 4) % 16 != 0) {
            return new byte[0];
        }
        byte[] tmp = new byte[in.length - 4];
        byte[] bloc = new byte[16];
        EncryptionAesFastEngine engine = new EncryptionAesFastEngine(key);
        engine.loadIv(EncryptionAes.expandIv(in));
        int im16 = 0;
        for (i = 0; i < tmp.length; ++i) {
            if (i > 0 && im16 == 0) {
                engine.processBlockDecryption(bloc, 0, tmp, i - 16);
            }
            bloc[im16] = in[i + 4];
            if (++im16 != 16) continue;
            im16 = 0;
        }
        engine.processBlockDecryption(bloc, 0, tmp, i - 16);
        if (addedValidationHash) {
            byte[] hash = new byte[2];
            System.arraycopy(tmp, 0, hash, 0, 2);
            tmp = EncryptionAes.deletePadding(tmp, true);
            byte[] generatedHash = EncryptionAes.generateValidationHash(tmp);
            if (!EncryptionAes.areBytesEqual(hash, generatedHash)) {
                return new byte[0];
            }
            return tmp;
        }
        return EncryptionAes.deletePadding(tmp, false);
    }

    private static byte[] encrypt1D(byte[] in, AesKey1D key, boolean addValidationHash) {
        int i;
        if (in == null || key == null || key.rounds <= 0 || key.encryptionW == null) {
            return new byte[0];
        }
        byte[] iv = EncryptionAes.randomBytes(4);
        int hashLength = addValidationHash ? 2 : 0;
        int length = 16 - (in.length + hashLength) % 16;
        byte[] padding = EncryptionAes.randomBytes(length);
        padding[padding.length - 1] = (byte)(length - 1 | padding[padding.length - 1] << 4);
        byte[] tmp = new byte[4 + in.length + hashLength + length];
        byte[] bloc = new byte[16];
        System.arraycopy(iv, 0, tmp, 0, 4);
        if (addValidationHash) {
            byte[] hash = EncryptionAes.generateValidationHash(in);
            System.arraycopy(hash, 0, bloc, 0, 2);
        }
        EncryptionAesFastEngine1D engine = new EncryptionAesFastEngine1D(key);
        engine.loadIv(EncryptionAes.expandIv(iv));
        int padi = 0;
        int im16 = hashLength % 16;
        for (i = hashLength; i < in.length + length + hashLength; ++i) {
            if (i > 0 && im16 == 0) {
                engine.processBlockEncryption(bloc, 0, tmp, i - 16 + 4);
            }
            if (i - hashLength < in.length) {
                bloc[im16] = in[i - hashLength];
            } else {
                bloc[im16] = padding[padi];
                ++padi;
            }
            if (++im16 != 16) continue;
            im16 = 0;
        }
        engine.processBlockEncryption(bloc, 0, tmp, i - 16 + 4);
        return tmp;
    }

    private static byte[] decrypt1D(byte[] in, AesKey1D key, boolean addedValidationHash) {
        int i;
        if (in == null || key == null || key.rounds <= 0 || key.decryptionW == null) {
            return new byte[0];
        }
        if (in.length - 4 < 16) {
            return new byte[0];
        }
        if ((in.length - 4) % 16 != 0) {
            return new byte[0];
        }
        byte[] tmp = new byte[in.length - 4];
        byte[] bloc = new byte[16];
        EncryptionAesFastEngine1D engine = new EncryptionAesFastEngine1D(key);
        engine.loadIv(EncryptionAes.expandIv(in));
        int im16 = 0;
        for (i = 0; i < tmp.length; ++i) {
            if (i > 0 && im16 == 0) {
                engine.processBlockDecryption(bloc, 0, tmp, i - 16);
            }
            bloc[im16] = in[i + 4];
            if (++im16 != 16) continue;
            im16 = 0;
        }
        engine.processBlockDecryption(bloc, 0, tmp, i - 16);
        if (addedValidationHash) {
            byte[] hash = new byte[2];
            System.arraycopy(tmp, 0, hash, 0, 2);
            tmp = EncryptionAes.deletePadding(tmp, true);
            byte[] generatedHash = EncryptionAes.generateValidationHash(tmp);
            if (!EncryptionAes.areBytesEqual(hash, generatedHash)) {
                return new byte[0];
            }
            return tmp;
        }
        return EncryptionAes.deletePadding(tmp, false);
    }

    public static AesKey createKey(byte[] key) {
        return EncryptionAesFastEngine.generateAesKey(EncryptionAes.fixKey(key));
    }

    private static AesKey createKeyCustom(byte[] key, boolean forEncryption, boolean forDecryption) {
        return EncryptionAesFastEngine.generateAesKeyCustom(EncryptionAes.fixKey(key), forEncryption, forDecryption);
    }

    private static AesKey1D createKey1DCustom(byte[] key, boolean forEncryption, boolean forDecryption) {
        return EncryptionAesFastEngine1D.generateAesKeyCustom(EncryptionAes.fixKey(key), forEncryption, forDecryption);
    }

    public static byte[] encryptBytes(byte[] data, byte[] key, boolean addValidationHash) {
        if (data == null) {
            return new byte[0];
        }
        if (data.length <= 2400) {
            return EncryptionAes.encrypt1D(data, EncryptionAes.createKey1DCustom(key, true, false), addValidationHash);
        }
        return EncryptionAes.encrypt(data, EncryptionAes.createKeyCustom(key, true, false), addValidationHash);
    }

    public static byte[] decryptBytes(byte[] data, byte[] key, boolean addedValidationHash) {
        if (data == null) {
            return new byte[0];
        }
        if (data.length <= 650) {
            return EncryptionAes.decrypt1D(data, EncryptionAes.createKey1DCustom(key, false, true), addedValidationHash);
        }
        return EncryptionAes.decrypt(data, EncryptionAes.createKeyCustom(key, false, true), addedValidationHash);
    }
}

