/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class FastByteArrayOutputStream {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    public byte[] buf;
    public int count;

    public FastByteArrayOutputStream() {
        this(32);
    }

    public FastByteArrayOutputStream(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative initial size: " + size);
        }
        this.buf = new byte[size];
    }

    public void ensureAdditionalCapacity(int count) {
        this.ensureCapacity(this.count + count);
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity - this.buf.length > 0) {
            this.grow(minCapacity);
        }
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.buf.length;
        int newCapacity = oldCapacity << 1;
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = FastByteArrayOutputStream.hugeCapacity(minCapacity);
        }
        this.buf = Arrays.copyOf(this.buf, newCapacity);
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    public void write(byte b) {
        this.ensureCapacity(this.count + 1);
        this.buf[this.count] = b;
        ++this.count;
    }

    public void write(byte[] b) {
        this.ensureCapacity(this.count + b.length);
        System.arraycopy(b, 0, this.buf, this.count, b.length);
        this.count += b.length;
    }

    public void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len - b.length > 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(this.count + len);
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    public void writeUnsafe(byte b) {
        this.buf[this.count] = b;
        ++this.count;
    }

    public void writeUnsafe(byte[] b) {
        System.arraycopy(b, 0, this.buf, this.count, b.length);
        this.count += b.length;
    }

    public void writeUnsafe(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len - b.length > 0) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    public void reset() {
        this.count = 0;
    }

    public byte[] toByteArray() {
        return Arrays.copyOf(this.buf, this.count);
    }

    public byte[] toByteArray(byte currentByte) {
        byte[] data = Arrays.copyOf(this.buf, this.count + 1);
        data[this.count] = currentByte;
        return data;
    }

    public int size() {
        return this.count;
    }
}

