/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.internal;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import lowentry.ue4.library.LowEntry;

public class FilePath {
    private static String generate(Class<?> c) {
        try {
            String path = new File(c.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).getAbsolutePath();
            if (path.length() <= 0) {
                return "";
            }
            int endIndex = (path = path.replaceAll("\\\\", "/")).lastIndexOf(47);
            if (endIndex >= 0) {
                path = path.substring(0, endIndex);
            }
            return path + "/";
        }
        catch (URISyntaxException e) {
            return "";
        }
    }

    public static String get(Class<?> c) {
        return FilePath.generate(c);
    }

    public static String get(Class<?> c, String file) {
        if (LowEntry.IS_WINDOWS ? file.length() >= 2 && file.charAt(1) == ':' : file.startsWith("/")) {
            return file;
        }
        return FilePath.get(c) + file;
    }

    public static Path getAsPath(Class<?> c) {
        return Paths.get(FilePath.get(c), new String[0]);
    }

    public static Path getAsPath(Class<?> c, String file) {
        return Paths.get(FilePath.get(c, file), new String[0]);
    }

    public static File getAsFile(Class<?> c) {
        return Paths.get(FilePath.get(c), new String[0]).toFile();
    }

    public static File getAsFile(Class<?> c, String file) {
        return Paths.get(FilePath.get(c, file), new String[0]).toFile();
    }

    public static URI getAsUri(Class<?> c) {
        return FilePath.getAsPath(c).toUri();
    }

    public static URI getAsUri(Class<?> c, String file) {
        return FilePath.getAsPath(c, file).toUri();
    }

    public static URL getAsUrl(Class<?> c) throws MalformedURLException {
        return FilePath.getAsUri(c).toURL();
    }

    public static URL getAsUrl(Class<?> c, String file) throws MalformedURLException {
        return FilePath.getAsUri(c, file).toURL();
    }
}

