/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.internal;

public class HashingSha512 {
    private static final long[] k = new long[]{4794697086780616226L, 8158064640168781261L, -5349999486874862801L, -1606136188198331460L, 4131703408338449720L, 6480981068601479193L, -7908458776815382629L, -6116909921290321640L, -2880145864133508542L, 1334009975649890238L, 2608012711638119052L, 6128411473006802146L, 8268148722764581231L, -9160688886553864527L, -7215885187991268811L, -4495734319001033068L, -1973867731355612462L, -1171420211273849373L, 1135362057144423861L, 2597628984639134821L, 3308224258029322869L, 5365058923640841347L, 6679025012923562964L, 8573033837759648693L, -7476448914759557205L, -6327057829258317296L, -5763719355590565569L, -4658551843659510044L, -4116276920077217854L, -3051310485924567259L, 489312712824947311L, 1452737877330783856L, 2861767655752347644L, 3322285676063803686L, 5560940570517711597L, 5996557281743188959L, 7280758554555802590L, 8532644243296465576L, -9096487096722542874L, -7894198246740708037L, -6719396339535248540L, -6333637450476146687L, -4446306890439682159L, -4076793802049405392L, -3345356375505022440L, -2983346525034927856L, -860691631967231958L, 1182934255886127544L, 1847814050463011016L, 2177327727835720531L, 2830643537854262169L, 3796741975233480872L, 4115178125766777443L, 5681478168544905931L, 6601373596472566643L, 7507060721942968483L, 8399075790359081724L, 8693463985226723168L, -8878714635349349518L, -8302665154208450068L, -8016688836872298968L, -6606660893046293015L, -4685533653050689259L, -4147400797238176981L, -3880063495543823972L, -3348786107499101689L, -1523767162380948706L, -757361751448694408L, 500013540394364858L, 748580250866718886L, 1242879168328830382L, 1977374033974150939L, 2944078676154940804L, 3659926193048069267L, 4368137639120453308L, 4836135668995329356L, 5532061633213252278L, 6448918945643986474L, 6902733635092675308L, 7801388544844847127L};
    private static final int BLOCK_SIZE = 128;
    private long[] w = null;
    private long h0 = 7640891576956012808L;
    private long h1 = -4942790177534073029L;
    private long h2 = 4354685564936845355L;
    private long h3 = -6534734903238641935L;
    private long h4 = 5840696475078001361L;
    private long h5 = -7276294671716946913L;
    private long h6 = 2270897969802886507L;
    private long h7 = 6620516959819538809L;
    private int count = 0;
    private byte[] buffer = null;

    private void initialize() {
        this.w = new long[80];
        this.buffer = new byte[128];
    }

    private void update(byte[] b, int offset, int len) {
        int n = this.count % 128;
        this.count += len;
        int partLen = 128 - n;
        int i = 0;
        if (len >= partLen) {
            System.arraycopy(b, offset, this.buffer, n, partLen);
            this.sha(this.buffer, 0);
            i = partLen;
            while (i + 128 - 1 < len) {
                this.sha(b, offset + i);
                i += 128;
            }
            n = 0;
        }
        if (i < len) {
            System.arraycopy(b, offset + i, this.buffer, n, len - i);
        }
    }

    private byte[] digest() {
        byte[] tail = this.padBuffer();
        this.update(tail, 0, tail.length);
        return this.getResult();
    }

    private byte[] padBuffer() {
        int n = this.count % 128;
        int padding = n < 112 ? 112 - n : 240 - n;
        byte[] result = new byte[padding + 16];
        result[0] = -128;
        long bits = this.count << 3;
        result[padding += 8] = (byte)(bits >> 56);
        result[padding + 1] = (byte)(bits >> 48);
        result[padding + 2] = (byte)(bits >> 40);
        result[padding + 3] = (byte)(bits >> 32);
        result[padding + 4] = (byte)(bits >> 24);
        result[padding + 5] = (byte)(bits >> 16);
        result[padding + 6] = (byte)(bits >> 8);
        result[padding + 7] = (byte)bits;
        return result;
    }

    private byte[] getResult() {
        return new byte[]{(byte)(this.h0 >> 56), (byte)(this.h0 >> 48), (byte)(this.h0 >> 40), (byte)(this.h0 >> 32), (byte)(this.h0 >> 24), (byte)(this.h0 >> 16), (byte)(this.h0 >> 8), (byte)this.h0, (byte)(this.h1 >> 56), (byte)(this.h1 >> 48), (byte)(this.h1 >> 40), (byte)(this.h1 >> 32), (byte)(this.h1 >> 24), (byte)(this.h1 >> 16), (byte)(this.h1 >> 8), (byte)this.h1, (byte)(this.h2 >> 56), (byte)(this.h2 >> 48), (byte)(this.h2 >> 40), (byte)(this.h2 >> 32), (byte)(this.h2 >> 24), (byte)(this.h2 >> 16), (byte)(this.h2 >> 8), (byte)this.h2, (byte)(this.h3 >> 56), (byte)(this.h3 >> 48), (byte)(this.h3 >> 40), (byte)(this.h3 >> 32), (byte)(this.h3 >> 24), (byte)(this.h3 >> 16), (byte)(this.h3 >> 8), (byte)this.h3, (byte)(this.h4 >> 56), (byte)(this.h4 >> 48), (byte)(this.h4 >> 40), (byte)(this.h4 >> 32), (byte)(this.h4 >> 24), (byte)(this.h4 >> 16), (byte)(this.h4 >> 8), (byte)this.h4, (byte)(this.h5 >> 56), (byte)(this.h5 >> 48), (byte)(this.h5 >> 40), (byte)(this.h5 >> 32), (byte)(this.h5 >> 24), (byte)(this.h5 >> 16), (byte)(this.h5 >> 8), (byte)this.h5, (byte)(this.h6 >> 56), (byte)(this.h6 >> 48), (byte)(this.h6 >> 40), (byte)(this.h6 >> 32), (byte)(this.h6 >> 24), (byte)(this.h6 >> 16), (byte)(this.h6 >> 8), (byte)this.h6, (byte)(this.h7 >> 56), (byte)(this.h7 >> 48), (byte)(this.h7 >> 40), (byte)(this.h7 >> 32), (byte)(this.h7 >> 24), (byte)(this.h7 >> 16), (byte)(this.h7 >> 8), (byte)this.h7};
    }

    private void sha(byte[] in, int offset) {
        long T2;
        long T;
        int r;
        long A = this.h0;
        long B = this.h1;
        long C = this.h2;
        long D = this.h3;
        long E = this.h4;
        long F = this.h5;
        long G = this.h6;
        long H = this.h7;
        for (r = 0; r < 16; ++r) {
            this.w[r] = (long)in[offset] << 56 | ((long)in[offset + 1] & 0xFFL) << 48 | ((long)in[offset + 2] & 0xFFL) << 40 | ((long)in[offset + 3] & 0xFFL) << 32 | ((long)in[offset + 4] & 0xFFL) << 24 | ((long)in[offset + 5] & 0xFFL) << 16 | ((long)in[offset + 6] & 0xFFL) << 8 | (long)in[offset + 7] & 0xFFL;
            offset += 8;
        }
        for (r = 16; r < 80; ++r) {
            T = this.w[r - 2];
            T2 = this.w[r - 15];
            this.w[r] = ((HashingSha512.s(T, 19) | T << 45) ^ (HashingSha512.s(T, 61) | T << 3) ^ HashingSha512.s(T, 6)) + this.w[r - 7] + ((HashingSha512.s(T2, 1) | T2 << 63) ^ (HashingSha512.s(T2, 8) | T2 << 56) ^ HashingSha512.s(T2, 7)) + this.w[r - 16];
        }
        for (r = 0; r < 80; ++r) {
            T = H + ((HashingSha512.s(E, 14) | E << 50) ^ (HashingSha512.s(E, 18) | E << 46) ^ (HashingSha512.s(E, 41) | E << 23)) + (E & F ^ (E ^ 0xFFFFFFFFFFFFFFFFL) & G) + k[r] + this.w[r];
            T2 = ((HashingSha512.s(A, 28) | A << 36) ^ (HashingSha512.s(A, 34) | A << 30) ^ (HashingSha512.s(A, 39) | A << 25)) + (A & B ^ A & C ^ B & C);
            H = G;
            G = F;
            F = E;
            E = D + T;
            D = C;
            C = B;
            B = A;
            A = T + T2;
        }
        this.h0 += A;
        this.h1 += B;
        this.h2 += C;
        this.h3 += D;
        this.h4 += E;
        this.h5 += F;
        this.h6 += G;
        this.h7 += H;
    }

    private static long s(long a, int b) {
        return a >>> b;
    }

    public static byte[] hash(byte[] bytes) {
        HashingSha512 instance = new HashingSha512();
        instance.initialize();
        if (bytes != null) {
            instance.update(bytes, 0, bytes.length);
        }
        return instance.digest();
    }

    public static byte[] hash(byte[] bytes, int index, int length) {
        if (bytes == null || bytes.length <= 0) {
            HashingSha512 instance = new HashingSha512();
            instance.initialize();
            return instance.digest();
        }
        if (index < 0) {
            length += index;
            index = 0;
        }
        if (length > bytes.length - index) {
            length = bytes.length - index;
        }
        if (length <= 0) {
            HashingSha512 instance = new HashingSha512();
            instance.initialize();
            return instance.digest();
        }
        HashingSha512 instance = new HashingSha512();
        instance.initialize();
        instance.update(bytes, index, length);
        return instance.digest();
    }
}

