/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.internal.rsa;

import java.security.SecureRandom;
import java.util.Arrays;
import lowentry.ue4.classes.internal.rsa.RsaBitSieve;
import lowentry.ue4.classes.internal.rsa.RsaMutableBigInteger;

public class RsaBigInteger {
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    public final int signum;
    public final int[] mag;
    private int bitLength = 0;
    private int lowestSetBit = 0;
    private int firstNonzeroIntNum = 0;
    private static final long LONG_MASK = 0xFFFFFFFFL;
    private static final int MAX_MAG_LENGTH = 0x4000000;
    private static final int PRIME_SEARCH_BIT_LENGTH_LIMIT = 500000000;
    private static final int KARATSUBA_THRESHOLD = 80;
    private static final int TOOM_COOK_THRESHOLD = 240;
    private static final int KARATSUBA_SQUARE_THRESHOLD = 128;
    private static final int TOOM_COOK_SQUARE_THRESHOLD = 216;
    public static final int BURNIKEL_ZIEGLER_THRESHOLD = 80;
    public static final int BURNIKEL_ZIEGLER_OFFSET = 40;
    private static final int MULTIPLY_SQUARE_THRESHOLD = 20;
    private static final int DEFAULT_PRIME_CERTAINTY = 100;
    private static final RsaBigInteger[] cache_positive = new RsaBigInteger[256];
    private static final RsaBigInteger[] cache_negative = new RsaBigInteger[32];
    public static final RsaBigInteger ZERO = new RsaBigInteger(new int[0], 0);
    public static final RsaBigInteger NEGATIVE_ONE = RsaBigInteger.valueOf(-1L);
    public static final RsaBigInteger ONE = RsaBigInteger.valueOf(1L);
    public static final RsaBigInteger TWO = RsaBigInteger.valueOf(2L);
    public static final RsaBigInteger TEN = RsaBigInteger.valueOf(10L);
    private static final int[] bnExpModThreshTable = new int[]{7, 25, 81, 241, 673, 1793, Integer.MAX_VALUE};

    private RsaBigInteger(int[] val) {
        if (val == null || val.length == 0) {
            this.mag = new int[0];
            this.signum = 0;
            return;
        }
        if (val[0] < 0) {
            int[] newmag = RsaBigInteger.makePositive(val);
            if (!RsaBigInteger.checkRange(newmag)) {
                this.signum = 0;
                this.mag = new int[0];
                return;
            }
            this.mag = newmag;
            this.signum = -1;
        } else {
            int[] newmag = RsaBigInteger.trustedStripLeadingZeroInts(val);
            if (!RsaBigInteger.checkRange(newmag)) {
                this.signum = 0;
                this.mag = new int[0];
                return;
            }
            this.mag = newmag;
            this.signum = this.mag.length == 0 ? 0 : 1;
        }
    }

    public RsaBigInteger(int signum, byte[] magnitude) {
        if (signum < -1 || signum > 1) {
            this.mag = new int[0];
            this.signum = 0;
            return;
        }
        int[] mag = RsaBigInteger.stripLeadingZeroBytes(magnitude);
        if (!RsaBigInteger.checkRange(mag)) {
            this.mag = new int[0];
            this.signum = 0;
            return;
        }
        if (mag.length == 0) {
            this.mag = mag;
            this.signum = 0;
        } else {
            if (signum == 0) {
                this.mag = new int[0];
                this.signum = 0;
                return;
            }
            this.mag = mag;
            this.signum = signum;
        }
    }

    private RsaBigInteger(int signum, int[] magnitude) {
        if (signum < -1 || signum > 1) {
            this.mag = new int[0];
            this.signum = 0;
            return;
        }
        int[] mag = RsaBigInteger.stripLeadingZeroInts(magnitude);
        if (!RsaBigInteger.checkRange(mag)) {
            this.mag = new int[0];
            this.signum = 0;
            return;
        }
        if (mag.length == 0) {
            this.mag = mag;
            this.signum = 0;
        } else {
            if (signum == 0) {
                this.mag = new int[0];
                this.signum = 0;
                return;
            }
            this.mag = mag;
            this.signum = signum;
        }
    }

    public RsaBigInteger(int[] magnitude, int signum) {
        if (!RsaBigInteger.checkRange(magnitude)) {
            this.signum = 0;
            this.mag = new int[0];
            return;
        }
        this.signum = magnitude.length == 0 ? 0 : signum;
        this.mag = magnitude;
    }

    private RsaBigInteger(int numBits) {
        this(1, RsaBigInteger.randomBits(numBits));
    }

    private RsaBigInteger(long val) {
        if (val < 0L) {
            val = -val;
            this.signum = -1;
        } else {
            this.signum = 1;
        }
        int highWord = (int)RsaBigInteger.sl(val, 32);
        if (highWord == 0) {
            this.mag = new int[1];
            this.mag[0] = (int)val;
        } else {
            this.mag = new int[2];
            this.mag[0] = highWord;
            this.mag[1] = (int)val;
        }
    }

    private static int si(int a, int b) {
        return a >>> b;
    }

    private static long sl(long a, int b) {
        return a >>> b;
    }

    private static void randomBytes(byte[] bytes) {
        SECURE_RANDOM.nextBytes(bytes);
    }

    private static byte[] randomBits(int numBits) {
        if (numBits < 0) {
            numBits = 0;
        }
        int numBytes = (int)(((long)numBits + 7L) / 8L);
        byte[] randomBits = new byte[numBytes];
        if (numBytes > 0) {
            RsaBigInteger.randomBytes(randomBits);
            int excessBits = 8 * numBytes - numBits;
            randomBits[0] = (byte)(randomBits[0] & (1 << 8 - excessBits) - 1);
        }
        return randomBits;
    }

    public static RsaBigInteger probablePrime(int bitLength) {
        if (bitLength < 2) {
            return null;
        }
        return RsaBigInteger.largePrime(bitLength, 100);
    }

    private static RsaBigInteger largePrime(int bitLength, int certainty) {
        RsaBigInteger p = new RsaBigInteger(bitLength).setBit(bitLength - 1);
        if (p == null || p.mag.length <= 0) {
            return null;
        }
        int n = p.mag.length - 1;
        p.mag[n] = p.mag[n] & 0xFFFFFFFE;
        if (bitLength > 500000001) {
            return null;
        }
        int searchLen = bitLength / 20 * 64;
        RsaBitSieve searchSieve = new RsaBitSieve(p, searchLen);
        RsaBigInteger candidate = searchSieve.retrieve(p, certainty);
        while (candidate == null || candidate.bitLength() != bitLength) {
            if ((p = p.add(RsaBigInteger.valueOf(2 * searchLen))) == null) {
                return null;
            }
            if (p.bitLength() != bitLength) {
                p = new RsaBigInteger(bitLength).setBit(bitLength - 1);
            }
            if (p == null || p.mag.length <= 0) {
                return null;
            }
            int n2 = p.mag.length - 1;
            p.mag[n2] = p.mag[n2] & 0xFFFFFFFE;
            searchSieve = new RsaBitSieve(p, searchLen);
            candidate = searchSieve.retrieve(p, certainty);
        }
        return candidate;
    }

    public boolean primeToCertainty(int certainty) {
        int n = (Math.min(certainty, 0x7FFFFFFE) + 1) / 2;
        int sizeInBits = this.bitLength();
        if (sizeInBits < 100) {
            int rounds = 50;
            rounds = n < rounds ? n : rounds;
            return this.passesMillerRabin(rounds);
        }
        int rounds = sizeInBits < 256 ? 27 : (sizeInBits < 512 ? 15 : (sizeInBits < 768 ? 8 : (sizeInBits < 1024 ? 4 : 2)));
        rounds = n < rounds ? n : rounds;
        return this.passesMillerRabin(rounds) && this.passesLucasLehmer();
    }

    private boolean passesLucasLehmer() {
        RsaBigInteger thisPlusOne = this.add(ONE);
        if (thisPlusOne == null) {
            return true;
        }
        int d = 5;
        while (RsaBigInteger.jacobiSymbol(d, this) != -1) {
            d = d < 0 ? Math.abs(d) + 2 : -(d + 2);
        }
        RsaBigInteger u = RsaBigInteger.lucasLehmerSequence(d, thisPlusOne, this);
        if (u == null) {
            return true;
        }
        RsaBigInteger umod = u.mod(this);
        if (umod == null) {
            return true;
        }
        return umod.equals(ZERO);
    }

    private static int jacobiSymbol(int p, RsaBigInteger n) {
        RsaBigInteger uobj;
        if (n == null || n.mag.length <= 0) {
            return -1;
        }
        if (p == 0) {
            return 0;
        }
        int j = 1;
        int u = n.mag[n.mag.length - 1];
        if (p < 0) {
            p = -p;
            int n8 = u & 7;
            if (n8 == 3 || n8 == 7) {
                j = -j;
            }
        }
        while ((p & 3) == 0) {
            p >>= 2;
        }
        if ((p & 1) == 0) {
            p >>= 1;
            if (((u ^ u >> 1) & 2) != 0) {
                j = -j;
            }
        }
        if (p == 1) {
            return j;
        }
        if ((p & u & 2) != 0) {
            j = -j;
        }
        if ((uobj = n.mod(RsaBigInteger.valueOf(p))) == null) {
            return -1;
        }
        for (u = uobj.intValue(); u != 0; u %= p) {
            while ((u & 3) == 0) {
                u >>= 2;
            }
            if ((u & 1) == 0) {
                u >>= 1;
                if (((p ^ p >> 1) & 2) != 0) {
                    j = -j;
                }
            }
            if (u == 1) {
                return j;
            }
            if (u < p) {
                return -1;
            }
            u = p;
            int t = u;
            if ((u & (p = t) & 2) == 0) continue;
            j = -j;
        }
        return 0;
    }

    private static RsaBigInteger lucasLehmerSequence(int z, RsaBigInteger k, RsaBigInteger n) {
        if (k == null || n == null) {
            return null;
        }
        RsaBigInteger d = RsaBigInteger.valueOf(z);
        RsaBigInteger u = ONE;
        RsaBigInteger v = ONE;
        for (int i = k.bitLength() - 2; i >= 0; --i) {
            RsaBigInteger u2 = u.multiply(v);
            if (u2 == null) {
                return null;
            }
            if ((u2 = u2.mod(n)) == null) {
                return null;
            }
            RsaBigInteger v2 = v.square();
            if (v2 == null) {
                return null;
            }
            RsaBigInteger usqr = u.square();
            if (usqr == null) {
                return null;
            }
            RsaBigInteger dmultUsql = d.multiply(usqr);
            if (dmultUsql == null) {
                return null;
            }
            if ((v2 = v2.add(dmultUsql)) == null) {
                return null;
            }
            if ((v2 = v2.mod(n)) == null) {
                return null;
            }
            if (v2.testBit(0) && (v2 = v2.subtract(n)) == null) {
                return null;
            }
            if ((v2 = v2.shiftRight(1)) == null) {
                return null;
            }
            u = u2;
            v = v2;
            if (!k.testBit(i)) continue;
            u2 = u.add(v);
            if (u2 == null) {
                return null;
            }
            if ((u2 = u2.mod(n)) == null) {
                return null;
            }
            if (u2.testBit(0) && (u2 = u2.subtract(n)) == null) {
                return null;
            }
            if ((u2 = u2.shiftRight(1)) == null) {
                return null;
            }
            RsaBigInteger dmultU = d.multiply(u);
            if (dmultU == null) {
                return null;
            }
            v2 = v.add(dmultU);
            if (v2 == null) {
                return null;
            }
            if ((v2 = v2.mod(n)) == null) {
                return null;
            }
            if (v2.testBit(0) && (v2 = v2.subtract(n)) == null) {
                return null;
            }
            if ((v2 = v2.shiftRight(1)) == null) {
                return null;
            }
            u = u2;
            v = v2;
        }
        return u;
    }

    private boolean passesMillerRabin(int iterations) {
        RsaBigInteger thisMinusOne = this.subtract(ONE);
        if (thisMinusOne == null) {
            return true;
        }
        RsaBigInteger m = thisMinusOne;
        int a = m.getLowestSetBit();
        if ((m = m.shiftRight(a)) == null) {
            return true;
        }
        for (int i = 0; i < iterations; ++i) {
            RsaBigInteger b = new RsaBigInteger(this.bitLength());
            while (b.compareTo(ONE) <= 0 || b.compareTo(this) >= 0) {
                b = new RsaBigInteger(this.bitLength());
            }
            RsaBigInteger z = b.modPow(m, this);
            if (z == null) {
                return true;
            }
            for (int j = 0; !(j == 0 && z.equals(ONE) || z.equals(thisMinusOne)); ++j) {
                if ((j <= 0 || !z.equals(ONE)) && j + 1 != a) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean checkRange(int[] mag) {
        return mag != null && mag.length <= 0x4000000 && (mag.length != 0x4000000 || mag[0] >= 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RsaBigInteger valueOf(long val) {
        if (val == 0L) {
            return ZERO;
        }
        if (val > 0L && val <= (long)cache_positive.length) {
            RsaBigInteger[] rsaBigIntegerArray = cache_positive;
            synchronized (cache_positive) {
                RsaBigInteger bigint = cache_positive[(int)val - 1];
                if (bigint == null) {
                    RsaBigInteger.cache_positive[(int)val - 1] = bigint = new RsaBigInteger(val);
                }
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return bigint;
            }
        }
        if (val < 0L && -val <= (long)cache_negative.length) {
            RsaBigInteger[] rsaBigIntegerArray = cache_negative;
            synchronized (cache_negative) {
                RsaBigInteger bigint = cache_negative[(int)(-val) - 1];
                if (bigint == null) {
                    RsaBigInteger.cache_negative[(int)(-val) - 1] = bigint = new RsaBigInteger(val);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return bigint;
            }
        }
        return new RsaBigInteger(val);
    }

    private static RsaBigInteger valueOf(int[] val) {
        if (val == null || val.length <= 0) {
            return ZERO;
        }
        return val[0] > 0 ? new RsaBigInteger(val, 1) : new RsaBigInteger(val);
    }

    public RsaBigInteger add(RsaBigInteger val) {
        if (val == null) {
            return null;
        }
        if (val.signum == 0) {
            return this;
        }
        if (this.signum == 0) {
            return val;
        }
        if (val.signum == this.signum) {
            return new RsaBigInteger(RsaBigInteger.add(this.mag, val.mag), this.signum);
        }
        int cmp = this.compareMagnitude(val);
        if (cmp == 0) {
            return ZERO;
        }
        int[] resultMag = cmp > 0 ? RsaBigInteger.subtract(this.mag, val.mag) : RsaBigInteger.subtract(val.mag, this.mag);
        resultMag = RsaBigInteger.trustedStripLeadingZeroInts(resultMag);
        return new RsaBigInteger(resultMag, cmp == this.signum ? 1 : -1);
    }

    private static int[] add(int[] x, int[] y) {
        boolean carry;
        if (x == null || y == null) {
            return new int[0];
        }
        if (x.length < y.length) {
            int[] tmp = x;
            x = y;
            y = tmp;
        }
        int xIndex = x.length;
        int yIndex = y.length;
        int[] result = new int[xIndex];
        long sum = 0L;
        if (yIndex == 1) {
            sum = ((long)x[--xIndex] & 0xFFFFFFFFL) + ((long)y[0] & 0xFFFFFFFFL);
            result[xIndex] = (int)sum;
        } else {
            while (yIndex > 0) {
                sum = ((long)x[--xIndex] & 0xFFFFFFFFL) + ((long)y[--yIndex] & 0xFFFFFFFFL) + RsaBigInteger.sl(sum, 32);
                result[xIndex] = (int)sum;
            }
        }
        boolean bl = carry = RsaBigInteger.sl(sum, 32) != 0L;
        while (xIndex > 0 && carry) {
            result[--xIndex] = x[xIndex] + 1;
            carry = result[--xIndex] == 0;
        }
        while (xIndex > 0) {
            result[--xIndex] = x[xIndex];
        }
        if (carry) {
            int[] bigger = new int[result.length + 1];
            System.arraycopy(result, 0, bigger, 1, result.length);
            bigger[0] = 1;
            return bigger;
        }
        return result;
    }

    public RsaBigInteger subtract(RsaBigInteger val) {
        if (val == null) {
            return null;
        }
        if (val.signum == 0) {
            return this;
        }
        if (this.signum == 0) {
            return val.negate();
        }
        if (val.signum != this.signum) {
            return new RsaBigInteger(RsaBigInteger.add(this.mag, val.mag), this.signum);
        }
        int cmp = this.compareMagnitude(val);
        if (cmp == 0) {
            return ZERO;
        }
        int[] resultMag = cmp > 0 ? RsaBigInteger.subtract(this.mag, val.mag) : RsaBigInteger.subtract(val.mag, this.mag);
        resultMag = RsaBigInteger.trustedStripLeadingZeroInts(resultMag);
        return new RsaBigInteger(resultMag, cmp == this.signum ? 1 : -1);
    }

    private static int[] subtract(int[] big, int[] little) {
        boolean borrow;
        if (big == null || little == null) {
            return new int[0];
        }
        int bigIndex = big.length;
        int[] result = new int[bigIndex];
        int littleIndex = little.length;
        long difference = 0L;
        while (littleIndex > 0) {
            difference = ((long)big[--bigIndex] & 0xFFFFFFFFL) - ((long)little[--littleIndex] & 0xFFFFFFFFL) + (difference >> 32);
            result[bigIndex] = (int)difference;
        }
        boolean bl = borrow = difference >> 32 != 0L;
        while (bigIndex > 0 && borrow) {
            result[--bigIndex] = big[bigIndex] - 1;
            borrow = result[--bigIndex] == -1;
        }
        while (bigIndex > 0) {
            result[--bigIndex] = big[bigIndex];
        }
        return result;
    }

    public RsaBigInteger multiply(RsaBigInteger val) {
        if (val == null) {
            return null;
        }
        if (val.signum == 0 || this.signum == 0) {
            return ZERO;
        }
        int xlen = this.mag.length;
        if (val == this && xlen > 20) {
            return this.square();
        }
        int ylen = val.mag.length;
        if (xlen < 80 || ylen < 80) {
            int resultSign;
            int n = resultSign = this.signum == val.signum ? 1 : -1;
            if (val.mag.length == 1) {
                return RsaBigInteger.multiplyByInt(this.mag, val.mag[0], resultSign);
            }
            if (this.mag.length == 1) {
                return RsaBigInteger.multiplyByInt(val.mag, this.mag[0], resultSign);
            }
            int[] result = this.multiplyToLen(this.mag, xlen, val.mag, ylen, null);
            result = RsaBigInteger.trustedStripLeadingZeroInts(result);
            return new RsaBigInteger(result, resultSign);
        }
        if (xlen < 240 && ylen < 240) {
            return RsaBigInteger.multiplyKaratsuba(this, val);
        }
        return RsaBigInteger.multiplyToomCook3(this, val);
    }

    private static int integerBitCount(int i) {
        i -= RsaBigInteger.si(i, 1) & 0x55555555;
        i = (i & 0x33333333) + (RsaBigInteger.si(i, 2) & 0x33333333);
        i = i + RsaBigInteger.si(i, 4) & 0xF0F0F0F;
        i += RsaBigInteger.si(i, 8);
        i += RsaBigInteger.si(i, 16);
        return i & 0x3F;
    }

    private static int integerNumberOfTrailingZeros(int i) {
        if (i == 0) {
            return 32;
        }
        int n = 31;
        int y = i << 16;
        if (y != 0) {
            n -= 16;
            i = y;
        }
        if ((y = i << 8) != 0) {
            n -= 8;
            i = y;
        }
        if ((y = i << 4) != 0) {
            n -= 4;
            i = y;
        }
        if ((y = i << 2) != 0) {
            n -= 2;
            i = y;
        }
        return n - RsaBigInteger.si(i << 1, 31);
    }

    private static int integerNumberOfLeadingZeros(int i) {
        if (i == 0) {
            return 32;
        }
        int n = 1;
        if (RsaBigInteger.si(i, 16) == 0) {
            n += 16;
            i <<= 16;
        }
        if (RsaBigInteger.si(i, 24) == 0) {
            n += 8;
            i <<= 8;
        }
        if (RsaBigInteger.si(i, 28) == 0) {
            n += 4;
            i <<= 4;
        }
        if (RsaBigInteger.si(i, 30) == 0) {
            n += 2;
            i <<= 2;
        }
        return n -= RsaBigInteger.si(i, 31);
    }

    private static RsaBigInteger multiplyByInt(int[] x, int y, int sign) {
        if (x == null) {
            return null;
        }
        if (RsaBigInteger.integerBitCount(y) == 1) {
            return new RsaBigInteger(RsaBigInteger.shiftLeft(x, RsaBigInteger.integerNumberOfTrailingZeros(y)), sign);
        }
        int xlen = x.length;
        int[] rmag = new int[xlen + 1];
        long carry = 0L;
        long yl = (long)y & 0xFFFFFFFFL;
        int rstart = rmag.length - 1;
        for (int i = xlen - 1; i >= 0; --i) {
            long product = ((long)x[i] & 0xFFFFFFFFL) * yl + carry;
            rmag[rstart] = (int)product;
            --rstart;
            carry = RsaBigInteger.sl(product, 32);
        }
        if (carry == 0L) {
            rmag = Arrays.copyOfRange(rmag, 1, rmag.length);
        } else {
            rmag[rstart] = (int)carry;
        }
        return new RsaBigInteger(rmag, sign);
    }

    private int[] multiplyToLen(int[] x, int xlen, int[] y, int ylen, int[] z) {
        if (x == null || y == null) {
            return new int[0];
        }
        int xstart = xlen - 1;
        int ystart = ylen - 1;
        if (z == null || z.length < xlen + ylen) {
            z = new int[xlen + ylen];
        }
        long carry = 0L;
        int j = ystart;
        int k = ystart + 1 + xstart;
        while (j >= 0) {
            long product = ((long)y[j] & 0xFFFFFFFFL) * ((long)x[xstart] & 0xFFFFFFFFL) + carry;
            z[k] = (int)product;
            carry = RsaBigInteger.sl(product, 32);
            --j;
            --k;
        }
        z[xstart] = (int)carry;
        for (int i = xstart - 1; i >= 0; --i) {
            carry = 0L;
            int j2 = ystart;
            int k2 = ystart + 1 + i;
            while (j2 >= 0) {
                long product = ((long)y[j2] & 0xFFFFFFFFL) * ((long)x[i] & 0xFFFFFFFFL) + ((long)z[k2] & 0xFFFFFFFFL) + carry;
                z[k2] = (int)product;
                carry = RsaBigInteger.sl(product, 32);
                --j2;
                --k2;
            }
            z[i] = (int)carry;
        }
        return z;
    }

    private static RsaBigInteger multiplyKaratsuba(RsaBigInteger x, RsaBigInteger y) {
        if (x == null || y == null) {
            return null;
        }
        int xlen = x.mag.length;
        int ylen = y.mag.length;
        int half = (Math.max(xlen, ylen) + 1) / 2;
        RsaBigInteger xl = x.getLower(half);
        if (xl == null) {
            return null;
        }
        RsaBigInteger xh = x.getUpper(half);
        if (xh == null) {
            return null;
        }
        RsaBigInteger yl = y.getLower(half);
        if (yl == null) {
            return null;
        }
        RsaBigInteger yh = y.getUpper(half);
        if (yh == null) {
            return null;
        }
        RsaBigInteger p1 = xh.multiply(yh);
        if (p1 == null) {
            return null;
        }
        RsaBigInteger p2 = xl.multiply(yl);
        if (p2 == null) {
            return null;
        }
        RsaBigInteger p3 = xh.add(xl);
        if (p3 == null) {
            return null;
        }
        RsaBigInteger yhAddY1 = yh.add(yl);
        if (yhAddY1 == null) {
            return null;
        }
        if ((p3 = p3.multiply(yhAddY1)) == null) {
            return null;
        }
        RsaBigInteger p3sub = p3.subtract(p1);
        if (p3sub == null) {
            return null;
        }
        if ((p3sub = p3sub.subtract(p2)) == null) {
            return null;
        }
        RsaBigInteger result = p1.shiftLeft(32 * half);
        if (result == null) {
            return null;
        }
        if ((result = result.add(p3sub)) == null) {
            return null;
        }
        if ((result = result.shiftLeft(32 * half)) == null) {
            return null;
        }
        if ((result = result.add(p2)) == null) {
            return null;
        }
        if (x.signum != y.signum) {
            return result.negate();
        }
        return result;
    }

    private static RsaBigInteger multiplyToomCook3(RsaBigInteger a, RsaBigInteger b) {
        int r;
        if (a == null || b == null) {
            return null;
        }
        int alen = a.mag.length;
        int blen = b.mag.length;
        int largest = Math.max(alen, blen);
        int k = (largest + 2) / 3;
        RsaBigInteger a2 = a.getToomSlice(k, r = largest - 2 * k, 0, largest);
        if (a2 == null) {
            return null;
        }
        RsaBigInteger a1 = a.getToomSlice(k, r, 1, largest);
        if (a1 == null) {
            return null;
        }
        RsaBigInteger a0 = a.getToomSlice(k, r, 2, largest);
        if (a0 == null) {
            return null;
        }
        RsaBigInteger b2 = b.getToomSlice(k, r, 0, largest);
        if (b2 == null) {
            return null;
        }
        RsaBigInteger b1 = b.getToomSlice(k, r, 1, largest);
        if (b1 == null) {
            return null;
        }
        RsaBigInteger b0 = b.getToomSlice(k, r, 2, largest);
        if (b0 == null) {
            return null;
        }
        RsaBigInteger v0 = a0.multiply(b0);
        if (v0 == null) {
            return null;
        }
        RsaBigInteger da1 = a2.add(a0);
        if (da1 == null) {
            return null;
        }
        RsaBigInteger db1 = b2.add(b0);
        if (db1 == null) {
            return null;
        }
        RsaBigInteger db1SubB1 = db1.subtract(b1);
        if (db1SubB1 == null) {
            return null;
        }
        RsaBigInteger vm1 = da1.subtract(a1);
        if (vm1 == null) {
            return null;
        }
        if ((vm1 = vm1.multiply(db1SubB1)) == null) {
            return null;
        }
        if ((da1 = da1.add(a1)) == null) {
            return null;
        }
        if ((db1 = db1.add(b1)) == null) {
            return null;
        }
        RsaBigInteger v1 = da1.multiply(db1);
        if (v1 == null) {
            return null;
        }
        RsaBigInteger v2inner = db1.add(b2);
        if (v2inner == null) {
            return null;
        }
        if ((v2inner = v2inner.shiftLeft(1)) == null) {
            return null;
        }
        if ((v2inner = v2inner.subtract(b0)) == null) {
            return null;
        }
        RsaBigInteger v2 = da1.add(a2);
        if (v2 == null) {
            return null;
        }
        if ((v2 = v2.shiftLeft(1)) == null) {
            return null;
        }
        if ((v2 = v2.subtract(a0)) == null) {
            return null;
        }
        if ((v2 = v2.multiply(v2inner)) == null) {
            return null;
        }
        RsaBigInteger vinf = a2.multiply(b2);
        if (vinf == null) {
            return null;
        }
        RsaBigInteger t2 = v2.subtract(vm1);
        if (t2 == null) {
            return null;
        }
        t2 = t2.exactDivideBy3();
        RsaBigInteger tm1 = v1.subtract(vm1);
        if (tm1 == null) {
            return null;
        }
        tm1 = v1.shiftRight(1);
        if (tm1 == null) {
            return null;
        }
        RsaBigInteger t1 = v1.subtract(v0);
        if (t1 == null) {
            return null;
        }
        if ((t2 = t2.subtract(t1)) == null) {
            return null;
        }
        if ((t2 = t2.shiftRight(1)) == null) {
            return null;
        }
        if ((t1 = t1.subtract(tm1)) == null) {
            return null;
        }
        if ((t1 = t1.subtract(vinf)) == null) {
            return null;
        }
        RsaBigInteger vinfShiftleft = vinf.shiftLeft(1);
        if (vinfShiftleft == null) {
            return null;
        }
        if ((t2 = t2.subtract(vinfShiftleft)) == null) {
            return null;
        }
        if ((tm1 = tm1.subtract(t2)) == null) {
            return null;
        }
        int ss = k * 32;
        RsaBigInteger result = vinf.shiftLeft(ss);
        if (result == null) {
            return null;
        }
        if ((result = result.add(t2)) == null) {
            return null;
        }
        if ((result = result.shiftLeft(ss)) == null) {
            return null;
        }
        if ((result = result.add(t1)) == null) {
            return null;
        }
        if ((result = result.shiftLeft(ss)) == null) {
            return null;
        }
        if ((result = result.add(tm1)) == null) {
            return null;
        }
        if ((result = result.shiftLeft(ss)) == null) {
            return null;
        }
        if ((result = result.add(v0)) == null) {
            return null;
        }
        if (a.signum != b.signum) {
            return result.negate();
        }
        return result;
    }

    private RsaBigInteger getToomSlice(int lowerSize, int upperSize, int slice, int fullsize) {
        int end;
        int start;
        int len = this.mag.length;
        int offset = fullsize - len;
        if (slice == 0) {
            start = -offset;
            end = upperSize - 1 - offset;
        } else {
            start = upperSize + (slice - 1) * lowerSize - offset;
            end = start + lowerSize - 1;
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            return ZERO;
        }
        int sliceSize = end - start + 1;
        if (sliceSize <= 0) {
            return ZERO;
        }
        if (start == 0 && sliceSize >= len) {
            return this.abs();
        }
        int[] intSlice = new int[sliceSize];
        System.arraycopy(this.mag, start, intSlice, 0, sliceSize);
        return new RsaBigInteger(RsaBigInteger.trustedStripLeadingZeroInts(intSlice), 1);
    }

    private RsaBigInteger exactDivideBy3() {
        int len = this.mag.length;
        int[] result = new int[len];
        long borrow = 0L;
        for (int i = len - 1; i >= 0; --i) {
            long x = (long)this.mag[i] & 0xFFFFFFFFL;
            long w = x - borrow;
            borrow = borrow > x ? 1L : 0L;
            long q = w * 0xAAAAAAABL & 0xFFFFFFFFL;
            result[i] = (int)q;
            if (q < 0x55555556L) continue;
            ++borrow;
            if (q < 0xAAAAAAABL) continue;
            ++borrow;
        }
        result = RsaBigInteger.trustedStripLeadingZeroInts(result);
        return new RsaBigInteger(result, this.signum);
    }

    private RsaBigInteger getLower(int n) {
        int len = this.mag.length;
        if (len <= n) {
            return this.abs();
        }
        int[] lowerInts = new int[n];
        System.arraycopy(this.mag, len - n, lowerInts, 0, n);
        return new RsaBigInteger(RsaBigInteger.trustedStripLeadingZeroInts(lowerInts), 1);
    }

    private RsaBigInteger getUpper(int n) {
        int len = this.mag.length;
        if (len <= n) {
            return ZERO;
        }
        int upperLen = len - n;
        int[] upperInts = new int[upperLen];
        System.arraycopy(this.mag, 0, upperInts, 0, upperLen);
        return new RsaBigInteger(RsaBigInteger.trustedStripLeadingZeroInts(upperInts), 1);
    }

    private RsaBigInteger square() {
        if (this.signum == 0) {
            return ZERO;
        }
        int len = this.mag.length;
        if (len < 128) {
            int[] z = RsaBigInteger.squareToLen(this.mag, len, null);
            return new RsaBigInteger(RsaBigInteger.trustedStripLeadingZeroInts(z), 1);
        }
        if (len < 216) {
            return this.squareKaratsuba();
        }
        return this.squareToomCook3();
    }

    private static final int[] squareToLen(int[] x, int len, int[] z) {
        if (x == null) {
            return new int[0];
        }
        int zlen = len << 1;
        if (z == null || z.length < zlen) {
            z = new int[zlen];
        }
        int lastProductLowWord = 0;
        int i = 0;
        for (int j = 0; j < len; ++j) {
            long piece = (long)x[j] & 0xFFFFFFFFL;
            long product = piece * piece;
            z[i] = lastProductLowWord << 31 | (int)RsaBigInteger.sl(product, 33);
            z[++i] = (int)RsaBigInteger.sl(product, 1);
            ++i;
            lastProductLowWord = (int)product;
        }
        int i2 = len;
        int offset = 1;
        while (i2 > 0) {
            int t = x[i2 - 1];
            t = RsaBigInteger.mulAdd(z, x, offset, i2 - 1, t);
            RsaBigInteger.addOne(z, offset - 1, i2, t);
            --i2;
            offset += 2;
        }
        RsaBigInteger.primitiveLeftShift(z, zlen, 1);
        int n = zlen - 1;
        z[n] = z[n] | x[len - 1] & 1;
        return z;
    }

    private RsaBigInteger squareKaratsuba() {
        int half = (this.mag.length + 1) / 2;
        RsaBigInteger xl = this.getLower(half);
        if (xl == null) {
            return null;
        }
        RsaBigInteger xh = this.getUpper(half);
        if (xh == null) {
            return null;
        }
        RsaBigInteger xhs = xh.square();
        if (xhs == null) {
            return null;
        }
        RsaBigInteger xls = xl.square();
        if (xls == null) {
            return null;
        }
        RsaBigInteger resultA = xhs.add(xls);
        if (resultA == null) {
            return null;
        }
        RsaBigInteger resultB = xl.add(xh);
        if (resultB == null) {
            return null;
        }
        if ((resultB = resultB.square()) == null) {
            return null;
        }
        if ((resultB = resultB.subtract(resultA)) == null) {
            return null;
        }
        RsaBigInteger result = xhs.shiftLeft(half * 32);
        if (result == null) {
            return null;
        }
        if ((result = result.add(resultB)) == null) {
            return null;
        }
        if ((result = result.shiftLeft(half * 32)) == null) {
            return null;
        }
        result = result.add(xls);
        return result;
    }

    private RsaBigInteger squareToomCook3() {
        int len = this.mag.length;
        int k = (len + 2) / 3;
        int r = len - 2 * k;
        RsaBigInteger a2 = this.getToomSlice(k, r, 0, len);
        if (a2 == null) {
            return null;
        }
        RsaBigInteger a1 = this.getToomSlice(k, r, 1, len);
        if (a1 == null) {
            return null;
        }
        RsaBigInteger a0 = this.getToomSlice(k, r, 2, len);
        if (a0 == null) {
            return null;
        }
        RsaBigInteger v0 = a0.square();
        if (v0 == null) {
            return null;
        }
        RsaBigInteger da1 = a2.add(a0);
        if (da1 == null) {
            return null;
        }
        RsaBigInteger vm1 = da1.subtract(a1);
        if (vm1 == null) {
            return null;
        }
        if ((vm1 = vm1.square()) == null) {
            return null;
        }
        if ((da1 = da1.add(a1)) == null) {
            return null;
        }
        RsaBigInteger v1 = da1.square();
        if (v1 == null) {
            return null;
        }
        RsaBigInteger vinf = a2.square();
        if (vinf == null) {
            return null;
        }
        RsaBigInteger v2 = da1.add(a2);
        if (v2 == null) {
            return null;
        }
        if ((v2 = v2.shiftLeft(1)) == null) {
            return null;
        }
        if ((v2 = v2.subtract(a0)) == null) {
            return null;
        }
        if ((v2 = v2.square()) == null) {
            return null;
        }
        RsaBigInteger t2 = v2.subtract(vm1);
        if (t2 == null) {
            return null;
        }
        t2 = t2.exactDivideBy3();
        RsaBigInteger tm1 = v1.subtract(vm1);
        if (tm1 == null) {
            return null;
        }
        if ((tm1 = tm1.shiftRight(1)) == null) {
            return null;
        }
        RsaBigInteger t1 = v1.subtract(v0);
        if (t1 == null) {
            return null;
        }
        if ((t2 = t2.subtract(t1)) == null) {
            return null;
        }
        if ((t2 = t2.shiftRight(1)) == null) {
            return null;
        }
        if ((t1 = t1.subtract(tm1)) == null) {
            return null;
        }
        if ((t1 = t1.subtract(vinf)) == null) {
            return null;
        }
        RsaBigInteger vinfShiftLeft = vinf.shiftLeft(1);
        if (vinfShiftLeft == null) {
            return null;
        }
        if ((t2 = t2.subtract(vinfShiftLeft)) == null) {
            return null;
        }
        if ((tm1 = tm1.subtract(t2)) == null) {
            return null;
        }
        int ss = k * 32;
        RsaBigInteger result = vinf.shiftLeft(ss);
        if (result == null) {
            return null;
        }
        if ((result = result.add(t2)) == null) {
            return null;
        }
        if ((result = result.shiftLeft(ss)) == null) {
            return null;
        }
        if ((result = result.add(t1)) == null) {
            return null;
        }
        if ((result = result.shiftLeft(ss)) == null) {
            return null;
        }
        if ((result = result.add(tm1)) == null) {
            return null;
        }
        if ((result = result.shiftLeft(ss)) == null) {
            return null;
        }
        result = result.add(v0);
        return result;
    }

    public RsaBigInteger remainder(RsaBigInteger val) {
        if (val == null) {
            return null;
        }
        if (val.mag.length < 80 || this.mag.length - val.mag.length < 40) {
            return this.remainderKnuth(val);
        }
        return this.remainderBurnikelZiegler(val);
    }

    private RsaBigInteger remainderKnuth(RsaBigInteger val) {
        if (val == null) {
            return null;
        }
        RsaMutableBigInteger a = new RsaMutableBigInteger(this.mag);
        RsaMutableBigInteger b = new RsaMutableBigInteger(val.mag);
        RsaMutableBigInteger q = new RsaMutableBigInteger();
        RsaMutableBigInteger result = a.divideKnuth(b, q);
        if (result == null) {
            return null;
        }
        return result.toBigInteger(this.signum);
    }

    private RsaBigInteger remainderBurnikelZiegler(RsaBigInteger val) {
        if (val == null) {
            return null;
        }
        RsaBigInteger[] result = this.divideAndRemainderBurnikelZiegler(val);
        if (result.length <= 1) {
            return null;
        }
        return result[1];
    }

    private RsaBigInteger[] divideAndRemainderBurnikelZiegler(RsaBigInteger val) {
        if (val == null) {
            return new RsaBigInteger[0];
        }
        RsaMutableBigInteger q = new RsaMutableBigInteger();
        RsaMutableBigInteger r = new RsaMutableBigInteger(this).divideAndRemainderBurnikelZiegler(new RsaMutableBigInteger(val), q);
        if (r == null) {
            return new RsaBigInteger[0];
        }
        RsaBigInteger qBigInt = q.isZero() ? ZERO : q.toBigInteger(this.signum * val.signum);
        RsaBigInteger rBigInt = r.isZero() ? ZERO : r.toBigInteger(this.signum);
        return new RsaBigInteger[]{qBigInt, rBigInt};
    }

    public RsaBigInteger gcd(RsaBigInteger val) {
        if (val == null) {
            return null;
        }
        if (val.signum == 0) {
            return this.abs();
        }
        if (this.signum == 0) {
            return val.abs();
        }
        RsaMutableBigInteger a = new RsaMutableBigInteger(this);
        RsaMutableBigInteger b = new RsaMutableBigInteger(val);
        RsaMutableBigInteger result = a.hybridGCD(b);
        if (result == null) {
            return null;
        }
        return result.toBigInteger(1);
    }

    public static int bitLengthForInt(int n) {
        return 32 - RsaBigInteger.integerNumberOfLeadingZeros(n);
    }

    private static int[] leftShift(int[] a, int len, int n) {
        if (a == null || a.length <= 1) {
            return new int[0];
        }
        if (len > a.length) {
            len = a.length;
        }
        int nInts = RsaBigInteger.si(n, 5);
        int nBits = n & 0x1F;
        int bitsInHighWord = RsaBigInteger.bitLengthForInt(a[0]);
        if (n <= 32 - bitsInHighWord) {
            RsaBigInteger.primitiveLeftShift(a, len, nBits);
            return a;
        }
        if (nBits <= 32 - bitsInHighWord) {
            int[] result = new int[nInts + len];
            System.arraycopy(a, 0, result, 0, len);
            RsaBigInteger.primitiveLeftShift(result, result.length, nBits);
            return result;
        }
        int[] result = new int[nInts + len + 1];
        System.arraycopy(a, 0, result, 0, len);
        RsaBigInteger.primitiveRightShift(result, result.length, 32 - nBits);
        return result;
    }

    private static void primitiveRightShift(int[] a, int len, int n) {
        int i;
        if (a == null || a.length <= 1) {
            return;
        }
        if (len > a.length) {
            len = a.length;
        }
        int n2 = 32 - n;
        int c = a[i];
        for (i = len - 1; i > 0; --i) {
            int b = c;
            c = a[i - 1];
            a[i] = c << n2 | RsaBigInteger.si(b, n);
        }
        a[0] = RsaBigInteger.si(a[0], n);
    }

    private static void primitiveLeftShift(int[] a, int len, int n) {
        int i;
        if (a == null || a.length <= 1) {
            return;
        }
        if (len > a.length) {
            len = a.length;
        }
        if (len == 0 || n == 0) {
            return;
        }
        int n2 = 32 - n;
        int c = a[i];
        int m = i + len - 1;
        for (i = 0; i < m; ++i) {
            int b = c;
            c = a[i + 1];
            a[i] = b << n | RsaBigInteger.si(c, n2);
        }
        int n3 = len - 1;
        a[n3] = a[n3] << n;
    }

    private static int bitLength(int[] val, int len) {
        if (val == null || val.length <= 1) {
            return 0;
        }
        if (len == 0) {
            return 0;
        }
        return (len - 1 << 5) + RsaBigInteger.bitLengthForInt(val[0]);
    }

    private RsaBigInteger abs() {
        return this.signum >= 0 ? this : this.negate();
    }

    private RsaBigInteger negate() {
        return new RsaBigInteger(this.mag, -this.signum);
    }

    private RsaBigInteger mod(RsaBigInteger m) {
        if (m == null) {
            return null;
        }
        if (m.signum <= 0) {
            return null;
        }
        RsaBigInteger result = this.remainder(m);
        if (result == null) {
            return null;
        }
        return result.signum >= 0 ? result : result.add(m);
    }

    public RsaBigInteger modPow(RsaBigInteger exponent, RsaBigInteger m) {
        RsaBigInteger result;
        RsaBigInteger base;
        boolean invertResult;
        if (exponent == null || m == null) {
            return null;
        }
        if (m.signum <= 0) {
            return null;
        }
        if (exponent.signum == 0) {
            return m.equals(ONE) ? ZERO : ONE;
        }
        if (this.equals(ONE)) {
            return m.equals(ONE) ? ZERO : ONE;
        }
        if (this.equals(ZERO) && exponent.signum >= 0) {
            return ZERO;
        }
        if (this.equals(NEGATIVE_ONE) && !exponent.testBit(0)) {
            return m.equals(ONE) ? ZERO : ONE;
        }
        boolean bl = invertResult = exponent.signum < 0;
        if (invertResult) {
            exponent = exponent.negate();
        }
        RsaBigInteger rsaBigInteger = base = this.signum < 0 || this.compareTo(m) >= 0 ? this.mod(m) : this;
        if (base == null) {
            return null;
        }
        if (m.testBit(0)) {
            result = base.oddModPow(exponent, m);
            if (result == null) {
                return null;
            }
        } else {
            RsaBigInteger a1;
            RsaBigInteger base2;
            int p = m.getLowestSetBit();
            RsaBigInteger m1 = m.shiftRight(p);
            if (m1 == null) {
                return null;
            }
            RsaBigInteger m2 = ONE.shiftLeft(p);
            if (m2 == null) {
                return null;
            }
            RsaBigInteger rsaBigInteger2 = base2 = this.signum < 0 || this.compareTo(m1) >= 0 ? this.mod(m1) : this;
            if (base2 == null) {
                return null;
            }
            RsaBigInteger rsaBigInteger3 = a1 = m1.equals(ONE) ? ZERO : base2.oddModPow(exponent, m1);
            if (a1 == null) {
                return null;
            }
            RsaBigInteger a2 = base.modPow2(exponent, p);
            if (a2 == null) {
                return null;
            }
            RsaBigInteger y1 = m2.modInverse(m1);
            if (y1 == null) {
                return null;
            }
            RsaBigInteger y2 = m1.modInverse(m2);
            if (y2 == null) {
                return null;
            }
            if (m.mag.length < 0x2000000) {
                RsaBigInteger resultInner = a2.multiply(m1);
                if (resultInner == null) {
                    return null;
                }
                if ((resultInner = resultInner.multiply(y2)) == null) {
                    return null;
                }
                result = a1.multiply(m2);
                if (result == null) {
                    return null;
                }
                if ((result = result.multiply(y1)) == null) {
                    return null;
                }
                if ((result = result.add(resultInner)) == null) {
                    return null;
                }
                result = result.mod(m);
            } else {
                RsaMutableBigInteger t1 = new RsaMutableBigInteger();
                new RsaMutableBigInteger(a1.multiply(m2)).multiply(new RsaMutableBigInteger(y1), t1);
                RsaMutableBigInteger t2 = new RsaMutableBigInteger();
                new RsaMutableBigInteger(a2.multiply(m1)).multiply(new RsaMutableBigInteger(y2), t2);
                t1.add(t2);
                RsaMutableBigInteger q = new RsaMutableBigInteger();
                RsaMutableBigInteger r = t1.divide(new RsaMutableBigInteger(m), q);
                if (r == null) {
                    return null;
                }
                result = r.toBigInteger();
                if (result == null) {
                    return null;
                }
            }
        }
        return invertResult ? result.modInverse(m) : result;
    }

    private RsaBigInteger oddModPow(RsaBigInteger y, RsaBigInteger z) {
        int i;
        RsaMutableBigInteger q;
        RsaMutableBigInteger b2;
        if (y == null || z == null || y.mag.length <= 0 || z.mag.length <= 0) {
            return null;
        }
        if (y.equals(ONE)) {
            return this;
        }
        if (this.signum == 0) {
            return ZERO;
        }
        int[] base = (int[])this.mag.clone();
        int[] exp = y.mag;
        int[] mod = z.mag;
        int modLen = mod.length;
        int wbits = 0;
        int ebits = RsaBigInteger.bitLength(exp, exp.length);
        if (ebits <= 0) {
            return null;
        }
        if (ebits != 17 || exp[0] != 65537) {
            while (ebits > bnExpModThreshTable[wbits]) {
                ++wbits;
            }
        }
        int tblmask = 1 << wbits;
        int[][] table = new int[tblmask][];
        for (int i2 = 0; i2 < tblmask; ++i2) {
            table[i2] = new int[modLen];
        }
        int inv = -RsaMutableBigInteger.inverseMod32(mod[modLen - 1]);
        int[] a = RsaBigInteger.leftShift(base, base.length, modLen << 5);
        RsaMutableBigInteger a2 = new RsaMutableBigInteger(a);
        RsaMutableBigInteger r = a2.divide(b2 = new RsaMutableBigInteger(mod), q = new RsaMutableBigInteger());
        if (r == null) {
            return null;
        }
        table[0] = r.toIntArray();
        if (table[0].length < modLen) {
            int offset = modLen - table[0].length;
            int[] t2 = new int[modLen];
            for (i = 0; i < table[0].length; ++i) {
                t2[i + offset] = table[0][i];
            }
            table[0] = t2;
        }
        int[] b = RsaBigInteger.squareToLen(table[0], modLen, null);
        b = RsaBigInteger.montReduce(b, mod, modLen, inv);
        int[] t = Arrays.copyOf(b, modLen);
        for (i = 1; i < tblmask; ++i) {
            int[] prod = this.multiplyToLen(t, modLen, table[i - 1], modLen, null);
            table[i] = RsaBigInteger.montReduce(prod, mod, modLen, inv);
        }
        int bitpos = 1 << (ebits - 1 & 0x1F);
        int buf = 0;
        int elen = exp.length;
        int eIndex = 0;
        for (int i3 = 0; i3 <= wbits; ++i3) {
            buf = buf << 1 | ((exp[eIndex] & bitpos) != 0 ? 1 : 0);
            if ((bitpos = RsaBigInteger.si(bitpos, 1)) != 0) continue;
            ++eIndex;
            bitpos = Integer.MIN_VALUE;
            --elen;
        }
        boolean isone = true;
        int multpos = --ebits - wbits;
        if (buf == 0) {
            return null;
        }
        while ((buf & 1) == 0) {
            buf = RsaBigInteger.si(buf, 1);
            ++multpos;
        }
        int[] mult = table[RsaBigInteger.si(buf, 1)];
        buf = 0;
        if (multpos == ebits) {
            isone = false;
        }
        while (true) {
            --ebits;
            buf <<= 1;
            if (elen != 0) {
                buf |= (exp[eIndex] & bitpos) != 0 ? 1 : 0;
                if ((bitpos = RsaBigInteger.si(bitpos, 1)) == 0) {
                    ++eIndex;
                    bitpos = Integer.MIN_VALUE;
                    --elen;
                }
            }
            if ((buf & tblmask) != 0) {
                multpos = ebits - wbits;
                if (buf == 0) {
                    return null;
                }
                while ((buf & 1) == 0) {
                    buf = RsaBigInteger.si(buf, 1);
                    ++multpos;
                }
                mult = table[RsaBigInteger.si(buf, 1)];
                buf = 0;
            }
            if (ebits == multpos) {
                if (isone) {
                    b = (int[])mult.clone();
                    isone = false;
                } else {
                    t = b;
                    a = this.multiplyToLen(t, modLen, mult, modLen, a);
                    a = RsaBigInteger.montReduce(a, mod, modLen, inv);
                    t = a;
                    a = b;
                    b = t;
                }
            }
            if (ebits <= 0) break;
            if (isone) continue;
            t = b;
            a = RsaBigInteger.squareToLen(t, modLen, a);
            a = RsaBigInteger.montReduce(a, mod, modLen, inv);
            t = a;
            a = b;
            b = t;
        }
        int[] t2 = new int[2 * modLen];
        System.arraycopy(b, 0, t2, modLen, modLen);
        b = RsaBigInteger.montReduce(t2, mod, modLen, inv);
        t2 = Arrays.copyOf(b, modLen);
        return new RsaBigInteger(1, t2);
    }

    private static int[] montReduce(int[] n, int[] mod, int mlen, int inv) {
        if (n == null || mod == null) {
            return new int[0];
        }
        int c = 0;
        int len = mlen;
        int offset = 0;
        do {
            int nEnd = n[n.length - 1 - offset];
            int carry = RsaBigInteger.mulAdd(n, mod, offset, mlen, inv * nEnd);
            c += RsaBigInteger.addOne(n, offset, mlen, carry);
            ++offset;
        } while (--len > 0);
        while (c > 0) {
            int add = RsaBigInteger.subN(n, mod, mlen);
            if (add == 0) {
                return new int[0];
            }
            c += add;
        }
        while (RsaBigInteger.intArrayCmpToLen(n, mod, mlen) >= 0) {
            RsaBigInteger.subN(n, mod, mlen);
        }
        return n;
    }

    private static int intArrayCmpToLen(int[] arg1, int[] arg2, int len) {
        if (arg1 == null || arg2 == null || len > arg1.length || len > arg2.length) {
            return 0;
        }
        for (int i = 0; i < len; ++i) {
            long b1 = (long)arg1[i] & 0xFFFFFFFFL;
            long b2 = (long)arg2[i] & 0xFFFFFFFFL;
            if (b1 < b2) {
                return -1;
            }
            if (b1 <= b2) continue;
            return 1;
        }
        return 0;
    }

    private static int subN(int[] a, int[] b, int len) {
        if (a == null || b == null || len > a.length || len > b.length) {
            return 0;
        }
        long sum = 0L;
        --len;
        while (len >= 0) {
            sum = ((long)a[len] & 0xFFFFFFFFL) - ((long)b[len] & 0xFFFFFFFFL) + (sum >> 32);
            a[len] = (int)sum;
            --len;
        }
        return (int)(sum >> 32);
    }

    private static int mulAdd(int[] out, int[] in, int offset, int len, int k) {
        if (out == null || in == null || len > out.length || len > in.length) {
            return 0;
        }
        long kLong = (long)k & 0xFFFFFFFFL;
        long carry = 0L;
        offset = out.length - offset - 1;
        for (int j = len - 1; j >= 0; --j) {
            long product = ((long)in[j] & 0xFFFFFFFFL) * kLong + ((long)out[offset] & 0xFFFFFFFFL) + carry;
            out[offset] = (int)product;
            --offset;
            carry = RsaBigInteger.sl(product, 32);
        }
        return (int)carry;
    }

    private static int addOne(int[] a, int offset, int mlen, int carry) {
        if (a == null || a.length - 1 - mlen - offset >= a.length || a.length - 1 - mlen - offset < 0) {
            return 0;
        }
        offset = a.length - 1 - mlen - offset;
        long t = ((long)a[offset] & 0xFFFFFFFFL) + ((long)carry & 0xFFFFFFFFL);
        a[offset] = (int)t;
        if (RsaBigInteger.sl(t, 32) == 0L) {
            return 0;
        }
        --mlen;
        while (mlen >= 0) {
            if (--offset < 0) {
                return 1;
            }
            a[offset] = a[offset] + 1;
            if (a[offset] != 0) {
                return 0;
            }
            --mlen;
        }
        return 1;
    }

    private RsaBigInteger modPow2(RsaBigInteger exponent, int p) {
        if (exponent == null) {
            return null;
        }
        RsaBigInteger result = ONE;
        RsaBigInteger baseToPow2 = this.mod2(p);
        if (baseToPow2 == null) {
            return null;
        }
        int expOffset = 0;
        int limit = exponent.bitLength();
        if (this.testBit(0)) {
            int n = limit = p - 1 < limit ? p - 1 : limit;
        }
        while (expOffset < limit) {
            if (exponent.testBit(expOffset)) {
                if ((result = result.multiply(baseToPow2)) == null) {
                    return null;
                }
                if ((result = result.mod2(p)) == null) {
                    return null;
                }
            }
            if (++expOffset >= limit) continue;
            if ((baseToPow2 = baseToPow2.square()) == null) {
                return null;
            }
            if ((baseToPow2 = baseToPow2.mod2(p)) != null) continue;
            return null;
        }
        return result;
    }

    private RsaBigInteger mod2(int p) {
        if (this.bitLength() <= p) {
            return this;
        }
        int numInts = RsaBigInteger.si(p + 31, 5);
        if (numInts > this.mag.length) {
            return null;
        }
        int[] mag = new int[numInts];
        System.arraycopy(this.mag, this.mag.length - numInts, mag, 0, numInts);
        int excessBits = (numInts << 5) - p;
        mag[0] = (int)((long)mag[0] & (1L << 32 - excessBits) - 1L);
        return mag[0] == 0 ? new RsaBigInteger(1, mag) : new RsaBigInteger(mag, 1);
    }

    public RsaBigInteger modInverse(RsaBigInteger m) {
        if (m == null) {
            return null;
        }
        if (m.signum != 1) {
            return null;
        }
        if (m.equals(ONE)) {
            return ZERO;
        }
        RsaBigInteger modVal = this;
        if ((this.signum < 0 || this.compareMagnitude(m) >= 0) && (modVal = this.mod(m)) == null) {
            return null;
        }
        if (modVal.equals(ONE)) {
            return ONE;
        }
        RsaMutableBigInteger a = new RsaMutableBigInteger(modVal);
        RsaMutableBigInteger b = new RsaMutableBigInteger(m);
        RsaMutableBigInteger result = a.mutableModInverse(b);
        if (result == null) {
            return null;
        }
        return result.toBigInteger(1);
    }

    private RsaBigInteger shiftLeft(int n) {
        if (this.signum == 0) {
            return ZERO;
        }
        if (n > 0) {
            return new RsaBigInteger(RsaBigInteger.shiftLeft(this.mag, n), this.signum);
        }
        if (n == 0) {
            return this;
        }
        return this.shiftRightImpl(-n);
    }

    private static int[] shiftLeft(int[] mag, int n) {
        int[] newMag;
        if (mag == null) {
            return new int[0];
        }
        int nInts = RsaBigInteger.si(n, 5);
        int nBits = n & 0x1F;
        int magLen = mag.length;
        if (nBits == 0) {
            newMag = new int[magLen + nInts];
            System.arraycopy(mag, 0, newMag, 0, magLen);
        } else {
            int j;
            if (mag.length <= 0) {
                return new int[0];
            }
            int i = 0;
            int nBits2 = 32 - nBits;
            int highBits = RsaBigInteger.si(mag[0], nBits2);
            if (highBits != 0) {
                newMag = new int[magLen + nInts + 1];
                newMag[i] = highBits;
                ++i;
            } else {
                newMag = new int[magLen + nInts];
            }
            for (j = 0; j < magLen - 1; ++j) {
                newMag[i] = mag[j] << nBits | RsaBigInteger.si(mag[j + 1], nBits2);
                ++i;
            }
            newMag[i] = mag[j] << nBits;
        }
        return newMag;
    }

    private RsaBigInteger shiftRight(int n) {
        if (this.signum == 0) {
            return ZERO;
        }
        if (n > 0) {
            return this.shiftRightImpl(n);
        }
        if (n == 0) {
            return this;
        }
        return new RsaBigInteger(RsaBigInteger.shiftLeft(this.mag, -n), this.signum);
    }

    private RsaBigInteger shiftRightImpl(int n) {
        int[] newMag;
        int nInts = RsaBigInteger.si(n, 5);
        int nBits = n & 0x1F;
        int magLen = this.mag.length;
        if (nInts >= magLen) {
            return this.signum >= 0 ? ZERO : NEGATIVE_ONE;
        }
        if (nBits == 0) {
            int newMagLen = magLen - nInts;
            newMag = Arrays.copyOf(this.mag, newMagLen);
        } else {
            int i = 0;
            int highBits = RsaBigInteger.si(this.mag[0], nBits);
            if (highBits != 0) {
                newMag = new int[magLen - nInts];
                newMag[i] = highBits;
                ++i;
            } else {
                newMag = new int[magLen - nInts - 1];
            }
            int nBits2 = 32 - nBits;
            for (int j = 0; j < magLen - nInts - 1; ++j) {
                newMag[i] = this.mag[j] << nBits2 | RsaBigInteger.si(this.mag[j + 1], nBits);
                ++i;
            }
        }
        if (this.signum < 0) {
            boolean onesLost = false;
            int j = magLen - nInts;
            for (int i = magLen - 1; i >= j && !onesLost; --i) {
                onesLost = this.mag[i] != 0;
            }
            if (!onesLost && nBits != 0) {
                boolean bl = onesLost = this.mag[magLen - nInts - 1] << 32 - nBits != 0;
            }
            if (onesLost) {
                newMag = this.javaIncrement(newMag);
            }
        }
        return new RsaBigInteger(newMag, this.signum);
    }

    private int[] javaIncrement(int[] val) {
        if (val == null) {
            return new int[0];
        }
        int lastSum = 0;
        int i = val.length - 1;
        while (i >= 0 && lastSum == 0) {
            int n = i--;
            int n2 = val[n] + 1;
            val[n] = n2;
            lastSum = n2;
        }
        if (lastSum == 0) {
            val = new int[val.length + 1];
            val[0] = 1;
        }
        return val;
    }

    private boolean testBit(int n) {
        if (n < 0) {
            return false;
        }
        return (this.getInt(RsaBigInteger.si(n, 5)) & 1 << (n & 0x1F)) != 0;
    }

    private RsaBigInteger setBit(int n) {
        if (n < 0) {
            return null;
        }
        int intNum = RsaBigInteger.si(n, 5);
        int[] result = new int[Math.max(this.intLength(), intNum + 2)];
        for (int i = 0; i < result.length; ++i) {
            result[result.length - i - 1] = this.getInt(i);
        }
        int n2 = result.length - intNum - 1;
        result[n2] = result[n2] | 1 << (n & 0x1F);
        return RsaBigInteger.valueOf(result);
    }

    private int getLowestSetBit() {
        int lsb = this.lowestSetBit - 2;
        if (lsb == -2) {
            lsb = 0;
            if (this.signum == 0) {
                --lsb;
            } else {
                int b;
                int i = 0;
                while ((b = this.getInt(i)) == 0) {
                    ++i;
                }
                lsb += (i << 5) + RsaBigInteger.integerNumberOfTrailingZeros(b);
            }
            this.lowestSetBit = lsb + 2;
        }
        return lsb;
    }

    public int bitLength() {
        int n = this.bitLength - 1;
        if (n == -1) {
            int len = this.mag.length;
            if (len == 0) {
                n = 0;
            } else {
                int magBitLength = (len - 1 << 5) + RsaBigInteger.bitLengthForInt(this.mag[0]);
                if (this.signum < 0) {
                    boolean pow2 = RsaBigInteger.integerBitCount(this.mag[0]) == 1;
                    for (int i = 1; i < len && pow2; ++i) {
                        pow2 = this.mag[i] == 0;
                    }
                    n = pow2 ? magBitLength - 1 : magBitLength;
                } else {
                    n = magBitLength;
                }
            }
            this.bitLength = n + 1;
        }
        return n;
    }

    public int compareTo(RsaBigInteger val) {
        if (val == null) {
            return 0;
        }
        if (this.signum == val.signum) {
            switch (this.signum) {
                case 1: {
                    return this.compareMagnitude(val);
                }
                case -1: {
                    return val.compareMagnitude(this);
                }
            }
            return 0;
        }
        return this.signum > val.signum ? 1 : -1;
    }

    private final int compareMagnitude(RsaBigInteger val) {
        if (val == null) {
            return 0;
        }
        int[] m1 = this.mag;
        int len1 = m1.length;
        int[] m2 = val.mag;
        int len2 = m2.length;
        if (len1 < len2) {
            return -1;
        }
        if (len1 > len2) {
            return 1;
        }
        for (int i = 0; i < len1; ++i) {
            int a = m1[i];
            int b = m2[i];
            if (a == b) continue;
            return ((long)a & 0xFFFFFFFFL) < ((long)b & 0xFFFFFFFFL) ? -1 : 1;
        }
        return 0;
    }

    public byte[] toByteArray() {
        int byteLen = this.bitLength() / 8 + 1;
        byte[] byteArray = new byte[byteLen];
        int bytesCopied = 4;
        int nextInt = 0;
        int intIndex = 0;
        for (int i = byteLen - 1; i >= 0; --i) {
            if (bytesCopied == 4) {
                nextInt = this.getInt(intIndex);
                ++intIndex;
                bytesCopied = 1;
            } else {
                nextInt = RsaBigInteger.si(nextInt, 8);
                ++bytesCopied;
            }
            byteArray[i] = (byte)nextInt;
        }
        if (byteArray[0] == 0) {
            byte[] tmp = new byte[byteArray.length - 1];
            System.arraycopy(byteArray, 1, tmp, 0, tmp.length);
            byteArray = tmp;
        }
        return byteArray;
    }

    public int intValue() {
        int result = this.getInt(0);
        return result;
    }

    private static int[] stripLeadingZeroInts(int[] val) {
        int keep;
        if (val == null) {
            return new int[0];
        }
        int vlen = val.length;
        for (keep = 0; keep < vlen && val[keep] == 0; ++keep) {
        }
        return Arrays.copyOfRange(val, keep, vlen);
    }

    private static int[] trustedStripLeadingZeroInts(int[] val) {
        int keep;
        if (val == null) {
            return new int[0];
        }
        int vlen = val.length;
        for (keep = 0; keep < vlen && val[keep] == 0; ++keep) {
        }
        return keep == 0 ? val : Arrays.copyOfRange(val, keep, vlen);
    }

    private static int[] stripLeadingZeroBytes(byte[] a) {
        int keep;
        if (a == null) {
            return new int[0];
        }
        int byteLength = a.length;
        for (keep = 0; keep < byteLength && a[keep] == 0; ++keep) {
        }
        int intLength = RsaBigInteger.si(byteLength - keep + 3, 2);
        int[] result = new int[intLength];
        int b = byteLength - 1;
        for (int i = intLength - 1; i >= 0; --i) {
            result[i] = a[b] & 0xFF;
            int bytesRemaining = --b - keep + 1;
            int bytesToTransfer = Math.min(3, bytesRemaining);
            for (int j = 8; j <= bytesToTransfer << 3; j += 8) {
                int n = i;
                result[n] = result[n] | (a[b] & 0xFF) << j;
                --b;
            }
        }
        return result;
    }

    private static int[] makePositive(int[] a) {
        int i;
        int j;
        int keep;
        if (a == null) {
            return new int[0];
        }
        for (keep = 0; keep < a.length && a[keep] == -1; ++keep) {
        }
        for (j = keep; j < a.length && a[j] == 0; ++j) {
        }
        int extraInt = j == a.length ? 1 : 0;
        int[] result = new int[a.length - keep + extraInt];
        for (i = keep; i < a.length; ++i) {
            result[i - keep + extraInt] = ~a[i];
        }
        i = result.length - 1;
        result[i] = result[i] + 1;
        while (result[i] == 0) {
            result[--i] = result[i] + 1;
        }
        return result;
    }

    private int intLength() {
        return RsaBigInteger.si(this.bitLength(), 5) + 1;
    }

    private int signInt() {
        return this.signum < 0 ? -1 : 0;
    }

    private int getInt(int n) {
        if (n < 0) {
            return 0;
        }
        if (n >= this.mag.length) {
            return this.signInt();
        }
        int index = this.mag.length - n - 1;
        if (index >= this.mag.length) {
            return 0;
        }
        int magInt = this.mag[index];
        return this.signum >= 0 ? magInt : (n <= this.firstNonzeroIntNum() ? -magInt : ~magInt);
    }

    private int firstNonzeroIntNum() {
        int fn = this.firstNonzeroIntNum - 2;
        if (fn == -2) {
            int i;
            int mlen = this.mag.length;
            for (i = mlen - 1; i >= 0 && this.mag[i] == 0; --i) {
            }
            fn = mlen - i - 1;
            this.firstNonzeroIntNum = fn + 2;
        }
        return fn;
    }

    public boolean equals(Object x) {
        if (x == null) {
            return false;
        }
        if (x == this) {
            return true;
        }
        if (!(x instanceof RsaBigInteger)) {
            return false;
        }
        RsaBigInteger xInt = (RsaBigInteger)x;
        if (xInt.signum != this.signum) {
            return false;
        }
        int[] m = this.mag;
        int len = m.length;
        int[] xm = xInt.mag;
        if (len != xm.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (xm[i] == m[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 0;
        for (int i = 0; i < this.mag.length; ++i) {
            hashCode = (int)((long)(31 * hashCode) + ((long)this.mag[i] & 0xFFFFFFFFL));
        }
        return hashCode * this.signum;
    }
}

