/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.sockets;

import java.util.HashMap;
import lowentry.ue4.classes.sockets.LatentResponse;
import lowentry.ue4.classes.sockets.SocketClient;

public class LatentResponseImplementation
implements LatentResponse {
    protected final HashMap<Integer, LatentResponse> latentResponses;
    protected final SocketClient socketClient;
    protected final int functionCallId;
    protected final Object synchronizer = new Object();
    protected boolean canceled = false;
    protected boolean done = false;
    protected volatile Runnable onCanceled = null;

    public LatentResponseImplementation(HashMap<Integer, LatentResponse> latentResponses, SocketClient socketClient, int functionCallId) {
        this.latentResponses = latentResponses;
        this.socketClient = socketClient;
        this.functionCallId = functionCallId;
        this.addToHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToHashMap() {
        HashMap<Integer, LatentResponse> hashMap = this.latentResponses;
        synchronized (hashMap) {
            this.latentResponses.put(this.functionCallId, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromHashMap() {
        HashMap<Integer, LatentResponse> hashMap = this.latentResponses;
        synchronized (hashMap) {
            this.latentResponses.remove(this.functionCallId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        boolean changed = false;
        Object object = this.synchronizer;
        synchronized (object) {
            if (!this.done && !this.canceled) {
                this.canceled = true;
                changed = true;
            }
        }
        if (changed) {
            this.removeFromHashMap();
            this.socketClient.sendLatentFunctionCallCancel(this.functionCallId);
            try {
                Runnable code = this.onCanceled;
                if (code != null) {
                    this.socketClient.execute(code);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void done(byte[] bytes) {
        boolean changed = false;
        Object object = this.synchronizer;
        synchronized (object) {
            if (!this.done && !this.canceled) {
                this.done = true;
                changed = true;
            }
        }
        if (changed) {
            this.removeFromHashMap();
            this.socketClient.sendLatentFunctionCallResponse(this.functionCallId, bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void canceledByClient() {
        boolean changed = false;
        Object object = this.synchronizer;
        synchronized (object) {
            if (!this.done && !this.canceled) {
                this.canceled = true;
                changed = true;
            }
        }
        if (changed) {
            try {
                Runnable code = this.onCanceled;
                if (code != null) {
                    this.socketClient.execute(code);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void canceledByDisconnecting() {
        boolean changed = false;
        Object object = this.synchronizer;
        synchronized (object) {
            if (!this.done && !this.canceled) {
                this.canceled = true;
                changed = true;
            }
        }
        if (changed) {
            try {
                Runnable code = this.onCanceled;
                if (code != null) {
                    this.socketClient.execute(code);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanceled() {
        Object object = this.synchronizer;
        synchronized (object) {
            return this.canceled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        Object object = this.synchronizer;
        synchronized (object) {
            return this.done;
        }
    }

    @Override
    public void setOnCanceled(Runnable code) {
        this.onCanceled = code;
    }
}

