/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.sockets;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import lowentry.ue4.classes.sockets.SimpleSocketServer;
import lowentry.ue4.classes.sockets.SocketFunctions;
import lowentry.ue4.classes.sockets.SocketServer;
import lowentry.ue4.library.LowEntry;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.PyroClient;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.PyroException;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.PyroSelector;

public class SimpleSocketClient {
    protected final SimpleSocketServer server;
    protected final PyroClient client;
    protected volatile Object attachment;
    protected boolean isDisconnecting = false;
    protected boolean isHandshakeCompleted = false;
    protected boolean isWebsocket = false;
    protected Collection<byte[]> bufferedPacketsDuringHandshake = null;
    protected volatile String addressText = null;
    protected final int hashCode;

    public SimpleSocketClient(SimpleSocketServer server, PyroClient client) {
        this.server = server;
        this.client = client;
        this.hashCode = super.hashCode();
    }

    public void setAttachment(Object attachment) {
        this.attachment = attachment;
    }

    public <T> T getAttachment() {
        return (T)this.attachment;
    }

    public boolean hasAttachment() {
        return this.attachment != null;
    }

    public InetSocketAddress getLocalAddress() {
        return this.client.getLocalAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        return this.client.getRemoteAddress();
    }

    public InetAddress getIp() {
        return this.client.getInetAddress();
    }

    public String getIpString() {
        InetAddress ip = this.getIp();
        if (ip == null) {
            return null;
        }
        return ip.getHostAddress();
    }

    protected void onHandshakeCompleted(boolean isWebsocket) {
        if (this.isHandshakeCompleted) {
            return;
        }
        this.isHandshakeCompleted = true;
        this.isWebsocket = isWebsocket;
        if (this.bufferedPacketsDuringHandshake != null) {
            for (byte[] packet : this.bufferedPacketsDuringHandshake) {
                this.sendPacket(packet);
            }
            this.bufferedPacketsDuringHandshake = null;
        }
    }

    protected boolean isHandshakeCompleted() {
        return this.isHandshakeCompleted;
    }

    protected boolean isWebsocket() {
        return this.isWebsocket;
    }

    public void sendPacket(byte[] ... bytes) {
        this.sendPacket(LowEntry.mergeBytes(bytes));
    }

    public void sendPacket(byte[] bytes) {
        byte[] b;
        byte[] byArray = b = bytes == null ? new byte[]{} : bytes;
        if (this.client.selector().isNetworkThread()) {
            this.sendPacketCode(b);
        } else {
            this.client.selector().scheduleTask(() -> this.sendPacketCode(b));
        }
    }

    protected void sendPacketCode(byte[] bytes) {
        block8: {
            ByteBuffer buffer;
            if (!this.isConnected()) {
                return;
            }
            if (!this.isHandshakeCompleted()) {
                if (this.bufferedPacketsDuringHandshake == null) {
                    this.bufferedPacketsDuringHandshake = new ArrayList<byte[]>();
                }
                this.bufferedPacketsDuringHandshake.add(bytes);
                return;
            }
            if (this.isWebsocket()) {
                buffer = ByteBuffer.allocate(1 + SocketFunctions.websocketSizeByteCount(bytes.length));
                buffer.put((byte)-126);
                SocketFunctions.putWebsocketSizeBytes(buffer, bytes.length);
            } else {
                buffer = ByteBuffer.allocate(4);
                buffer.put((byte)(bytes.length >> 24));
                buffer.put((byte)(bytes.length >> 16));
                buffer.put((byte)(bytes.length >> 8));
                buffer.put((byte)bytes.length);
            }
            buffer.flip();
            try {
                this.client.write(buffer);
                if (bytes.length > 0) {
                    this.client.write(ByteBuffer.wrap(bytes));
                }
            }
            catch (PyroException e) {
                if (!SimpleSocketServer.IS_DEBUGGING) break block8;
                SimpleSocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this + " can't be send a packet:");
                SimpleSocketServer.DEBUGGING_PRINTSTREAM.println(LowEntry.getStackTrace(e));
            }
        }
    }

    public void disconnect() {
        if (this.client.selector().isNetworkThread()) {
            if (this.isDisconnecting) {
                return;
            }
            this.isDisconnecting = true;
            this.sendCloseMessage();
            this.client.shutdown();
        } else {
            this.client.selector().scheduleTask(() -> {
                if (this.isDisconnecting) {
                    return;
                }
                this.isDisconnecting = true;
                this.sendCloseMessage();
                this.client.shutdown();
            });
        }
    }

    public void disconnectImmediately() {
        if (this.client.selector().isNetworkThread()) {
            if (this.isDisconnecting) {
                return;
            }
            this.isDisconnecting = true;
            this.client.dropConnection();
        } else {
            this.client.selector().scheduleTask(() -> {
                if (this.isDisconnecting) {
                    return;
                }
                this.isDisconnecting = true;
                this.client.dropConnection();
            });
        }
    }

    protected void sendCloseMessage() {
        block4: {
            if (!this.isHandshakeCompleted()) {
                return;
            }
            if (this.isWebsocket()) {
                try {
                    this.client.write(ByteBuffer.wrap(new byte[]{-120}));
                }
                catch (PyroException e) {
                    if (!SocketServer.IS_DEBUGGING) break block4;
                    SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this + " can't send be send FIN + CLOSE (websocket):");
                    SocketServer.DEBUGGING_PRINTSTREAM.println(LowEntry.getStackTrace(e));
                }
            }
        }
    }

    public boolean isConnected() {
        this.client.selector().checkThread();
        return !this.isDisconnecting && !this.client.isDisconnected();
    }

    public PyroClient pyro() {
        return this.client;
    }

    public SimpleSocketServer server() {
        return this.server;
    }

    public PyroSelector selector() {
        return this.client.selector();
    }

    public void execute(Runnable runnable) {
        if (this.client.selector().isNetworkThread()) {
            runnable.run();
        } else {
            this.client.selector().scheduleTask(runnable);
        }
    }

    public boolean isNetworkThread() {
        return this.client.selector().isNetworkThread();
    }

    protected void saveAddressText() {
        if (this.client == null) {
            this.addressText = "closed";
            return;
        }
        this.addressText = this.client.getAddressText();
    }

    public String getAddressText() {
        String addressText = this.addressText;
        if (addressText != null) {
            return addressText;
        }
        if (this.client == null) {
            return "closed";
        }
        return this.client.getAddressText();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getAddressText() + "]";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        return this == o;
    }
}

