/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.sockets;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import lowentry.ue4.classes.internal.CachedTime;
import lowentry.ue4.classes.sockets.SimpleSocketConnectionHandler;
import lowentry.ue4.classes.sockets.SimpleSocketConnectionListener;
import lowentry.ue4.library.LowEntry;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.PyroClient;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.PyroException;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.PyroSelector;

public class SimpleSocketConnection {
    protected final PyroSelector selector;
    protected final InetSocketAddress address;
    protected final SimpleSocketConnectionListener socketListener;
    protected PyroClient connection;
    protected volatile Object attachment;
    protected boolean isDisconnecting;

    public SimpleSocketConnection(String host, int port, SimpleSocketConnectionListener listener) {
        this.socketListener = listener;
        this.selector = new PyroSelector();
        this.address = new InetSocketAddress(host, port);
    }

    public SimpleSocketConnection(InetSocketAddress end, SimpleSocketConnectionListener listener) {
        this.socketListener = listener;
        this.selector = new PyroSelector();
        this.address = end;
    }

    public boolean connect() {
        this.selector.checkThread();
        if (this.connection != null) {
            this.connection.shutdown();
            this.connection = null;
        }
        try {
            this.isDisconnecting = false;
            SimpleSocketConnectionHandler listener = this.createListener();
            this.connection = this.selector.connect(this.address, listener);
            if (this.connection == null) {
                return false;
            }
            while (listener.connectingStage == SimpleSocketConnectionHandler.ConnectingStage.WAITING) {
                this.listen(1L);
            }
            if (listener.connectingStage == SimpleSocketConnectionHandler.ConnectingStage.UNCONNECTABLE || this.connection.isDisconnected()) {
                this.connection.shutdown();
                this.connection = null;
                return false;
            }
            this.connection.write(ByteBuffer.wrap(new byte[]{13, 10, 13, 10}));
            if (!this.isConnected()) {
                throw new Exception();
            }
            listener.callConnected();
        }
        catch (Exception e) {
            if (this.connection != null) {
                this.connection.shutdown();
                this.connection = null;
            }
            return false;
        }
        return true;
    }

    protected SimpleSocketConnectionHandler createListener() {
        return new SimpleSocketConnectionHandler(this.socketListener, this);
    }

    public void listen() {
        this.listen(100L);
    }

    public void listen(long eventTimeout) {
        this.selector.checkThread();
        if (eventTimeout <= 10L) {
            this.pyroListen(eventTimeout);
            return;
        }
        long startTime = CachedTime.millisSinceStart();
        this.pyroListen(eventTimeout);
        long lastTime = CachedTime.millisSinceStart();
        long timeSpend = lastTime - startTime;
        while (timeSpend < eventTimeout - 10L) {
            this.pyroListen(eventTimeout - timeSpend);
            long newTime = CachedTime.millisSinceStart();
            if (newTime == lastTime) continue;
            lastTime = newTime;
            timeSpend = lastTime - startTime;
        }
    }

    private void pyroListen(long eventTimeout) {
        for (long i = 1L; i <= eventTimeout; ++i) {
            try {
                this.selector.select(1L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setAttachment(Object attachment) {
        this.attachment = attachment;
    }

    public <T> T getAttachment() {
        return (T)this.attachment;
    }

    public boolean hasAttachment() {
        return this.attachment != null;
    }

    public InetSocketAddress getLocalAddress() {
        if (this.connection == null) {
            return null;
        }
        return this.connection.getLocalAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        if (this.connection == null) {
            return null;
        }
        return this.connection.getRemoteAddress();
    }

    public void sendPacket(byte[] ... bytes) {
        this.sendPacket(LowEntry.mergeBytes(bytes));
    }

    public void sendPacket(byte[] bytes) {
        byte[] b;
        byte[] byArray = b = bytes == null ? new byte[]{} : bytes;
        if (this.selector.isNetworkThread()) {
            this.sendPacketCode(b);
        } else {
            this.selector.scheduleTask(() -> this.sendPacketCode(b));
        }
    }

    protected void sendPacketCode(byte[] bytes) {
        if (!this.isConnected()) {
            return;
        }
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.put((byte)(bytes.length >> 24));
        buffer.put((byte)(bytes.length >> 16));
        buffer.put((byte)(bytes.length >> 8));
        buffer.put((byte)bytes.length);
        buffer.flip();
        try {
            this.connection.write(buffer);
            if (bytes.length > 0) {
                this.connection.write(ByteBuffer.wrap(bytes));
            }
        }
        catch (PyroException pyroException) {
            // empty catch block
        }
    }

    public void disconnect() {
        if (this.selector.isNetworkThread()) {
            if (this.isDisconnecting) {
                return;
            }
            this.isDisconnecting = true;
            this.selector.scheduleTask(() -> {
                if (this.connection != null) {
                    this.connection.shutdown();
                    this.connection = null;
                }
            });
        } else {
            this.selector.scheduleTask(() -> {
                if (this.isDisconnecting) {
                    return;
                }
                this.isDisconnecting = true;
                if (this.connection != null) {
                    this.connection.shutdown();
                    this.connection = null;
                }
            });
        }
    }

    public void disconnectImmediately() {
        if (this.selector.isNetworkThread()) {
            if (this.isDisconnecting) {
                return;
            }
            this.isDisconnecting = true;
            this.selector.scheduleTask(() -> {
                if (this.connection != null) {
                    this.connection.dropConnection();
                    this.connection = null;
                }
            });
        } else {
            this.selector.scheduleTask(() -> {
                if (this.isDisconnecting) {
                    return;
                }
                this.isDisconnecting = true;
                if (this.connection != null) {
                    this.connection.dropConnection();
                    this.connection = null;
                }
            });
        }
    }

    public boolean isConnected() {
        this.selector.checkThread();
        return !this.isDisconnecting && this.connection != null && !this.connection.isDisconnected();
    }

    public PyroClient pyro() {
        return this.connection;
    }

    public PyroSelector selector() {
        return this.selector;
    }

    public void execute(Runnable runnable) {
        if (this.selector.isNetworkThread()) {
            runnable.run();
        } else {
            this.selector.scheduleTask(runnable);
        }
    }

    public boolean isNetworkThread() {
        return this.selector.isNetworkThread();
    }

    public String getAddressText() {
        if (this.connection == null) {
            return "closed";
        }
        return this.connection.getAddressText();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getAddressText() + "]";
    }
}

