/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.sockets;

import java.io.IOException;
import java.nio.ByteBuffer;
import lowentry.ue4.classes.sockets.SimpleSocketConnection;
import lowentry.ue4.classes.sockets.SimpleSocketConnectionListener;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.PyroClient;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.events.PyroClientListener;

public class SimpleSocketConnectionHandler
implements PyroClientListener {
    protected final SimpleSocketConnectionListener socketListener;
    protected final SimpleSocketConnection connection;
    protected ConnectingStage connectingStage = ConnectingStage.WAITING;
    protected boolean socketListenerCalledConnected = false;
    protected boolean stopReceivingAnything = false;
    protected byte[] receivingPacket = null;
    protected int receivingPacketPosition = 0;
    protected ByteBuffer receivedIntegerBuffer = ByteBuffer.allocate(4);

    public SimpleSocketConnectionHandler(SimpleSocketConnectionListener socketListener, SimpleSocketConnection connection) {
        this.socketListener = socketListener;
        this.connection = connection;
    }

    @Override
    public void unconnectableClient(PyroClient client) {
        if (this.connectingStage == ConnectingStage.WAITING) {
            this.connectingStage = ConnectingStage.UNCONNECTABLE;
        }
    }

    @Override
    public void connectedClient(PyroClient client) {
        if (this.connectingStage == ConnectingStage.WAITING) {
            this.connectingStage = ConnectingStage.CONNECTED;
        }
    }

    public void callConnected() {
        if (!this.socketListenerCalledConnected) {
            this.socketListenerCalledConnected = true;
            this.socketListener.connected(this.connection);
        }
    }

    @Override
    public void droppedClient(PyroClient client, IOException cause) {
        this.stopReceivingAnything = true;
        this.receivingPacket = null;
        this.receivedIntegerBuffer = null;
        if (this.socketListenerCalledConnected) {
            this.socketListener.disconnected(this.connection);
        }
    }

    @Override
    public void disconnectedClient(PyroClient client) {
        this.stopReceivingAnything = true;
        this.receivingPacket = null;
        this.receivedIntegerBuffer = null;
        if (this.socketListenerCalledConnected) {
            this.socketListener.disconnected(this.connection);
        }
    }

    @Override
    public void sentData(PyroClient client, int bytes) {
    }

    public void disconnect() {
        this.stopReceivingAnything = true;
        this.receivingPacket = null;
        this.receivedIntegerBuffer = null;
        this.connection.disconnect();
    }

    @Override
    public void receivedData(PyroClient client, ByteBuffer data) {
        if (this.stopReceivingAnything) {
            return;
        }
        while (data.hasRemaining()) {
            if (this.receivingPacket == null) {
                while (data.hasRemaining() && this.receivedIntegerBuffer.position() < 4) {
                    this.receivedIntegerBuffer.put(data.get());
                }
                if (this.receivedIntegerBuffer.position() < 4) {
                    return;
                }
                this.receivedIntegerBuffer.flip();
                byte b1 = this.receivedIntegerBuffer.get();
                byte b2 = this.receivedIntegerBuffer.get();
                byte b3 = this.receivedIntegerBuffer.get();
                byte b4 = this.receivedIntegerBuffer.get();
                this.receivedIntegerBuffer.clear();
                int receivingPacketSize = (b1 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
                if (receivingPacketSize < 0) {
                    this.disconnect();
                    return;
                }
                if (receivingPacketSize == 0) continue;
                this.receivingPacket = new byte[receivingPacketSize];
                continue;
            }
            int packetBytesRemaining = this.receivingPacket.length - this.receivingPacketPosition;
            int length = data.remaining();
            if (length <= packetBytesRemaining) {
                data.get(this.receivingPacket, this.receivingPacketPosition, length);
                this.receivingPacketPosition += length;
            } else {
                data.get(this.receivingPacket, this.receivingPacketPosition, packetBytesRemaining);
                this.receivingPacketPosition += packetBytesRemaining;
            }
            if (this.receivingPacketPosition < this.receivingPacket.length) continue;
            this.socketListener.receivedPacket(this.connection, this.receivingPacket);
            this.receivingPacket = null;
            this.receivingPacketPosition = 0;
        }
    }

    protected static enum ConnectingStage {
        WAITING,
        UNCONNECTABLE,
        CONNECTED;

    }
}

