/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.sockets;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;
import lowentry.ue4.classes.internal.CachedTime;
import lowentry.ue4.classes.sockets.SimpleSocketClient;
import lowentry.ue4.classes.sockets.SimpleSocketServer;
import lowentry.ue4.classes.sockets.SimpleSocketServerListener;
import lowentry.ue4.classes.sockets.SocketFunctions;
import lowentry.ue4.library.LowEntry;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.PyroClient;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.PyroException;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.events.PyroClientListener;

public class SimpleSocketServerClientHandler
implements PyroClientListener {
    private static final String WEBSOCKET_KEY_STRING = "Sec-WebSocket-Key:".toLowerCase(Locale.ENGLISH);
    protected final SimpleSocketServerListener socketListener;
    protected final SimpleSocketServer socketServer;
    protected final SimpleSocketClient socketClient;
    protected boolean stopReceivingAnything = false;
    protected final long handshakingStartTime = CachedTime.millisSinceStart();
    protected boolean handshakingPacketComplete = false;
    protected ByteArrayOutputStream handshakingPacket = null;
    protected byte handshakingPacketStage = 0;
    protected WebsocketReceivingData websocket = null;
    protected byte[] receivingPacket = null;
    protected int receivingPacketPosition = 0;
    protected ByteBuffer receivedIntegerBuffer = ByteBuffer.allocate(4);
    protected final int hashCode;

    public SimpleSocketServerClientHandler(SimpleSocketServerListener socketListener, SimpleSocketServer socketServer, SimpleSocketClient socketClient) {
        this.socketListener = socketListener;
        this.socketServer = socketServer;
        this.socketClient = socketClient;
        this.hashCode = super.hashCode();
    }

    @Override
    public void unconnectableClient(PyroClient client) {
        if (SimpleSocketServer.IS_DEBUGGING) {
            SimpleSocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " was unconnectable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectedClient(PyroClient client) {
        if (SimpleSocketServer.IS_DEBUGGING) {
            this.socketClient.saveAddressText();
            SimpleSocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " has connected");
        }
        Collection<SimpleSocketClient> collection = this.socketServer.clients;
        synchronized (collection) {
            this.socketServer.clients.add(this.socketClient);
        }
        this.socketServer.handshakingClientHandlers.add(this);
        this.socketListener.clientConnected(this.socketServer, this.socketClient);
    }

    @Override
    public void droppedClient(PyroClient client, IOException cause) {
        if (SimpleSocketServer.IS_DEBUGGING) {
            SimpleSocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " was dropped:");
            SimpleSocketServer.DEBUGGING_PRINTSTREAM.println(LowEntry.getStackTrace(cause));
        }
        this.hasDisconnected();
    }

    @Override
    public void disconnectedClient(PyroClient client) {
        if (SimpleSocketServer.IS_DEBUGGING) {
            SimpleSocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " was disconnected");
        }
        this.hasDisconnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hasDisconnected() {
        Collection<SimpleSocketClient> collection = this.socketServer.clients;
        synchronized (collection) {
            this.socketServer.clients.remove(this.socketClient);
        }
        if (this.handshakingPacket != null) {
            this.socketServer.handshakingClientHandlers.remove(this);
        }
        this.stopReceivingAnything = true;
        this.receivingPacket = null;
        this.receivedIntegerBuffer = null;
        this.websocket = null;
        this.socketListener.clientDisconnected(this.socketServer, this.socketClient);
    }

    @Override
    public void sentData(PyroClient client, int bytes) {
    }

    public void disconnect() {
        this.stopReceivingAnything = true;
        this.receivingPacket = null;
        this.receivedIntegerBuffer = null;
        this.websocket = null;
        this.socketClient.disconnect();
    }

    private boolean checkWebsocketPacketLength() {
        long totalLength = this.websocket.continuationPacketsTotalLength + this.websocket.payloadRemainingByteCount;
        if (totalLength > Integer.MAX_VALUE) {
            if (SimpleSocketServer.IS_DEBUGGING) {
                SimpleSocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " was prevented from sending a packet, packet size: " + totalLength + " bytes, it's larger than the maximum Java can handle (2147483647)");
            }
            this.disconnect();
            return true;
        }
        int receivingPacketSizeSoFar = (int)totalLength;
        if (receivingPacketSizeSoFar < 0 || !this.socketListener.canReceivePacket(this.socketServer, this.socketClient, receivingPacketSizeSoFar)) {
            if (SimpleSocketServer.IS_DEBUGGING) {
                SimpleSocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " was prevented from sending a packet, packet size: " + receivingPacketSizeSoFar + " bytes");
            }
            this.disconnect();
            return true;
        }
        this.receivingPacket = new byte[(int)this.websocket.payloadRemainingByteCount];
        return false;
    }

    private boolean receiveWebsocketPacket() {
        if (this.websocket.receivingContinuationPacket) {
            if (this.websocket.continuationPackets == null) {
                this.websocket.continuationPackets = new LinkedList();
            }
            this.websocket.continuationPackets.add(this.receivingPacket);
            this.websocket.continuationPacketsTotalLength += (long)this.receivingPacket.length;
        } else {
            if (this.websocket.continuationPackets != null) {
                long totalLength = this.websocket.continuationPacketsTotalLength + (long)this.receivingPacket.length;
                if (totalLength > Integer.MAX_VALUE) {
                    if (SimpleSocketServer.IS_DEBUGGING) {
                        SimpleSocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " was prevented from sending a packet, packet size: " + totalLength + " bytes, it's larger than the maximum Java can handle (2147483647)");
                    }
                    this.disconnect();
                    return true;
                }
                this.websocket.continuationPackets.add(this.receivingPacket);
                this.receivingPacket = LowEntry.mergeBytes(this.websocket.continuationPackets);
                this.websocket.continuationPackets = null;
                this.websocket.continuationPacketsTotalLength = 0L;
            }
            this.socketListener.receivedPacket(this.socketServer, this.socketClient, this.receivingPacket);
        }
        this.receivingPacket = null;
        this.receivingPacketPosition = 0;
        return false;
    }

    @Override
    public void receivedData(PyroClient client, ByteBuffer data) {
        byte b;
        if (this.stopReceivingAnything) {
            return;
        }
        if (!this.handshakingPacketComplete) {
            while (data.hasRemaining()) {
                int websocketKeyEndIndex;
                int websocketKeyStartIndex;
                b = data.get();
                if (this.handshakingPacket == null) {
                    if (this.handshakingPacketStage == 0) {
                        if (b == 13) {
                            this.handshakingPacketStage = (byte)(this.handshakingPacketStage + 1);
                            continue;
                        }
                        this.handshakingPacket = new ByteArrayOutputStream(256);
                        this.handshakingPacket.write(b);
                        continue;
                    }
                    if (this.handshakingPacketStage == 1) {
                        if (b == 10) {
                            this.handshakingPacketStage = (byte)(this.handshakingPacketStage + 1);
                            continue;
                        }
                        this.handshakingPacketStage = 0;
                        this.handshakingPacket = new ByteArrayOutputStream(256);
                        this.handshakingPacket.write(b);
                        continue;
                    }
                    if (this.handshakingPacketStage == 2) {
                        if (b == 13) {
                            this.handshakingPacketStage = (byte)(this.handshakingPacketStage + 1);
                            continue;
                        }
                        this.handshakingPacketStage = 0;
                        this.handshakingPacket = new ByteArrayOutputStream(256);
                        this.handshakingPacket.write(b);
                        continue;
                    }
                    if (this.handshakingPacketStage == 3) {
                        this.handshakingPacketStage = 0;
                        if (b != 10) {
                            this.handshakingPacket = new ByteArrayOutputStream(256);
                            this.handshakingPacket.write(b);
                            continue;
                        }
                    }
                } else {
                    this.handshakingPacket.write(b);
                    if (this.handshakingPacket.size() > 8192) {
                        if (SimpleSocketServer.IS_DEBUGGING) {
                            SimpleSocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " has sent a handshake that is too big, handshakes can't be over 8192 bytes");
                        }
                        this.disconnect();
                        return;
                    }
                    if (this.handshakingPacketStage == 0) {
                        if (b != 13) continue;
                        this.handshakingPacketStage = (byte)(this.handshakingPacketStage + 1);
                        continue;
                    }
                    if (this.handshakingPacketStage == 1) {
                        if (b == 10) {
                            this.handshakingPacketStage = (byte)(this.handshakingPacketStage + 1);
                            continue;
                        }
                        this.handshakingPacketStage = 0;
                        continue;
                    }
                    if (this.handshakingPacketStage == 2) {
                        if (b == 13) {
                            this.handshakingPacketStage = (byte)(this.handshakingPacketStage + 1);
                            continue;
                        }
                        this.handshakingPacketStage = 0;
                        continue;
                    }
                    if (this.handshakingPacketStage == 3) {
                        this.handshakingPacketStage = 0;
                        if (b != 10) continue;
                    }
                }
                this.handshakingPacketComplete = true;
                this.socketServer.handshakingClientHandlers.remove(this);
                if (this.handshakingPacket == null) {
                    if (SimpleSocketServer.IS_DEBUGGING) {
                        SimpleSocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " has completed the handshake: " + LowEntry.toJsonString("\r\n\r\n"));
                        SimpleSocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " is a regular socket");
                    }
                    this.socketClient.onHandshakeCompleted(false);
                    break;
                }
                String header = LowEntry.bytesToStringLatin1(this.handshakingPacket.toByteArray());
                this.handshakingPacket = null;
                if (SimpleSocketServer.IS_DEBUGGING) {
                    SimpleSocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " has completed the handshake: " + LowEntry.toJsonString(header));
                }
                if ((websocketKeyStartIndex = header.toLowerCase(Locale.ENGLISH).indexOf(WEBSOCKET_KEY_STRING)) < 0) {
                    if (SimpleSocketServer.IS_DEBUGGING) {
                        SimpleSocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " is a regular socket");
                    }
                    this.socketClient.onHandshakeCompleted(false);
                    break;
                }
                if (SimpleSocketServer.IS_DEBUGGING) {
                    SimpleSocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " is a websocket");
                }
                if ((websocketKeyEndIndex = header.indexOf(13, websocketKeyStartIndex += WEBSOCKET_KEY_STRING.length())) < 0) {
                    websocketKeyEndIndex = header.length();
                }
                String key = header.substring(websocketKeyStartIndex, websocketKeyEndIndex).trim();
                String responsekey = LowEntry.bytesToBase64(LowEntry.sha1(LowEntry.stringToBytesLatin1(key + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11")));
                String response = "HTTP/1.1 101 Switching Protocols\r\nUpgrade: Websocket\r\nConnection: Upgrade\r\nSec-WebSocket-Accept: " + responsekey + (header.contains("Sec-WebSocket-Protocol:") ? "\r\nSec-WebSocket-Protocol: binary" : "") + "\r\n\r\n";
                try {
                    client.write(ByteBuffer.wrap(LowEntry.stringToBytesLatin1(response)));
                }
                catch (PyroException e) {
                    if (SimpleSocketServer.IS_DEBUGGING) {
                        SimpleSocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " can't be send a handshake response:");
                        SimpleSocketServer.DEBUGGING_PRINTSTREAM.println(LowEntry.getStackTrace(e));
                    }
                    this.disconnect();
                    return;
                }
                this.websocket = new WebsocketReceivingData();
                this.socketClient.onHandshakeCompleted(true);
                break;
            }
        }
        if (this.websocket != null) {
            while (data.hasRemaining()) {
                if (this.websocket.receivingStage == WebsocketReceivingData.WebsocketReceivingStage.RECEIVE_OPCODE) {
                    byte opcode = data.get();
                    opcode = LowEntry.getByteWithBitSet(opcode, 8, false);
                    opcode = LowEntry.getByteWithBitSet(opcode, 7, false);
                    opcode = LowEntry.getByteWithBitSet(opcode, 6, false);
                    if ((opcode = LowEntry.getByteWithBitSet(opcode, 5, false)) == 8) {
                        if (SimpleSocketServer.IS_DEBUGGING) {
                            SimpleSocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " has sent CLOSE (websocket)");
                        }
                        this.disconnect();
                        return;
                    }
                    if (opcode == 9) {
                        this.websocket.pingPacket = new ByteArrayOutputStream();
                        this.websocket.receivingType = WebsocketReceivingData.WebsocketPacketType.PING;
                    } else if (opcode == 10) {
                        this.websocket.receivingType = WebsocketReceivingData.WebsocketPacketType.PONG;
                    } else {
                        this.websocket.receivingContinuationPacket = opcode == 0;
                        this.websocket.receivingType = WebsocketReceivingData.WebsocketPacketType.DATA;
                    }
                    this.websocket.receivingStage = WebsocketReceivingData.WebsocketReceivingStage.RECEIVE_LENGTH_1;
                    continue;
                }
                if (this.websocket.receivingStage == WebsocketReceivingData.WebsocketReceivingStage.RECEIVE_LENGTH_1) {
                    b = data.get();
                    this.websocket.containsMask = LowEntry.isBitSet(b, 8);
                    if (this.websocket.containsMask) {
                        b = LowEntry.getByteWithBitSet(b, 8, false);
                    }
                    this.websocket.sizePacket[0] = b;
                    long size = LowEntry.bytesToLong(this.websocket.sizePacket, 0, 1);
                    if (size == 126L) {
                        this.websocket.receivingStage = WebsocketReceivingData.WebsocketReceivingStage.RECEIVE_LENGTH_2;
                        continue;
                    }
                    if (size == 127L) {
                        this.websocket.receivingStage = WebsocketReceivingData.WebsocketReceivingStage.RECEIVE_LENGTH_8;
                        continue;
                    }
                    this.websocket.payloadRemainingByteCount = size;
                    if (this.websocket.receivingType == WebsocketReceivingData.WebsocketPacketType.DATA && this.checkWebsocketPacketLength()) {
                        return;
                    }
                    this.websocket.receivingStage = WebsocketReceivingData.WebsocketReceivingStage.RECEIVE_MASK;
                    continue;
                }
                if (this.websocket.receivingStage == WebsocketReceivingData.WebsocketReceivingStage.RECEIVE_LENGTH_2) {
                    if (this.websocket.sizePacketIndex == 0 && data.remaining() >= 2) {
                        data.get(this.websocket.sizePacket, 0, 2);
                    } else {
                        while (data.hasRemaining() && this.websocket.sizePacketIndex < 2) {
                            this.websocket.sizePacket[this.websocket.sizePacketIndex] = data.get();
                            this.websocket.sizePacketIndex = (byte)(this.websocket.sizePacketIndex + 1);
                        }
                        if (this.websocket.sizePacketIndex < 2) {
                            return;
                        }
                    }
                    this.websocket.payloadRemainingByteCount = LowEntry.bytesToLong(this.websocket.sizePacket, 0, 2);
                    this.websocket.sizePacketIndex = 0;
                    if (this.websocket.receivingType == WebsocketReceivingData.WebsocketPacketType.DATA && this.checkWebsocketPacketLength()) {
                        return;
                    }
                    this.websocket.receivingStage = WebsocketReceivingData.WebsocketReceivingStage.RECEIVE_MASK;
                    continue;
                }
                if (this.websocket.receivingStage == WebsocketReceivingData.WebsocketReceivingStage.RECEIVE_LENGTH_8) {
                    if (this.websocket.sizePacketIndex == 0 && data.remaining() >= 8) {
                        data.get(this.websocket.sizePacket, 0, 8);
                    } else {
                        while (data.hasRemaining() && this.websocket.sizePacketIndex < 8) {
                            this.websocket.sizePacket[this.websocket.sizePacketIndex] = data.get();
                            this.websocket.sizePacketIndex = (byte)(this.websocket.sizePacketIndex + 1);
                        }
                        if (this.websocket.sizePacketIndex < 8) {
                            return;
                        }
                    }
                    this.websocket.payloadRemainingByteCount = LowEntry.bytesToLong(this.websocket.sizePacket, 0, 8);
                    this.websocket.sizePacketIndex = 0;
                    if (this.websocket.receivingType == WebsocketReceivingData.WebsocketPacketType.DATA && this.checkWebsocketPacketLength()) {
                        return;
                    }
                    this.websocket.receivingStage = WebsocketReceivingData.WebsocketReceivingStage.RECEIVE_MASK;
                    continue;
                }
                if (this.websocket.receivingStage == WebsocketReceivingData.WebsocketReceivingStage.RECEIVE_MASK) {
                    if (this.websocket.containsMask) {
                        if (this.websocket.maskIndex == 0 && data.remaining() >= 4) {
                            data.get(this.websocket.mask, 0, 4);
                        } else {
                            while (data.hasRemaining() && this.websocket.maskIndex < 4) {
                                this.websocket.mask[this.websocket.maskIndex] = data.get();
                                this.websocket.maskIndex = (byte)(this.websocket.maskIndex + 1);
                            }
                            if (this.websocket.maskIndex < 4) {
                                return;
                            }
                        }
                        this.websocket.maskIndex = 0;
                    }
                    this.websocket.receivingStage = WebsocketReceivingData.WebsocketReceivingStage.RECEIVE_PAYLOAD;
                    continue;
                }
                if (this.websocket.receivingStage != WebsocketReceivingData.WebsocketReceivingStage.RECEIVE_PAYLOAD) continue;
                if (this.websocket.receivingType == WebsocketReceivingData.WebsocketPacketType.DATA) {
                    if (this.websocket.payloadRemainingByteCount <= 0L) {
                        if (this.receiveWebsocketPacket()) {
                            return;
                        }
                        this.websocket.receivingStage = WebsocketReceivingData.WebsocketReceivingStage.RECEIVE_OPCODE;
                        continue;
                    }
                    while (data.hasRemaining() && this.websocket.payloadRemainingByteCount > 0L) {
                        b = data.get();
                        --this.websocket.payloadRemainingByteCount;
                        if (this.websocket.containsMask) {
                            b = (byte)(b ^ this.websocket.mask[this.websocket.maskIndex]);
                            this.websocket.maskIndex = this.websocket.maskIndex == 3 ? (byte)0 : (byte)(this.websocket.maskIndex + 1);
                        }
                        this.receivingPacket[this.receivingPacketPosition] = b;
                        ++this.receivingPacketPosition;
                    }
                    if (this.websocket.payloadRemainingByteCount > 0L) break;
                    this.websocket.maskIndex = 0;
                    if (this.receiveWebsocketPacket()) {
                        return;
                    }
                    this.websocket.receivingStage = WebsocketReceivingData.WebsocketReceivingStage.RECEIVE_OPCODE;
                    break;
                }
                if (this.websocket.receivingType == WebsocketReceivingData.WebsocketPacketType.PING) {
                    while (data.hasRemaining() && this.websocket.payloadRemainingByteCount > 0L) {
                        b = data.get();
                        --this.websocket.payloadRemainingByteCount;
                        if (this.websocket.containsMask) {
                            b = (byte)(b ^ this.websocket.mask[this.websocket.maskIndex]);
                            this.websocket.maskIndex = this.websocket.maskIndex == 3 ? (byte)0 : (byte)(this.websocket.maskIndex + 1);
                        }
                        this.websocket.pingPacket.write(b);
                        if (this.websocket.pingPacket.size() <= 8192) continue;
                        if (SimpleSocketServer.IS_DEBUGGING) {
                            SimpleSocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " has sent a ping (websocket) that is too big, pings can't be over 8192 bytes");
                        }
                        this.disconnect();
                        return;
                    }
                    if (this.websocket.payloadRemainingByteCount > 0L) continue;
                    byte[] packet = this.websocket.pingPacket.toByteArray();
                    int size = packet.length;
                    byte opcode = -118;
                    ByteBuffer buffer = ByteBuffer.allocate(1 + SocketFunctions.websocketSizeByteCount(size) + packet.length);
                    buffer.put(opcode);
                    SocketFunctions.putWebsocketSizeBytes(buffer, size);
                    buffer.put(packet);
                    try {
                        client.write(buffer);
                    }
                    catch (PyroException e) {
                        if (SimpleSocketServer.IS_DEBUGGING) {
                            SimpleSocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " can't be send data:");
                            SimpleSocketServer.DEBUGGING_PRINTSTREAM.println(LowEntry.getStackTrace(e));
                        }
                        this.disconnect();
                        return;
                    }
                    this.websocket.pingPacket = null;
                    this.websocket.maskIndex = 0;
                    this.websocket.receivingStage = WebsocketReceivingData.WebsocketReceivingStage.RECEIVE_OPCODE;
                    continue;
                }
                while (data.hasRemaining() && this.websocket.payloadRemainingByteCount > 0L) {
                    data.get();
                    --this.websocket.payloadRemainingByteCount;
                }
                if (this.websocket.payloadRemainingByteCount > 0L) continue;
                this.websocket.receivingStage = WebsocketReceivingData.WebsocketReceivingStage.RECEIVE_OPCODE;
            }
        } else {
            while (data.hasRemaining()) {
                if (this.receivingPacket == null) {
                    while (data.hasRemaining() && this.receivedIntegerBuffer.position() < 4) {
                        this.receivedIntegerBuffer.put(data.get());
                    }
                    if (this.receivedIntegerBuffer.position() < 4) {
                        return;
                    }
                    this.receivedIntegerBuffer.flip();
                    byte b1 = this.receivedIntegerBuffer.get();
                    byte b2 = this.receivedIntegerBuffer.get();
                    byte b3 = this.receivedIntegerBuffer.get();
                    byte b4 = this.receivedIntegerBuffer.get();
                    this.receivedIntegerBuffer.clear();
                    int receivingPacketSize = (b1 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
                    if (receivingPacketSize < 0 || !this.socketListener.canReceivePacket(this.socketServer, this.socketClient, receivingPacketSize)) {
                        if (SimpleSocketServer.IS_DEBUGGING) {
                            SimpleSocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this.socketClient + " has been prevented from sending a packet, packet size: " + receivingPacketSize + " bytes");
                        }
                        this.disconnect();
                        return;
                    }
                    if (receivingPacketSize == 0) continue;
                    this.receivingPacket = new byte[receivingPacketSize];
                    continue;
                }
                int packetBytesRemaining = this.receivingPacket.length - this.receivingPacketPosition;
                int length = data.remaining();
                if (length <= packetBytesRemaining) {
                    data.get(this.receivingPacket, this.receivingPacketPosition, length);
                    this.receivingPacketPosition += length;
                } else {
                    data.get(this.receivingPacket, this.receivingPacketPosition, packetBytesRemaining);
                    this.receivingPacketPosition += packetBytesRemaining;
                }
                if (this.receivingPacketPosition < this.receivingPacket.length) continue;
                this.socketClient.sendPacket(new byte[0]);
                this.socketListener.receivedPacket(this.socketServer, this.socketClient, this.receivingPacket);
                this.receivingPacket = null;
                this.receivingPacketPosition = 0;
            }
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    protected static class WebsocketReceivingData {
        public WebsocketReceivingStage receivingStage = WebsocketReceivingStage.RECEIVE_OPCODE;
        public WebsocketPacketType receivingType = WebsocketPacketType.DATA;
        public final byte[] sizePacket = new byte[8];
        public byte sizePacketIndex = 0;
        public boolean containsMask = false;
        public final byte[] mask = new byte[4];
        public byte maskIndex = 0;
        public long payloadRemainingByteCount = 0L;
        public boolean receivingContinuationPacket = false;
        public LinkedList<byte[]> continuationPackets = null;
        public long continuationPacketsTotalLength = 0L;
        public ByteArrayOutputStream pingPacket = null;

        protected WebsocketReceivingData() {
        }

        protected static enum WebsocketReceivingStage {
            RECEIVE_OPCODE,
            RECEIVE_LENGTH_1,
            RECEIVE_LENGTH_2,
            RECEIVE_LENGTH_8,
            RECEIVE_MASK,
            RECEIVE_PAYLOAD;

        }

        protected static enum WebsocketPacketType {
            DATA,
            PING,
            PONG;

        }
    }
}

